/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine.atoms;

import java.io.Serializable;
import sleep.engine.Block;
import sleep.interfaces.Predicate;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.SleepUtils;

public class Check
implements Serializable {
    private Check iftrue;
    private Check iffalse;
    private Block setup;
    private boolean negate;
    public String name;
    private int hint = -1;

    public String toString(String prefix) {
        StringBuffer temp = new StringBuffer();
        temp.append(prefix);
        temp.append("[Predicate]: ");
        temp.append("name->");
        temp.append(this.name);
        temp.append("  negated->");
        temp.append(this.negate);
        temp.append("\n");
        temp.append(prefix);
        temp.append("   ");
        temp.append("[Setup]: \n");
        temp.append(this.setup.toString(prefix + "      "));
        if (this.iftrue != null) {
            temp.append(prefix);
            temp.append("   [AND]: \n");
            temp.append(this.iftrue.toString(prefix + "      "));
        }
        if (this.iffalse != null) {
            temp.append(prefix);
            temp.append("   [OR]: \n");
            temp.append(this.iffalse.toString(prefix + "      "));
        }
        return temp.toString();
    }

    public String toString() {
        return this.toString("");
    }

    public Check(String n, Block s) {
        if (n.charAt(0) == '!' && n.length() > 2) {
            this.name = n.substring(1, n.length());
            this.negate = true;
        } else {
            this.name = n;
            this.negate = false;
        }
        this.setup = s;
        this.iftrue = null;
        this.iffalse = null;
    }

    public void setChoices(Check t, Check f) {
        if (t != null) {
            this.iftrue = t;
        }
        if (f != null) {
            this.iffalse = f;
        }
    }

    public void setInfo(int _hint) {
        this.hint = _hint;
    }

    public boolean check(ScriptEnvironment env) {
        boolean temp;
        env.CreateFrame();
        this.setup.evaluate(env);
        Predicate choice = env.getPredicate(this.name);
        if (choice == null) {
            env.getScriptInstance().fireWarning("Attempted to use non-existent predicate: " + this.name, this.hint);
            temp = false;
        } else if ((env.getScriptInstance().getDebugFlags() & 0x40) == 64) {
            StringBuffer message = new StringBuffer(64);
            if (env.getCurrentFrame().size() >= 2) {
                message.append(SleepUtils.describe((Scalar)env.getCurrentFrame().get(0)));
                message.append(" ");
                if (this.negate) {
                    message.append("!");
                }
                message.append(this.name);
                message.append(" ");
                message.append(SleepUtils.describe((Scalar)env.getCurrentFrame().get(1)));
            } else if (env.getCurrentFrame().size() == 1) {
                if (this.negate) {
                    message.append("!");
                }
                message.append(this.name);
                message.append(" ");
                message.append(SleepUtils.describe((Scalar)env.getCurrentFrame().get(0)));
            } else {
                message.append("corrupted stack frame: " + this.name);
            }
            temp = choice.decide(this.name, env.getScriptInstance(), env.getCurrentFrame());
            message.append(" ? ");
            if (this.negate) {
                message.append((!temp + "").toUpperCase());
            } else {
                message.append((temp + "").toUpperCase());
            }
            env.getScriptInstance().fireWarning(message.toString(), this.hint, true);
        } else {
            temp = choice.decide(this.name, env.getScriptInstance(), env.getCurrentFrame());
        }
        env.KillFrame();
        if (this.negate) {
            boolean bl = temp = !temp;
        }
        if (temp) {
            if (this.iftrue != null) {
                return this.iftrue.check(env);
            }
            return true;
        }
        if (this.iffalse != null) {
            return this.iffalse.check(env);
        }
        return false;
    }
}

