/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine.atoms;

import sleep.engine.Block;
import sleep.engine.CallRequest;
import sleep.engine.Step;
import sleep.interfaces.Function;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.SleepUtils;

public class Call
extends Step {
    String function;

    public Call(String f) {
        this.function = f;
    }

    public String toString(String prefix) {
        return prefix + "[Function Call]: " + this.function + "\n";
    }

    public Scalar evaluate(ScriptEnvironment e) {
        Function callme = e.getFunction(this.function);
        Block inline = null;
        if (callme != null) {
            CallRequest.FunctionCallRequest request = new CallRequest.FunctionCallRequest(e, this.getLineNumber(), this.function, callme);
            request.CallFunction();
        } else {
            inline = e.getBlock(this.function);
            if (inline != null) {
                CallRequest.InlineCallRequest request = new CallRequest.InlineCallRequest(e, this.getLineNumber(), this.function, inline);
                request.CallFunction();
            } else {
                e.getScriptInstance().fireWarning("Attempted to call non-existent function " + this.function, this.getLineNumber());
                e.FrameResult(SleepUtils.getEmptyScalar());
            }
        }
        return null;
    }
}

