/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine.atoms;

import sleep.engine.Block;
import sleep.engine.Step;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;

public class Assign
extends Step {
    Block variable = null;
    Step operator = null;

    public Assign(Block var, Step op) {
        this.operator = op;
        this.variable = var;
    }

    public Assign(Block var) {
        this(var, null);
    }

    public String toString(String prefix) {
        StringBuffer temp = new StringBuffer();
        temp.append(prefix);
        temp.append("[Assign]:\n");
        temp.append(this.variable.toString(prefix + "   "));
        return temp.toString();
    }

    public Scalar evaluate(ScriptEnvironment e) {
        if (e.getCurrentFrame().size() > 1) {
            throw new RuntimeException("assignment is corrupted, did you forget a semicolon?");
        }
        e.CreateFrame();
        this.variable.evaluate(e);
        Scalar putv = (Scalar)e.getCurrentFrame().pop();
        e.KillFrame();
        Scalar value = (Scalar)e.getCurrentFrame().pop();
        if (this.operator != null) {
            e.CreateFrame();
            e.getCurrentFrame().push(value);
            e.getCurrentFrame().push(putv);
            this.operator.evaluate(e);
            value = (Scalar)e.getCurrentFrame().pop();
        }
        putv.setValue(value);
        e.FrameResult(value);
        return null;
    }
}

