/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Stack;
import sleep.bridges.SleepClosure;
import sleep.engine.Block;
import sleep.engine.ObjectUtilities;
import sleep.interfaces.Function;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.ScriptVariables;
import sleep.runtime.SleepUtils;

public class ProxyInterface
implements InvocationHandler {
    protected ScriptInstance script;
    protected Function func;

    public ProxyInterface(Function _method, ScriptInstance _script) {
        this.func = _method;
        this.script = _script;
    }

    public ScriptInstance getOwner() {
        return this.script;
    }

    public static Object BuildInterface(Class className, Function subroutine, ScriptInstance script) {
        return ProxyInterface.BuildInterface(new Class[]{className}, subroutine, script);
    }

    public static Object BuildInterface(Class[] classes, Function subroutine, ScriptInstance script) {
        ProxyInterface temp = new ProxyInterface(subroutine, script);
        return Proxy.newProxyInstance(classes[0].getClassLoader(), classes, (InvocationHandler)temp);
    }

    public static Object BuildInterface(Class className, Block block, ScriptInstance script) {
        return ProxyInterface.BuildInterface(className, (Function)new SleepClosure(script, block), script);
    }

    public static Object BuildInterface(Class[] classes, Block block, ScriptInstance script) {
        return ProxyInterface.BuildInterface(classes, (Function)new SleepClosure(script, block), script);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ScriptVariables scriptVariables = this.script.getScriptVariables();
        synchronized (scriptVariables) {
            Scalar value;
            this.script.getScriptEnvironment().pushSource("<Java>");
            Stack<Scalar> temp = new Stack<Scalar>();
            boolean isTrace = (this.script.getDebugFlags() & 8) == 8;
            StringBuffer message = null;
            if (args != null) {
                for (int z = args.length - 1; z >= 0; --z) {
                    temp.push(ObjectUtilities.BuildScalar(true, args[z]));
                }
            }
            this.script.getScriptEnvironment().installExceptionHandler(null, null, null);
            if (isTrace) {
                if (!this.script.isProfileOnly()) {
                    message = new StringBuffer("[" + this.func + " " + method.getName());
                    if (!temp.isEmpty()) {
                        message.append(": " + SleepUtils.describe(temp));
                    }
                    message.append("]");
                }
                long stat = System.currentTimeMillis();
                value = this.func.evaluate(method.getName(), this.script, temp);
                stat = System.currentTimeMillis() - stat;
                if (this.func.getClass() == SleepClosure.class) {
                    this.script.collect(((SleepClosure)this.func).toStringGeneric(), -1, stat);
                }
                if (message != null) {
                    if (this.script.getScriptEnvironment().isThrownValue()) {
                        message.append(" - FAILED!");
                    } else {
                        message.append(" = " + SleepUtils.describe(value));
                    }
                    this.script.fireWarning(message.toString(), -1, true);
                }
            } else {
                value = this.func.evaluate(method.getName(), this.script, temp);
            }
            this.script.getScriptEnvironment().popExceptionContext();
            this.script.getScriptEnvironment().clearReturn();
            this.script.getScriptEnvironment().popSource();
            if (this.script.getScriptEnvironment().isThrownValue()) {
                this.script.recordStackFrame(this.func + " as " + method.toString(), "<Java>", -1);
                Object exvalue = this.script.getScriptEnvironment().getExceptionMessage().objectValue();
                if (exvalue instanceof Throwable) {
                    throw (Throwable)exvalue;
                }
                throw new RuntimeException(exvalue.toString());
            }
            if (value != null) {
                return ObjectUtilities.buildArgument(method.getReturnType(), value, this.script);
            }
            return null;
        }
    }
}

