/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import sleep.bridges.BridgeUtilities;
import sleep.engine.ProxyInterface;
import sleep.engine.types.DoubleValue;
import sleep.engine.types.IntValue;
import sleep.engine.types.LongValue;
import sleep.engine.types.ObjectValue;
import sleep.engine.types.StringValue;
import sleep.interfaces.Function;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarArray;
import sleep.runtime.ScalarHash;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;
import sleep.runtime.WatchScalar;

public class ObjectUtilities {
    private static Class STRING_SCALAR = StringValue.class;
    private static Class INT_SCALAR = IntValue.class;
    private static Class DOUBLE_SCALAR = DoubleValue.class;
    private static Class LONG_SCALAR = LongValue.class;
    private static Class OBJECT_SCALAR = ObjectValue.class;
    public static final int ARG_MATCH_YES = 3;
    public static final int ARG_MATCH_NO = 0;
    public static final int ARG_MATCH_MAYBE = 1;

    public static int isArgMatch(Class[] check, Stack arguments) {
        int value = 3;
        for (int z = 0; z < check.length; ++z) {
            Scalar scalar = (Scalar)arguments.get(check.length - z - 1);
            if ((value &= ObjectUtilities.isArgMatch(check[z], scalar)) != 0) continue;
            return 0;
        }
        return value;
    }

    private static Class normalizePrimitive(Class check) {
        if (check == Integer.TYPE) {
            check = Integer.class;
        } else if (check == Double.TYPE) {
            check = Double.class;
        } else if (check == Long.TYPE) {
            check = Long.class;
        } else if (check == Float.TYPE) {
            check = Float.class;
        } else if (check == Boolean.TYPE) {
            check = Boolean.class;
        } else if (check == Byte.TYPE) {
            check = Byte.class;
        } else if (check == Character.TYPE) {
            check = Character.class;
        } else if (check == Short.TYPE) {
            check = Short.class;
        }
        return check;
    }

    public static int isArgMatch(Class check, Scalar scalar) {
        if (SleepUtils.isEmptyScalar(scalar)) {
            return 3;
        }
        if (scalar.getArray() != null) {
            if (check.isArray()) {
                Class<?> compType = check.getComponentType();
                while (compType.isArray()) {
                    compType = compType.getComponentType();
                }
                Class mytype = ObjectUtilities.getArrayType(scalar, null);
                if (mytype != null && compType.isAssignableFrom(mytype)) {
                    return 3;
                }
                return 0;
            }
            if (check == List.class || check == Collection.class) {
                return 3;
            }
            if (check == ScalarArray.class) {
                return 3;
            }
            if (check == Object.class) {
                return 1;
            }
            return 0;
        }
        if (scalar.getHash() != null) {
            if (check == Map.class) {
                return 3;
            }
            if (check == ScalarHash.class) {
                return 3;
            }
            if (check == Object.class) {
                return 1;
            }
            return 0;
        }
        if (check.isPrimitive()) {
            Class stemp = scalar.getActualValue().getType();
            if (stemp == INT_SCALAR && check == Integer.TYPE) {
                return 3;
            }
            if (stemp == DOUBLE_SCALAR && check == Double.TYPE) {
                return 3;
            }
            if (stemp == LONG_SCALAR && check == Long.TYPE) {
                return 3;
            }
            if (check == Character.TYPE && stemp == STRING_SCALAR && ((Object)scalar.getActualValue()).toString().length() == 1) {
                return 3;
            }
            if (stemp == OBJECT_SCALAR) {
                check = ObjectUtilities.normalizePrimitive(check);
                return scalar.objectValue().getClass() == check ? 3 : 0;
            }
            return stemp == STRING_SCALAR ? 0 : 1;
        }
        if (check.isInterface()) {
            if (SleepUtils.isFunctionScalar(scalar) || check.isInstance(scalar.objectValue())) {
                return 3;
            }
            return 0;
        }
        if (check == String.class) {
            Class stemp = scalar.getActualValue().getType();
            return stemp == STRING_SCALAR ? 3 : 1;
        }
        if (check == Object.class) {
            return 1;
        }
        if (check.isInstance(scalar.objectValue())) {
            Class stemp = scalar.getActualValue().getType();
            return stemp == OBJECT_SCALAR ? 3 : 1;
        }
        if (check.isArray()) {
            Class stemp = scalar.getActualValue().getType();
            if (stemp == STRING_SCALAR && (check.getComponentType() == Character.TYPE || check.getComponentType() == Byte.TYPE)) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public static Method findMethod(Class theClass, String method, Stack arguments) {
        int size = arguments.size();
        Method temp = null;
        Method[] methods = theClass.getMethods();
        for (int x = 0; x < methods.length; ++x) {
            if (!methods[x].getName().equals(method) || methods[x].getParameterTypes().length != size) continue;
            if (size == 0) {
                return methods[x];
            }
            int value = ObjectUtilities.isArgMatch(methods[x].getParameterTypes(), arguments);
            if (value == 3) {
                return methods[x];
            }
            if (value != 1) continue;
            temp = methods[x];
        }
        return temp;
    }

    public static Constructor findConstructor(Class theClass, Stack arguments) {
        int size = arguments.size();
        Constructor<?> temp = null;
        Constructor<?>[] constructors = theClass.getConstructors();
        for (int x = 0; x < constructors.length; ++x) {
            if (constructors[x].getParameterTypes().length != size) continue;
            if (size == 0) {
                return constructors[x];
            }
            int value = ObjectUtilities.isArgMatch(constructors[x].getParameterTypes(), arguments);
            if (value == 3) {
                return constructors[x];
            }
            if (value != 1) continue;
            temp = constructors[x];
        }
        return temp;
    }

    public static Class convertScalarDescriptionToClass(Scalar description) {
        if (description.objectValue() instanceof Class) {
            return (Class)description.objectValue();
        }
        return ObjectUtilities.convertDescriptionToClass(description.toString());
    }

    public static Class convertDescriptionToClass(String description) {
        if (description.length() != 1) {
            return null;
        }
        Class atype = null;
        switch (description.charAt(0)) {
            case 'z': {
                atype = Boolean.TYPE;
                break;
            }
            case 'c': {
                atype = Character.TYPE;
                break;
            }
            case 'b': {
                atype = Byte.TYPE;
                break;
            }
            case 'h': {
                atype = Short.TYPE;
                break;
            }
            case 'i': {
                atype = Integer.TYPE;
                break;
            }
            case 'l': {
                atype = Long.TYPE;
                break;
            }
            case 'f': {
                atype = Float.TYPE;
                break;
            }
            case 'd': {
                atype = Double.TYPE;
                break;
            }
            case 'o': {
                atype = Object.class;
                break;
            }
            case '*': {
                atype = null;
            }
        }
        return atype;
    }

    public static Object buildArgument(Class type, Scalar value, ScriptInstance script) {
        if (type == String.class) {
            return SleepUtils.isEmptyScalar(value) ? null : value.toString();
        }
        if (value.getArray() != null) {
            if (type.isArray()) {
                Class atype = ObjectUtilities.getArrayType(value, type.getComponentType());
                Object arrayV = Array.newInstance(atype, value.getArray().size());
                Iterator i = value.getArray().scalarIterator();
                int x = 0;
                while (i.hasNext()) {
                    Scalar temp = (Scalar)i.next();
                    Object blah = ObjectUtilities.buildArgument(atype, temp, script);
                    if (!(blah == null && !atype.isPrimitive() || atype.isInstance(blah) || atype.isPrimitive())) {
                        if (atype.isArray()) {
                            throw new RuntimeException("incorrect dimensions for conversion to " + type);
                        }
                        throw new RuntimeException(SleepUtils.describe(temp) + " at " + x + " is not compatible with " + atype.getName());
                    }
                    Array.set(arrayV, x, blah);
                    ++x;
                }
                return arrayV;
            }
            if (type == ScalarArray.class) {
                return value.objectValue();
            }
            return SleepUtils.getListFromArray(value);
        }
        if (value.getHash() != null) {
            if (type == ScalarHash.class) {
                return value.objectValue();
            }
            return SleepUtils.getMapFromHash(value);
        }
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return value.intValue() != 0;
            }
            if (type == Byte.TYPE) {
                return new Byte((byte)value.intValue());
            }
            if (type == Character.TYPE) {
                return new Character(value.toString().charAt(0));
            }
            if (type == Double.TYPE) {
                return new Double(value.doubleValue());
            }
            if (type == Float.TYPE) {
                return new Float((float)value.doubleValue());
            }
            if (type == Integer.TYPE) {
                return new Integer(value.intValue());
            }
            if (type == Short.TYPE) {
                return new Short((short)value.intValue());
            }
            if (type == Long.TYPE) {
                return new Long(value.longValue());
            }
        } else {
            if (SleepUtils.isEmptyScalar(value)) {
                return null;
            }
            if (type.isArray() && value.getActualValue().getType() == StringValue.class) {
                if (type.getComponentType() == Byte.TYPE || type.getComponentType() == Byte.class) {
                    return BridgeUtilities.toByteArrayNoConversion(value.toString());
                }
                if (type.getComponentType() == Character.TYPE || type.getComponentType() == Character.class) {
                    return value.toString().toCharArray();
                }
            } else if (type.isInterface() && SleepUtils.isFunctionScalar(value)) {
                return ProxyInterface.BuildInterface(type, (Function)SleepUtils.getFunctionFromScalar(value, script), script);
            }
        }
        return value.objectValue();
    }

    public static String buildArgumentErrorMessage(Class theClass, String method, Class[] expected, Object[] parameters) {
        StringBuffer tempa = new StringBuffer(method + "(");
        for (int x = 0; x < expected.length; ++x) {
            tempa.append(expected[x].getName());
            if (x + 1 >= expected.length) continue;
            tempa.append(", ");
        }
        tempa.append(")");
        StringBuffer tempb = new StringBuffer("(");
        for (int x = 0; x < parameters.length; ++x) {
            if (parameters[x] != null) {
                tempb.append(parameters[x].getClass().getName());
            } else {
                tempb.append("null");
            }
            if (x + 1 >= parameters.length) continue;
            tempb.append(", ");
        }
        tempb.append(")");
        return "bad arguments " + tempb.toString() + " for " + tempa.toString() + " in " + theClass;
    }

    public static Object[] buildArgumentArray(Class[] types, Stack arguments, ScriptInstance script) {
        Object[] parameters = new Object[types.length];
        for (int x = 0; x < parameters.length; ++x) {
            Scalar temp = (Scalar)arguments.pop();
            parameters[x] = ObjectUtilities.buildArgument(types[x], temp, script);
        }
        return parameters;
    }

    public static Scalar BuildScalar(boolean primitives, Object value) {
        if (value == null) {
            return SleepUtils.getEmptyScalar();
        }
        Class check = value.getClass();
        if (check.isArray()) {
            if (check.getComponentType() == Byte.TYPE || check.getComponentType() == Byte.class) {
                return SleepUtils.getScalar((byte[])value);
            }
            if (check.getComponentType() == Character.TYPE || check.getComponentType() == Character.class) {
                return SleepUtils.getScalar(new String((char[])value));
            }
            Scalar array2 = SleepUtils.getArrayScalar();
            for (int x = 0; x < Array.getLength(value); ++x) {
                array2.getArray().push(ObjectUtilities.BuildScalar(true, Array.get(value, x)));
            }
            return array2;
        }
        if (primitives) {
            if (check.isPrimitive()) {
                check = ObjectUtilities.normalizePrimitive(check);
            }
            if (check == Boolean.class) {
                return SleepUtils.getScalar((Boolean)value != false ? 1 : 0);
            }
            if (check == Byte.class) {
                return SleepUtils.getScalar((int)((Byte)value).byteValue());
            }
            if (check == Character.class) {
                return SleepUtils.getScalar(value.toString());
            }
            if (check == Double.class) {
                return SleepUtils.getScalar((Double)value);
            }
            if (check == Float.class) {
                return SleepUtils.getScalar((double)((Float)value).floatValue());
            }
            if (check == Integer.class) {
                return SleepUtils.getScalar((Integer)value);
            }
            if (check == Long.class) {
                return SleepUtils.getScalar((Long)value);
            }
        }
        if (check == String.class) {
            return SleepUtils.getScalar(value.toString());
        }
        if (check == Scalar.class || check == WatchScalar.class) {
            return (Scalar)value;
        }
        return SleepUtils.getScalar(value);
    }

    public static Class getArrayType(Scalar value, Class defaultc) {
        if (value.getArray() != null && value.getArray().size() > 0 && (defaultc == null || defaultc == Object.class)) {
            for (int x = 0; x < value.getArray().size(); ++x) {
                if (value.getArray().getAt(x).getArray() != null) {
                    return ObjectUtilities.getArrayType(value.getArray().getAt(x), defaultc);
                }
                Class<?> elem = value.getArray().getAt(x).getValue().getClass();
                Object tempo = value.getArray().getAt(x).objectValue();
                if (elem == DOUBLE_SCALAR) {
                    return Double.TYPE;
                }
                if (elem == INT_SCALAR) {
                    return Integer.TYPE;
                }
                if (elem == LONG_SCALAR) {
                    return Long.TYPE;
                }
                if (tempo == null) continue;
                return tempo.getClass();
            }
        }
        return defaultc;
    }

    public static void handleExceptionFromJava(Throwable ex, ScriptEnvironment env, String description, int lineNumber) {
        if (ex != null) {
            env.flagError(ex);
            if (env.isThrownValue() && description != null && description.length() > 0) {
                env.getScriptInstance().recordStackFrame(description, lineNumber);
            }
        }
    }
}

