/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import sleep.bridges.BridgeUtilities;
import sleep.bridges.SleepClosure;
import sleep.engine.Block;
import sleep.interfaces.Function;
import sleep.interfaces.Variable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.ScriptVariables;
import sleep.runtime.SleepUtils;

public abstract class CallRequest {
    protected ScriptEnvironment environment;
    protected int lineNumber;

    public CallRequest(ScriptEnvironment e, int lineNo) {
        this.environment = e;
        this.lineNumber = lineNo;
    }

    protected ScriptEnvironment getScriptEnvironment() {
        return this.environment;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public abstract String getFunctionName();

    public abstract String getFrameDescription();

    protected abstract Scalar execute();

    protected abstract String formatCall(String var1);

    public boolean isDebug() {
        return (this.getScriptEnvironment().getScriptInstance().getDebugFlags() & 8) == 8;
    }

    /*
     * Unable to fully structure code
     */
    public void CallFunction() {
        block17: {
            temp = null;
            e = this.getScriptEnvironment();
            mark = this.getScriptEnvironment().markFrame();
            if (this.isDebug() && this.getLineNumber() != -2147483648) {
                if (e.getScriptInstance().isProfileOnly()) {
                    try {
                        total = e.getScriptInstance().total();
                        stat = System.currentTimeMillis();
                        temp = this.execute();
                        stat = System.currentTimeMillis() - stat - (e.getScriptInstance().total() - total);
                        e.getScriptInstance().collect(this.getFunctionName(), this.getLineNumber(), stat);
                    }
                    catch (RuntimeException rex) {
                        if (rex.getCause() != null && InvocationTargetException.class.isInstance(rex.getCause())) ** GOTO lbl50
                        e.cleanFrame(mark);
                        e.KillFrame();
                        throw rex;
                    }
                } else {
                    args = SleepUtils.describe(e.getCurrentFrame());
                    try {
                        total = e.getScriptInstance().total();
                        stat = System.currentTimeMillis();
                        temp = this.execute();
                        stat = System.currentTimeMillis() - stat - (e.getScriptInstance().total() - total);
                        e.getScriptInstance().collect(this.getFunctionName(), this.getLineNumber(), stat);
                        if (e.isThrownValue()) {
                            e.getScriptInstance().fireWarning(this.formatCall(args) + " - FAILED!", this.getLineNumber(), true);
                        }
                        if (e.isPassControl()) {
                            e.getScriptInstance().fireWarning(this.formatCall(args) + " -goto- " + SleepUtils.describe(temp), this.getLineNumber(), true);
                        }
                        if (SleepUtils.isEmptyScalar(temp)) {
                            e.getScriptInstance().fireWarning(this.formatCall(args), this.getLineNumber(), true);
                        }
                        e.getScriptInstance().fireWarning(this.formatCall(args) + " = " + SleepUtils.describe(temp), this.getLineNumber(), true);
                    }
                    catch (RuntimeException rex) {
                        e.getScriptInstance().fireWarning(this.formatCall(args) + " - FAILED!", this.getLineNumber(), true);
                        if (rex.getCause() != null && InvocationTargetException.class.isInstance(rex.getCause())) ** GOTO lbl50
                        e.cleanFrame(mark);
                        e.KillFrame();
                        throw rex;
                    }
                }
            } else {
                try {
                    temp = this.execute();
                }
                catch (RuntimeException rex) {
                    if (rex.getCause() != null && InvocationTargetException.class.isInstance(rex.getCause())) break block17;
                    e.cleanFrame(mark);
                    e.KillFrame();
                    throw rex;
                }
            }
        }
        if (e.isThrownValue()) {
            e.getScriptInstance().recordStackFrame(this.getFrameDescription(), this.getLineNumber());
        }
        if (temp == null) {
            temp = SleepUtils.getEmptyScalar();
        }
        e.cleanFrame(mark);
        e.FrameResult(temp);
        if (e.isPassControl()) {
            callme = temp;
            e.pushSource(((SleepClosure)callme.objectValue()).getAndRemoveMetadata("sourceFile", "<unknown>") + "");
            lno = (Integer)((SleepClosure)callme.objectValue()).getAndRemoveMetadata("sourceLine", new Integer(-1));
            if (e.markFrame() >= 0 && (check = e.getCurrentFrame().pop()) != temp) {
                e.getScriptInstance().fireWarning("bad callcc stack: " + SleepUtils.describe((Scalar)check) + " expected " + SleepUtils.describe(temp), lno);
            }
            e.flagReturn(null, 0);
            e.CreateFrame();
            e.getCurrentFrame().push(((SleepClosure)callme.objectValue()).getAndRemoveMetadata("continuation", null));
            request = new ClosureCallRequest(this.environment, lno, callme, "CALLCC");
            request.CallFunction();
            e.popSource();
        }
    }

    public static class InlineCallRequest
    extends CallRequest {
        protected String function;
        protected Block inline;

        public InlineCallRequest(ScriptEnvironment e, int lineNo, String functionName, Block i) {
            super(e, lineNo);
            this.function = functionName;
            this.inline = i;
        }

        public String getFunctionName() {
            return "<inline> " + this.function;
        }

        public String getFrameDescription() {
            return "<inline> " + this.function + "()";
        }

        protected String formatCall(String args) {
            return "<inline> " + this.function + "(" + args + ")";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Scalar execute() {
            ScriptVariables vars;
            ScriptVariables scriptVariables = vars = this.getScriptEnvironment().getScriptVariables();
            synchronized (scriptVariables) {
                Variable localLevel = vars.getLocalVariables();
                Scalar oldargs = localLevel.getScalar("@_");
                int targs = BridgeUtilities.initLocalScope(vars, localLevel, this.getScriptEnvironment().getCurrentFrame());
                Scalar eval2 = this.inline.evaluate(this.getScriptEnvironment());
                if (oldargs != null) {
                    localLevel.putScalar("@_", oldargs);
                    if (targs > 0) {
                        Iterator i = oldargs.getArray().scalarIterator();
                        for (int count = 1; i.hasNext() && count <= targs; ++count) {
                            Scalar temp = (Scalar)i.next();
                            localLevel.putScalar("$" + count, temp);
                        }
                    }
                }
                return eval2;
            }
        }
    }

    public static class FunctionCallRequest
    extends CallRequest {
        protected String function;
        protected Function callme;

        public FunctionCallRequest(ScriptEnvironment e, int lineNo, String functionName, Function f) {
            super(e, lineNo);
            this.function = functionName;
            this.callme = f;
        }

        public String getFunctionName() {
            return this.function;
        }

        public String getFrameDescription() {
            return this.function + "()";
        }

        public String formatCall(String args) {
            return this.function + "(" + args + ")";
        }

        public boolean isDebug() {
            return super.isDebug() && !this.function.equals("&@") && !this.function.equals("&%") && !this.function.equals("&warn");
        }

        protected Scalar execute() {
            Scalar temp = this.callme.evaluate(this.function, this.getScriptEnvironment().getScriptInstance(), this.getScriptEnvironment().getCurrentFrame());
            this.getScriptEnvironment().clearReturn();
            return temp;
        }
    }

    public static class ClosureCallRequest
    extends CallRequest {
        protected String name;
        protected Scalar scalar;

        public ClosureCallRequest(ScriptEnvironment e, int lineNo, Scalar _scalar, String _name) {
            super(e, lineNo);
            this.scalar = _scalar;
            this.name = _name;
        }

        public String getFunctionName() {
            return ((SleepClosure)this.scalar.objectValue()).toStringGeneric();
        }

        public String getFrameDescription() {
            return this.scalar.toString();
        }

        public String formatCall(String args) {
            StringBuffer buffer = new StringBuffer("[" + SleepUtils.describe(this.scalar));
            if (this.name != null && this.name.length() > 0) {
                buffer.append(" " + this.name);
            }
            if (args.length() > 0) {
                buffer.append(": " + args);
            }
            buffer.append("]");
            return buffer.toString();
        }

        protected Scalar execute() {
            SleepClosure func = SleepUtils.getFunctionFromScalar(this.scalar, this.getScriptEnvironment().getScriptInstance());
            Scalar result = func.evaluate(this.name, this.getScriptEnvironment().getScriptInstance(), this.getScriptEnvironment().getCurrentFrame());
            this.getScriptEnvironment().clearReturn();
            return result;
        }
    }
}

