/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine;

import java.io.File;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import sleep.engine.Step;
import sleep.engine.atoms.Goto;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.SleepUtils;

public class Block
implements Serializable {
    protected Step first;
    protected Step last;
    protected String source = "unknown";

    public Block(String _src) {
        this.source = _src;
    }

    public String toString(String prefix) {
        StringBuffer tempz = new StringBuffer();
        Step temp = this.first;
        while (temp != null) {
            tempz.append(temp.toString(prefix));
            temp = temp.next;
        }
        return tempz.toString();
    }

    public String toString() {
        return this.toString("");
    }

    public String getSource() {
        return this.source;
    }

    public int getApproximateLineNumber() {
        if (this.first != null) {
            return this.first.getLineNumber();
        }
        return -1;
    }

    public int getHighLineNumber() {
        int high = 0;
        Step temp = this.first;
        while (temp != null) {
            int m = temp.getHighLineNumber();
            if (m > high) {
                high = m;
            }
            temp = temp.next;
        }
        return high;
    }

    public int getLowLineNumber() {
        int low = Integer.MAX_VALUE;
        Step temp = this.first;
        while (temp != null) {
            int m = temp.getLowLineNumber();
            if (m < low) {
                low = m;
            }
            temp = temp.next;
        }
        return low;
    }

    public String getApproximateLineRange() {
        int high;
        int low = this.getLowLineNumber();
        if (low == (high = this.getHighLineNumber())) {
            return low + "";
        }
        return low + "-" + high;
    }

    public String getSourceLocation() {
        return new File(this.source).getName() + ":" + this.getApproximateLineRange();
    }

    public void add(Step n) {
        if (this.first == null) {
            this.first = n;
        } else {
            this.last.next = n;
        }
        this.last = n;
    }

    public Scalar evaluate(ScriptEnvironment environment) {
        return this.evaluate(environment, this.first);
    }

    private void handleException(ScriptEnvironment environment) {
        if (environment.isResponsible(this)) {
            Block doit = environment.getExceptionHandler();
            doit.evaluate(environment);
            environment.getScriptInstance().clearStackTrace();
        }
    }

    private void cleanupEnvironment(ScriptEnvironment environment) {
        environment.popSource();
        if (environment.isResponsible(this)) {
            environment.popExceptionContext();
        }
    }

    public Scalar evaluate(ScriptEnvironment environment, Step start) {
        if (environment.isReturn()) {
            if (environment.isThrownValue()) {
                environment.pushSource(this.source);
                this.handleException(environment);
                this.cleanupEnvironment(environment);
            }
            return environment.getReturnValue();
        }
        environment.pushSource(this.source);
        Step temp = start;
        while (temp != null) {
            try {
                temp.evaluate(environment);
            }
            catch (Exception ex) {
                if (ex instanceof IllegalArgumentException) {
                    environment.getScriptInstance().fireWarning(ex.getMessage(), temp.getLineNumber());
                } else if (ex instanceof IndexOutOfBoundsException) {
                    if (ex.getMessage() != null) {
                        environment.getScriptInstance().fireWarning("attempted an invalid index: " + ex.getMessage(), temp.getLineNumber());
                    } else {
                        environment.getScriptInstance().fireWarning("attempted an invalid index", temp.getLineNumber());
                    }
                } else if (ex instanceof ClassCastException) {
                    environment.getScriptInstance().fireWarning("attempted an invalid cast: " + ex.getMessage(), temp.getLineNumber());
                } else if (ex instanceof NullPointerException) {
                    environment.getScriptInstance().fireWarning("null value error", temp.getLineNumber());
                } else if (ex instanceof ConcurrentModificationException) {
                    if (ex.getMessage() != null) {
                        environment.getScriptInstance().fireWarning("unsafe data modification: " + ex.getMessage(), temp.getLineNumber());
                    } else {
                        environment.getScriptInstance().fireWarning("detected unsafe data modification", temp.getLineNumber());
                    }
                } else if (ex instanceof RuntimeException) {
                    if (ex.getMessage() == null) {
                        environment.getScriptInstance().fireWarning("internal error - " + ex.getClass(), temp.getLineNumber());
                    } else {
                        environment.getScriptInstance().fireWarning(ex.getMessage(), temp.getLineNumber());
                    }
                } else {
                    environment.getScriptInstance().fireWarning(ex.toString(), temp.getLineNumber());
                }
                this.cleanupEnvironment(environment);
                return SleepUtils.getEmptyScalar();
            }
            catch (Error th) {
                environment.getScriptInstance().fireWarning("critical internal error - " + th.toString(), temp.getLineNumber());
                this.cleanupEnvironment(environment);
                throw th;
            }
            while (environment.isReturn()) {
                if (environment.isYield()) {
                    if (temp instanceof Goto) {
                        environment.addToContext(this, temp);
                    } else {
                        environment.addToContext(this, temp.next);
                    }
                }
                if (environment.isCallCC()) {
                    environment.getCurrentFrame().push(this.source);
                    environment.getCurrentFrame().push(new Integer(temp.getLineNumber()));
                }
                if (environment.isThrownValue()) {
                    if (!environment.isExceptionHandlerInstalled()) {
                        if (!SleepUtils.isEmptyScalar(environment.getReturnValue())) {
                            environment.getScriptInstance().fireWarning("Uncaught exception: " + environment.getExceptionMessage(), temp.getLineNumber());
                            environment.flagReturn(null, 16);
                        }
                    } else if (!SleepUtils.isEmptyScalar(environment.getReturnValue())) {
                        this.handleException(environment);
                    }
                    this.cleanupEnvironment(environment);
                    return environment.getReturnValue();
                }
                if (environment.isDebugInterrupt()) {
                    environment.getScriptInstance().fireWarning(environment.getDebugString(), temp.getLineNumber());
                    continue;
                }
                this.cleanupEnvironment(environment);
                return environment.getReturnValue();
            }
            temp = temp.next;
        }
        this.cleanupEnvironment(environment);
        return SleepUtils.getEmptyScalar();
    }
}

