/*
 * Decompiled with CFR 0.152.
 */
package sleep.console;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Hashtable;
import sleep.console.ConsoleImplementation;
import sleep.console.ConsoleProxy;
import sleep.error.YourCodeSucksException;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.ScriptLoader;
import sleep.runtime.SleepUtils;
import sleep.taint.TaintUtils;

public class TextConsole
implements ConsoleProxy {
    BufferedReader in = new BufferedReader(new InputStreamReader(System.in));

    public static void main(String[] args) {
        ScriptLoader loader = new ScriptLoader();
        ConsoleImplementation temp = new ConsoleImplementation(null, null, loader);
        temp.setProxy(new TextConsole());
        if (args.length > 0) {
            int start;
            boolean check = false;
            boolean ast = false;
            boolean eval2 = false;
            boolean expr2 = false;
            boolean prof = false;
            boolean time = false;
            for (start = 0; start < args.length && (args[start].startsWith("--") || args[start].length() >= 2 && args[start].charAt(0) == '-'); ++start) {
                if (args[start].equals("-version") || args[start].equals("--version") || args[start].equals("-v")) {
                    System.out.println("Sleep 2.1 (20080701)");
                    return;
                }
                if (args[start].equals("-help") || args[start].equals("--help") || args[start].equals("-h")) {
                    System.out.println("Sleep 2.1 (20080701)");
                    System.out.println("Usage: java [properties] -jar sleep.jar [options] [-|file|expression]");
                    System.out.println("       properties:");
                    System.out.println("         -Dsleep.assert=<true|false>");
                    System.out.println("         -Dsleep.classpath=<path to locate 3rd party jars from>");
                    System.out.println("         -Dsleep.debug=<debug level>");
                    System.out.println("         -Dsleep.taint=<true|false>");
                    System.out.println("       options:");
                    System.out.println("         -a --ast       display the abstract syntax tree of the specified script");
                    System.out.println("         -c --check     check the syntax of the specified file");
                    System.out.println("         -e --eval      evaluate a script as specified on command line");
                    System.out.println("         -h --help      display this help message");
                    System.out.println("         -p --profile   collect and display runtime profile statistics");
                    System.out.println("         -t --time      display total script runtime");
                    System.out.println("         -v --version   display version information");
                    System.out.println("         -x --expr      evaluate an expression as specified on the command line");
                    System.out.println("       file:");
                    System.out.println("         specify a '-' to read script from STDIN");
                    return;
                }
                if (args[start].equals("--check") || args[start].equals("-c")) {
                    check = true;
                    continue;
                }
                if (args[start].equals("--ast") || args[start].equals("-a")) {
                    ast = true;
                    continue;
                }
                if (args[start].equals("--profile") || args[start].equals("-p")) {
                    prof = true;
                    continue;
                }
                if (args[start].equals("--time") || args[start].equals("-t")) {
                    time = true;
                    continue;
                }
                if (args[start].equals("--eval") || args[start].equals("-e")) {
                    eval2 = true;
                    continue;
                }
                if (args[start].equals("--expr") || args[start].equals("-x")) {
                    expr2 = true;
                    continue;
                }
                System.err.println("Unknown argument: " + args[start]);
                return;
            }
            Scalar array2 = SleepUtils.getArrayScalar();
            for (int x = start + 1; x < args.length; ++x) {
                array2.getArray().push(TaintUtils.taint(SleepUtils.getScalar(args[x])));
            }
            try {
                ScriptInstance script = eval2 ? loader.loadScript(args[start - 1], args[start], new Hashtable()) : (expr2 ? loader.loadScript(args[start - 1], "println(" + args[start] + ");", new Hashtable()) : (args[start].equals("-") ? loader.loadScript("STDIN", System.in) : loader.loadScript(args[start])));
                script.getScriptVariables().putScalar("@ARGV", array2);
                script.getScriptVariables().putScalar("$__SCRIPT__", SleepUtils.getScalar(script.getName()));
                if (System.getProperty("sleep.debug") != null) {
                    script.setDebugFlags(Integer.parseInt(System.getProperty("sleep.debug")));
                }
                if (prof) {
                    script.setDebugFlags(script.getDebugFlags() | 0x18);
                }
                if (check) {
                    System.out.println(args[start] + " syntax OK");
                } else if (ast) {
                    System.out.println(script.getRunnableBlock());
                } else {
                    long beganAt = System.currentTimeMillis();
                    script.runScript();
                    if (prof) {
                        script.printProfileStatistics(System.out);
                    }
                    if (time) {
                        long difference = System.currentTimeMillis() - beganAt;
                        System.out.println("time: " + (double)difference / 1000.0 + "s");
                    }
                }
            }
            catch (YourCodeSucksException yex) {
                temp.processScriptErrors(yex);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            try {
                temp.rppl();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void consolePrint(String message) {
        System.out.print(message);
    }

    public void consolePrintln(Object message) {
        System.out.println(message.toString());
    }

    public String consoleReadln() {
        try {
            return this.in.readLine();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

