/*
 * Decompiled with CFR 0.152.
 */
package sleep.console;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import sleep.bridges.DefaultVariable;
import sleep.bridges.SleepClosure;
import sleep.console.ConsoleProxy;
import sleep.engine.Block;
import sleep.error.RuntimeWarningWatcher;
import sleep.error.ScriptWarning;
import sleep.error.YourCodeSucksException;
import sleep.interfaces.Loadable;
import sleep.interfaces.Variable;
import sleep.parser.ImportManager;
import sleep.parser.Parser;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.ScriptLoader;
import sleep.runtime.ScriptVariables;

public class ConsoleImplementation
implements RuntimeWarningWatcher,
Loadable,
ConsoleProxy {
    private ScriptInstance script;
    private ConsoleProxy myProxy;
    private Hashtable sharedEnvironment;
    private Variable sharedVariables;
    private ScriptLoader loader;
    private ImportManager imports;
    private boolean interact = true;

    public ConsoleImplementation() {
        this(new Hashtable(), new DefaultVariable(), new ScriptLoader());
    }

    public ConsoleImplementation(Hashtable _sharedEnvironment, Variable _sharedVariables, ScriptLoader _loader) {
        if (_sharedEnvironment == null) {
            _sharedEnvironment = new Hashtable();
        }
        if (_sharedVariables == null) {
            _sharedVariables = new DefaultVariable();
        }
        if (_loader == null) {
            _loader = new ScriptLoader();
        }
        this.sharedEnvironment = _sharedEnvironment;
        this.sharedVariables = _sharedVariables;
        this.loader = _loader;
        this.loader.addSpecificBridge(this);
        this.setProxy(this);
    }

    public ConsoleProxy getProxy() {
        return this.myProxy;
    }

    public void setProxy(ConsoleProxy p) {
        this.myProxy = p;
    }

    public void consolePrint(String m) {
    }

    public String consoleReadln() {
        return null;
    }

    public void consolePrintln(Object m) {
    }

    public void rppl() throws IOException {
        block25: {
            this.getProxy().consolePrintln(">> Welcome to the Sleep scripting language");
            this.interact = false;
            StringBuffer code = new StringBuffer();
            String repeat = "";
            while (true) {
                Scalar value;
                String args;
                String command;
                if (!this.interact) {
                    this.getProxy().consolePrint("> ");
                }
                String input = this.getProxy().consoleReadln();
                if (this.interact) {
                    if (input == null || input.equals("done")) {
                        this.interact = false;
                        continue;
                    }
                    if (input.equals(".")) {
                        if (code.length() == 0) {
                            this.eval(repeat, repeat);
                            continue;
                        }
                        this.eval(code.toString(), code.toString());
                        repeat = code.toString();
                        code = new StringBuffer();
                        continue;
                    }
                    code.append(input + "\n");
                    continue;
                }
                if (input == null) break;
                if (input.indexOf(32) > -1) {
                    command = input.substring(0, input.indexOf(32));
                    args = input.substring(command.length() + 1, input.length());
                } else {
                    command = input;
                    args = null;
                }
                if (command.equals("env")) {
                    String filter;
                    if (args != null && args.indexOf(32) > -1) {
                        filter = args.substring(args.indexOf(32) + 1, args.length());
                        args = args.substring(0, args.indexOf(32));
                    } else {
                        filter = null;
                    }
                    this.env(args, filter);
                    continue;
                }
                if (command.equals("version")) {
                    this.getProxy().consolePrintln("Sleep 2.1 (20080701)");
                    continue;
                }
                if (command.equals("help") && args != null) {
                    this.help(args);
                    continue;
                }
                if (command.equals("help")) {
                    this.help();
                    continue;
                }
                if (command.equals("interact")) {
                    this.interact();
                    continue;
                }
                if (command.equals("list")) {
                    this.list();
                    continue;
                }
                if (command.equals("debug") && args != null) {
                    String[] splits = args.split(" ");
                    if (splits.length == 2) {
                        this.debug(splits[0], Integer.parseInt(splits[1]));
                        continue;
                    }
                    if (splits.length == 1) {
                        this.debug(null, Integer.parseInt(splits[0]));
                        continue;
                    }
                    this.getProxy().consolePrintln("Invalid usage: debug [script] <level>");
                    continue;
                }
                if (command.equals("load") && args != null) {
                    this.load(args);
                    continue;
                }
                if (command.equals("tree") && (args != null || this.script != null)) {
                    this.tree(args);
                    continue;
                }
                if (command.equals("unload") && args != null) {
                    this.unload(args);
                    continue;
                }
                if (command.equals("x") && args != null) {
                    value = this.eval("return " + args + ";", args);
                    if (value == null) continue;
                    this.getProxy().consolePrintln(value + "");
                    continue;
                }
                if (command.equals("?") && args != null) {
                    value = this.eval("return iff(" + args + ", 'true', 'false');", args);
                    if (value == null) continue;
                    this.getProxy().consolePrintln(value + "");
                    continue;
                }
                if (command.equals("quit") || command.equals("exit") || command.equals("done")) {
                    this.getProxy().consolePrintln("Good bye!");
                    this.setProxy(this);
                    break block25;
                }
                if (command.trim().length() <= 0) continue;
                this.getProxy().consolePrintln("Command '" + command + "' not understood.  Type 'help' if you need it");
            }
            this.getProxy().consolePrintln("Good bye!");
            this.setProxy(this);
        }
        this.interact = true;
    }

    private void help() {
        this.getProxy().consolePrintln("debug [script] <level>");
        this.getProxy().consolePrintln("env [functions/other] [regex filter]");
        this.getProxy().consolePrintln("help [command]");
        this.getProxy().consolePrintln("interact");
        this.getProxy().consolePrintln("list");
        this.getProxy().consolePrintln("load <file>");
        this.getProxy().consolePrintln("unload <file>");
        this.getProxy().consolePrintln("tree [key]");
        this.getProxy().consolePrintln("quit");
        this.getProxy().consolePrintln("version");
        this.getProxy().consolePrintln("x <expression>");
        this.getProxy().consolePrintln("? <predicate expression>");
    }

    private void help(String command) {
        if (command.equals("debug")) {
            this.getProxy().consolePrintln("debug [script] <level>");
            this.getProxy().consolePrintln("   sets the debug level for the specified script");
            this.getProxy().consolePrintln("   1 - show critical errors");
            this.getProxy().consolePrintln("   2 - show warnings");
            this.getProxy().consolePrintln("   4 - strict mode, complain about non-declared variables");
            this.getProxy().consolePrintln("   8 - trace all function calls");
            this.getProxy().consolePrintln("   to combine options, add their numbers together");
        } else if (command.equals("env")) {
            this.getProxy().consolePrintln("env [functions/other] [regex filter]");
            this.getProxy().consolePrintln("   dumps the shared environment, filters output with specified regex");
        } else if (command.equals("interact")) {
            this.getProxy().consolePrintln("interact");
            this.getProxy().consolePrintln("   enters the console into interactive mode.");
        } else if (command.equals("list")) {
            this.getProxy().consolePrintln("list");
            this.getProxy().consolePrintln("   lists all of the currently loaded scripts");
        } else if (command.equals("load")) {
            this.getProxy().consolePrintln("load <file>");
            this.getProxy().consolePrintln("   loads a script file into the script loader");
        } else if (command.equals("unload")) {
            this.getProxy().consolePrintln("unload <file>");
            this.getProxy().consolePrintln("   unloads a script file from the script loader");
        } else if (command.equals("tree")) {
            this.getProxy().consolePrintln("tree [key]");
            this.getProxy().consolePrintln("   displays the Abstract Syntax Tree for the specified key");
        } else if (command.equals("quit")) {
            this.getProxy().consolePrintln("quit");
            this.getProxy().consolePrintln("   stops the console");
        } else if (command.equals("version")) {
            this.getProxy().consolePrintln("version");
            this.getProxy().consolePrintln("   display the current Sleep version");
        } else if (command.equals("x")) {
            this.getProxy().consolePrintln("x <expression>");
            this.getProxy().consolePrintln("   evaluates a sleep expression and displays the value");
        } else if (command.equals("?")) {
            this.getProxy().consolePrintln("? <predicate expression>");
            this.getProxy().consolePrintln("   evaluates a sleep predicate expression and displays the truth value");
        } else {
            this.getProxy().consolePrintln("help [command]");
            this.getProxy().consolePrintln("   displays a help message for the specified command");
        }
    }

    private void load(String file) {
        try {
            ScriptInstance script = this.loader.loadScript(file, this.sharedEnvironment);
            if (System.getProperty("sleep.debug") != null) {
                script.setDebugFlags(Integer.parseInt(System.getProperty("sleep.debug")));
            }
            script.runScript();
        }
        catch (YourCodeSucksException yex) {
            this.processScriptErrors(yex);
        }
        catch (Exception ex) {
            this.getProxy().consolePrintln("Could not load script " + file + ": " + ex.getMessage());
        }
    }

    private String getFullScript(String name) {
        if (this.loader.getScriptsByKey().containsKey(name)) {
            return name;
        }
        Iterator i = this.loader.getScripts().iterator();
        while (i.hasNext()) {
            ScriptInstance script = (ScriptInstance)i.next();
            File temp = new File(script.getName());
            if (!temp.getName().equals(name)) continue;
            return temp.getAbsolutePath();
        }
        return name;
    }

    private void unload(String file) {
        try {
            this.loader.unloadScript(this.getFullScript(file));
        }
        catch (Exception ex) {
            this.getProxy().consolePrintln("Could not unloaded script " + file + ": " + ex.getMessage());
        }
    }

    private void list() {
        Iterator i = this.loader.getScripts().iterator();
        while (i.hasNext()) {
            ScriptInstance temp = (ScriptInstance)i.next();
            this.getProxy().consolePrintln(temp.getName());
        }
    }

    private void env(String type, String filter) {
        Iterator i = this.sharedEnvironment.keySet().iterator();
        while (i.hasNext()) {
            Object temp = i.next();
            if (type != null && (!type.equals("functions") || temp.toString().charAt(0) != '&') && (!type.equals("other") || temp.toString().charAt(0) == '&') || filter != null && !Pattern.matches(".*?" + filter + ".*", this.sharedEnvironment.get(temp).toString())) continue;
            this.getProxy().consolePrintln(this.align(temp.toString(), 20) + " => " + this.sharedEnvironment.get(temp));
        }
    }

    private String align(String text, int to) {
        StringBuffer temp = new StringBuffer(text);
        while (temp.length() < to) {
            temp.append(" ");
        }
        return temp.toString();
    }

    private void tree(String item) {
        if (item == null) {
            this.getProxy().consolePrintln(this.script.getRunnableBlock().toString());
        } else if (item.charAt(0) == '&' || item.charAt(0) == '$') {
            if (this.sharedEnvironment != null && this.sharedEnvironment.get(item) instanceof SleepClosure) {
                SleepClosure temp = (SleepClosure)this.sharedEnvironment.get(item);
                this.getProxy().consolePrintln(temp.getRunnableCode());
            } else {
                this.getProxy().consolePrintln("Could not find code block " + item + " to print tree of");
            }
        } else {
            Map temp = this.loader.getScriptsByKey();
            if (temp.get(this.getFullScript(item)) != null) {
                this.getProxy().consolePrintln(((ScriptInstance)temp.get(this.getFullScript(item))).getRunnableBlock());
            } else {
                this.getProxy().consolePrintln("Could not find script " + item + " to print tree of");
            }
        }
    }

    private void debug(String item, int level) {
        if (item == null) {
            System.setProperty("sleep.debug", "" + level);
            this.getProxy().consolePrintln("Default debug level set");
        } else {
            Map temp = this.loader.getScriptsByKey();
            if (temp.get(this.getFullScript(item)) != null) {
                ((ScriptInstance)temp.get(this.getFullScript(item))).setDebugFlags(level);
                this.getProxy().consolePrintln("Debug level set for " + item);
            } else {
                this.getProxy().consolePrintln("Could not find script " + item + " to set debug level for");
            }
        }
    }

    private void interact() {
        this.interact = true;
        this.getProxy().consolePrintln(">> Welcome to interactive mode.");
        this.getProxy().consolePrintln("Type your code and then '.' on a line by itself to execute the code.");
        this.getProxy().consolePrintln("Type Ctrl+D or 'done' on a line by itself to leave interactive mode.");
    }

    private Scalar eval(String expression, String original) {
        try {
            Parser parser = new Parser("eval", expression.toString(), this.imports);
            this.imports = parser.getImportManager();
            parser.parse();
            Block parsed = parser.getRunnableBlock();
            this.script = this.loader.loadScript("<interact mode>", parsed, this.sharedEnvironment);
            if (System.getProperty("sleep.debug") != null) {
                this.script.setDebugFlags(Integer.parseInt(System.getProperty("sleep.debug")));
            }
            return this.script.runScript();
        }
        catch (YourCodeSucksException yex) {
            this.processScriptErrors(yex);
        }
        catch (Exception ex) {
            this.getProxy().consolePrintln("error with " + original + ": " + ex.toString());
        }
        return null;
    }

    public void processScriptErrors(YourCodeSucksException ex) {
        this.getProxy().consolePrint(ex.formatErrors());
    }

    public void processScriptWarning(ScriptWarning warning) {
        this.getProxy().consolePrintln(warning.toString());
    }

    public void scriptLoaded(ScriptInstance script) {
        if (!script.getName().equals("<interact mode>") && !this.interact) {
            this.getProxy().consolePrintln(script.getName() + " loaded successfully.");
        }
        script.addWarningWatcher(this);
        script.setScriptVariables(new ScriptVariables(this.sharedVariables));
    }

    public void scriptUnloaded(ScriptInstance script) {
        this.getProxy().consolePrintln(script.getName() + " has been unloaded");
    }
}

