/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges.io;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import sleep.bridges.SleepClosure;
import sleep.bridges.io.IOObject;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class SocketObject
extends IOObject {
    protected Socket socket;
    private static Map servers;
    public static final int LISTEN_FUNCTION = 1;
    public static final int CONNECT_FUNCTION = 2;

    public Object getSource() {
        return this.socket;
    }

    public void open(SocketHandler params, ScriptEnvironment env) {
        try {
            this.socket = new Socket();
            if (params.laddr != null) {
                this.socket.bind(new InetSocketAddress(params.laddr, params.lport));
            }
            this.socket.connect(new InetSocketAddress(params.host, params.port), params.timeout);
            this.socket.setSoLinger(true, params.linger);
            this.openRead(this.socket.getInputStream());
            this.openWrite(this.socket.getOutputStream());
        }
        catch (Exception ex) {
            env.flagError(ex);
        }
    }

    public static void release(int port) {
        String key = port + "";
        ServerSocket temp = null;
        if (servers != null && servers.containsKey(key)) {
            temp = (ServerSocket)servers.get(key);
            servers.remove(key);
            try {
                temp.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static ServerSocket getServerSocket(int port, SocketHandler params) throws Exception {
        String key = port + "";
        if (servers == null) {
            servers = Collections.synchronizedMap(new HashMap());
        }
        ServerSocket server = null;
        if (servers.containsKey(key)) {
            server = (ServerSocket)servers.get(key);
        } else {
            server = new ServerSocket(port, params.backlog, params.laddr != null ? InetAddress.getByName(params.laddr) : null);
            servers.put(key, server);
        }
        return server;
    }

    public void listen(SocketHandler params, ScriptEnvironment env) {
        ServerSocket server = null;
        try {
            server = SocketObject.getServerSocket(params.port, params);
            server.setSoTimeout(params.timeout);
            this.socket = server.accept();
            this.socket.setSoLinger(true, params.linger);
            params.callback.setValue(SleepUtils.getScalar(this.socket.getInetAddress().getHostAddress()));
            this.openRead(this.socket.getInputStream());
            this.openWrite(this.socket.getOutputStream());
            return;
        }
        catch (Exception ex) {
            env.flagError(ex);
            return;
        }
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.close();
    }

    public static class SocketHandler
    implements Runnable {
        public ScriptInstance script;
        public SleepClosure function;
        public SocketObject socket;
        public int port;
        public int timeout;
        public String host;
        public Scalar callback;
        public int type;
        public String laddr;
        public int lport;
        public int linger;
        public int backlog;

        public void start() {
            if (this.function != null) {
                this.socket.setThread(new Thread(this));
                this.socket.getThread().start();
            } else {
                this.run();
            }
        }

        public void run() {
            if (this.type == 1) {
                this.socket.listen(this, this.script.getScriptEnvironment());
            } else {
                this.socket.open(this, this.script.getScriptEnvironment());
            }
            if (this.function != null) {
                Stack<Scalar> args = new Stack<Scalar>();
                args.push(SleepUtils.getScalar(this.socket));
                this.function.callClosure("&callback", this.script, args);
            }
        }
    }
}

