/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges.io;

import java.io.File;
import sleep.bridges.io.IOObject;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.SleepUtils;

public class ProcessObject
extends IOObject {
    protected Process process;

    public Object getSource() {
        return this.process;
    }

    public void open(String[] command, String[] environment, File startDir, ScriptEnvironment env) {
        try {
            if (command.length > 0) {
                command[0] = command[0].replace('/', File.separatorChar);
            }
            this.process = Runtime.getRuntime().exec(command, environment, startDir);
            this.openRead(this.process.getInputStream());
            this.openWrite(this.process.getOutputStream());
        }
        catch (Exception ex) {
            env.flagError(ex);
        }
    }

    public Scalar wait(ScriptEnvironment env, long timeout) {
        if (this.getThread() != null && this.getThread().isAlive()) {
            super.wait(env, timeout);
        }
        try {
            this.process.waitFor();
            return SleepUtils.getScalar(this.process.waitFor());
        }
        catch (Exception ex) {
            env.flagError(ex);
            return SleepUtils.getEmptyScalar();
        }
    }

    public void close() {
        super.close();
        this.process.destroy();
    }
}

