/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges.io;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.SleepUtils;

public class IOObject {
    protected InputStreamReader readeru = null;
    protected DataInputStream readerb = null;
    protected BufferedInputStream reader = null;
    protected InputStream in = null;
    protected OutputStreamWriter writeru = null;
    protected DataOutputStream writerb = null;
    protected OutputStream out = null;
    protected Thread thread = null;
    protected Scalar token = null;
    private boolean stripTheLineSeparator = false;
    private static final String lineSeparator = System.getProperty("line.separator");

    public Object getSource() {
        return null;
    }

    public void setEncoding(String name) throws UnsupportedEncodingException {
        if (this.writerb != null) {
            this.writeru = new OutputStreamWriter((OutputStream)this.writerb, name);
        }
        if (this.readerb != null) {
            this.readeru = new InputStreamReader((InputStream)this.readerb, name);
        }
    }

    public void setThread(Thread t) {
        this.thread = t;
    }

    public Thread getThread() {
        return this.thread;
    }

    public Scalar wait(ScriptEnvironment env, long timeout) {
        if (this.getThread() != null && this.getThread().isAlive()) {
            try {
                this.getThread().join(timeout);
                if (this.getThread().isAlive()) {
                    env.flagError(new IOException("wait on object timed out"));
                    return SleepUtils.getEmptyScalar();
                }
            }
            catch (Exception ex) {
                env.flagError(ex);
                return SleepUtils.getEmptyScalar();
            }
        }
        return this.getToken();
    }

    public Scalar getToken() {
        if (this.token == null) {
            return SleepUtils.getEmptyScalar();
        }
        return this.token;
    }

    public void setToken(Scalar t) {
        this.token = t;
    }

    public static void setConsole(ScriptEnvironment environment, IOObject object) {
        environment.getScriptInstance().getMetadata().put("%console%", object);
    }

    public static IOObject getConsole(ScriptEnvironment environment) {
        IOObject console = (IOObject)environment.getScriptInstance().getMetadata().get("%console%");
        if (console == null) {
            console = new IOObject();
            console.openRead(System.in);
            console.openWrite(System.out);
            IOObject.setConsole(environment, console);
        }
        return console;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void openRead(InputStream _in) {
        this.in = _in;
        if (this.in != null) {
            this.reader = new BufferedInputStream(this.in, 8192);
            this.readerb = new DataInputStream(this.reader);
            this.readeru = new InputStreamReader(this.readerb);
        }
    }

    public void openWrite(OutputStream _out) {
        this.out = _out;
        if (this.out != null) {
            this.writerb = new DataOutputStream(this.out);
            this.writeru = new OutputStreamWriter(this.writerb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.in != null) {
                this.in.notifyAll();
            }
            if (this.out != null) {
                this.out.notifyAll();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            if (this.readeru != null) {
                this.readeru.close();
            }
            if (this.writeru != null) {
                this.writeru.close();
            }
            if (this.reader != null) {
                this.reader.close();
            }
            if (this.readerb != null) {
                this.readerb.close();
            }
            if (this.writerb != null) {
                this.writerb.close();
            }
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.in = null;
            this.out = null;
            this.reader = null;
            this.readerb = null;
            this.writerb = null;
            this.readeru = null;
            this.writeru = null;
        }
    }

    public String readLine() {
        try {
            if (this.readeru != null) {
                StringBuffer rv = new StringBuffer(8192);
                int temp = this.readeru.read();
                if (this.stripTheLineSeparator && temp == 10) {
                    temp = this.readeru.read();
                }
                this.stripTheLineSeparator = false;
                while (temp != -1) {
                    if (temp == 10) {
                        return rv.toString();
                    }
                    if (temp == 13) {
                        this.stripTheLineSeparator = true;
                        return rv.toString();
                    }
                    rv.append((char)temp);
                    temp = this.readeru.read();
                }
                this.close();
                if (rv.length() > 0) {
                    return rv.toString();
                }
                return null;
            }
        }
        catch (Exception ex) {
            this.close();
        }
        return null;
    }

    public String readCharacter() {
        block3: {
            try {
                if (this.readeru == null) break block3;
                int temp = this.readeru.read();
                if (temp == -1) {
                    this.close();
                    break block3;
                }
                return (char)temp + "";
            }
            catch (Exception ex) {
                this.close();
            }
        }
        return null;
    }

    public boolean isEOF() {
        return this.reader == null;
    }

    public void sendEOF() {
        try {
            if (this.writerb != null) {
                this.writerb.close();
            }
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BufferedInputStream getInputBuffer() {
        return this.reader;
    }

    public DataInputStream getReader() {
        return this.readerb;
    }

    public DataOutputStream getWriter() {
        return this.writerb;
    }

    public void printLine(String text) {
        this.print(text + lineSeparator);
    }

    public void print(String text) {
        try {
            if (this.writeru != null) {
                this.writeru.write(text, 0, text.length());
                this.writeru.flush();
            }
        }
        catch (Exception ex) {
            this.close();
        }
    }
}

