/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges.io;

import java.nio.ByteOrder;
import java.util.HashMap;

public class DataPattern {
    public DataPattern next = null;
    public int count = 1;
    public char value = (char)32;
    public int size = 0;
    public ByteOrder order = ByteOrder.BIG_ENDIAN;
    private static HashMap patternCache = new HashMap();

    public static int EstimateSize(String format) {
        DataPattern pattern = DataPattern.Parse(format);
        int count = 0;
        while (pattern != null) {
            if (pattern.count > 0) {
                count += pattern.count * pattern.size;
            }
            pattern = pattern.next;
        }
        return count;
    }

    public static DataPattern Parse(String format) {
        if (patternCache.get(format) != null) {
            return (DataPattern)patternCache.get(format);
        }
        DataPattern head = null;
        DataPattern temp = null;
        StringBuffer count = null;
        for (int x = 0; x < format.length(); ++x) {
            if (Character.isLetter(format.charAt(x))) {
                if (temp != null) {
                    if (count.length() > 0) {
                        temp.count = Integer.parseInt(count.toString());
                    }
                    temp = temp.next = new DataPattern();
                } else {
                    temp = head = new DataPattern();
                }
                count = new StringBuffer(3);
                temp.value = format.charAt(x);
                switch (temp.value) {
                    case 'B': 
                    case 'C': 
                    case 'H': 
                    case 'b': 
                    case 'h': 
                    case 'o': 
                    case 'x': {
                        temp.size = 1;
                        break;
                    }
                    case 'U': 
                    case 'u': {
                        temp.count = -1;
                        temp.size = 2;
                        break;
                    }
                    case 'Z': 
                    case 'z': {
                        temp.count = -1;
                        temp.size = 1;
                        break;
                    }
                    case 'S': 
                    case 'c': 
                    case 's': {
                        temp.size = 2;
                        break;
                    }
                    case 'I': 
                    case 'f': 
                    case 'i': {
                        temp.size = 4;
                        break;
                    }
                    case 'd': 
                    case 'l': {
                        temp.size = 8;
                    }
                }
                continue;
            }
            if (format.charAt(x) == '*') {
                temp.count = -1;
                continue;
            }
            if (format.charAt(x) == '!') {
                temp.order = ByteOrder.nativeOrder();
                continue;
            }
            if (format.charAt(x) == '-') {
                temp.order = ByteOrder.LITTLE_ENDIAN;
                continue;
            }
            if (format.charAt(x) == '+') {
                temp.order = ByteOrder.BIG_ENDIAN;
                continue;
            }
            if (!Character.isDigit(format.charAt(x))) continue;
            count.append(format.charAt(x));
        }
        if (count.length() > 0) {
            temp.count = Integer.parseInt(count.toString());
        }
        patternCache.put(format, head);
        return head;
    }
}

