/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges;

import java.text.StringCharacterIterator;
import java.util.regex.PatternSyntaxException;

public class Transliteration {
    public static final int OPTION_DELETE = 1;
    public static final int OPTION_COMPLEMENT = 2;
    public static final int OPTION_SQUEEZE = 4;
    private static String AvailableOptions = "dDsSwW.\\-";
    private int options = 0;
    private Element pattern = null;

    public String toString() {
        StringBuffer a = new StringBuffer();
        StringBuffer b = new StringBuffer();
        Element temp = this.pattern;
        while (temp != null) {
            if (temp.isSpecial) {
                switch (temp.item) {
                    case '.': {
                        a.append("[:ANY:]");
                        break;
                    }
                    case 'd': {
                        a.append("[:digit:]");
                        break;
                    }
                    case 'D': {
                        a.append("[:non-digit:]");
                        break;
                    }
                    case 's': {
                        a.append("[:whitespace:]");
                        break;
                    }
                    case 'S': {
                        a.append("[:non-whitespace:]");
                        break;
                    }
                    case 'w': {
                        a.append("[:word character:]");
                        break;
                    }
                    case 'W': {
                        a.append("[:non-word character:]");
                        break;
                    }
                    default: {
                        a.append(temp.item);
                        break;
                    }
                }
            } else {
                a.append(temp.item);
            }
            b.append(temp.replacement);
            temp = temp.next;
        }
        return "tr/" + a + "/" + b + "/";
    }

    private static String getRange(char a, char b) {
        StringBuffer temp;
        block3: {
            block2: {
                temp = new StringBuffer();
                if (a >= b) break block2;
                for (char c = a; c < b; c = (char)(c + '\u0001')) {
                    temp.append(c);
                }
                break block3;
            }
            if (a <= b) break block3;
            for (char c = a; c > b; c = (char)(c - '\u0001')) {
                temp.append(c);
            }
        }
        return temp.toString();
    }

    private static String expandRanges(String text) throws PatternSyntaxException {
        StringBuffer temp = new StringBuffer(text);
        for (int x = 0; x < temp.length(); ++x) {
            if (temp.charAt(x) == '\\') {
                ++x;
                continue;
            }
            if (temp.charAt(x) != '-') continue;
            if (x <= 0 || x >= temp.length() - 1) {
                throw new PatternSyntaxException("Dangling range operator '-'", text, text.length() - 1);
            }
            String range = Transliteration.getRange(temp.charAt(x - 1), temp.charAt(x + 1));
            temp.replace(x - 1, x + 1, range);
            x += range.length() - 2;
        }
        return temp.toString();
    }

    private Element buildPattern(String pattern, String changes) {
        Element head = null;
        Element temp = null;
        pattern = Transliteration.expandRanges(pattern);
        changes = Transliteration.expandRanges(changes);
        StringCharacterIterator a = new StringCharacterIterator(pattern);
        StringCharacterIterator b = new StringCharacterIterator(changes);
        while (a.current() != '\uffff') {
            temp = temp == null ? (head = new Element()) : (temp.next = new Element());
            if (a.current() == '\\') {
                temp.item = a.next();
                temp.replacement = b.current();
                if (a.current() == '\uffff') {
                    throw new PatternSyntaxException("attempting to escape end of pattern string", pattern, a.getEndIndex() - 1);
                }
                if (AvailableOptions.indexOf(temp.item) == -1) {
                    throw new PatternSyntaxException("unrecognized escaped meta-character '" + temp.item + "'", pattern, a.getIndex());
                }
                temp.isSpecial = a.current() != '\\' && a.current() != '.' && a.current() != '-';
            } else {
                temp.item = a.current();
                temp.replacement = b.current();
                temp.isSpecial = a.current() == '.';
            }
            a.next();
            b.next();
            if (b.current() != '\uffff' || (this.options & 1) == 1) continue;
            b.last();
        }
        return head;
    }

    public static Transliteration compile(String matches, String replacements) throws PatternSyntaxException {
        return Transliteration.compile(matches, replacements, 0);
    }

    public static Transliteration compile(String matches, String replacements, int options) throws PatternSyntaxException {
        Transliteration value = new Transliteration();
        value.options = options;
        value.pattern = value.buildPattern(matches, replacements);
        return value;
    }

    private boolean isMatch(char current, Element element) {
        boolean rv = false;
        if (element.isSpecial) {
            switch (element.item) {
                case '.': {
                    rv = true;
                    break;
                }
                case 'd': {
                    rv = Character.isDigit(current);
                    break;
                }
                case 'D': {
                    rv = !Character.isDigit(current);
                    break;
                }
                case 's': {
                    rv = Character.isWhitespace(current);
                    break;
                }
                case 'S': {
                    rv = !Character.isWhitespace(current);
                    break;
                }
                case 'w': {
                    rv = Character.isLetter(current);
                    break;
                }
                case 'W': {
                    rv = !Character.isLetter(current);
                }
            }
        } else {
            boolean bl = rv = element.item == current;
        }
        if ((this.options & 2) == 2) {
            rv = !rv;
        }
        return rv;
    }

    public String translate(String text) {
        StringBuffer rv = new StringBuffer();
        Element temp = null;
        boolean match = false;
        for (int x = 0; x < text.length(); ++x) {
            char current = text.charAt(x);
            temp = this.pattern;
            match = false;
            while (temp != null) {
                if (this.isMatch(current, temp)) {
                    if (temp.replacement != '\uffff') {
                        rv.append(temp.replacement);
                    }
                    while ((this.options & 4) == 4 && x + 1 < text.length() && text.charAt(x + 1) == current) {
                        ++x;
                    }
                    match = true;
                    break;
                }
                temp = temp.next;
            }
            if (match) continue;
            rv.append(current);
        }
        return rv.toString();
    }

    private static class Element {
        public char item = (char)120;
        public char replacement = (char)120;
        public boolean isSpecial = false;
        public boolean isWildcard = false;
        public Element next = null;

        private Element() {
        }
    }
}

