/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges;

import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Stack;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class TimeDateBridge
implements Loadable {
    public void scriptLoaded(ScriptInstance script) {
        script.getScriptEnvironment().getEnvironment().put("&ticks", new ticks());
        script.getScriptEnvironment().getEnvironment().put("&formatDate", new formatDate());
        script.getScriptEnvironment().getEnvironment().put("&parseDate", new parseDate());
    }

    public void scriptUnloaded(ScriptInstance script) {
    }

    private static class ticks
    implements Function {
        private ticks() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            return SleepUtils.getScalar(System.currentTimeMillis());
        }
    }

    private static class parseDate
    implements Function {
        private parseDate() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            String a = locals.pop().toString();
            String b = locals.pop().toString();
            SimpleDateFormat format = new SimpleDateFormat(a);
            Date pdate = format.parse(b, new ParsePosition(0));
            return SleepUtils.getScalar(pdate.getTime());
        }
    }

    private static class formatDate
    implements Function {
        private formatDate() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            long a = System.currentTimeMillis();
            if (locals.size() == 2) {
                a = BridgeUtilities.getLong(locals);
            }
            String b = locals.pop().toString();
            SimpleDateFormat format = new SimpleDateFormat(b);
            Date adate = new Date(a);
            return SleepUtils.getScalar(format.format(adate, new StringBuffer(), new FieldPosition(0)).toString());
        }
    }
}

