/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import sleep.bridges.BridgeUtilities;
import sleep.engine.Block;
import sleep.engine.CallRequest;
import sleep.interfaces.Function;
import sleep.interfaces.Variable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.ScriptInstance;
import sleep.runtime.ScriptVariables;
import sleep.runtime.SleepUtils;

public class SleepClosure
implements Function,
Runnable {
    private static int ccount = -1;
    private int id;
    Block code;
    ScriptInstance owner;
    Stack context;
    HashMap metadata;
    Variable variables;

    public Iterator scalarIterator() {
        return new ClosureIterator();
    }

    public void putMetadata(Object key, Object value) {
        this.metadata.put(key, value);
    }

    public Object getAndRemoveMetadata(Object key, Object defaultv) {
        Object temp = this.metadata.remove(key);
        if (temp == null) {
            return defaultv;
        }
        return temp;
    }

    private void saveToplevelContext(Stack _context, LinkedList localLevel) {
        if (!_context.isEmpty()) {
            _context.push(localLevel);
            this.context.push(_context);
        } else if (localLevel.size() != 1) {
            throw new RuntimeException(localLevel.size() - 1 + " unaccounted local stack frame(s) in " + this.toString() + " (perhaps you forgot to &popl?)");
        }
    }

    private Stack getToplevelContext() {
        if (this.context.isEmpty()) {
            return new Stack();
        }
        return (Stack)this.context.pop();
    }

    public String toStringGeneric() {
        return "&closure[" + this.code.getSourceLocation() + "]";
    }

    public String toString() {
        return this.toStringGeneric() + "#" + this.id;
    }

    private SleepClosure() {
    }

    public SleepClosure(ScriptInstance si, Block _code) {
        this(si, _code, si.getScriptVariables().getGlobalVariables().createInternalVariableContainer());
    }

    public SleepClosure(ScriptInstance si, Block _code, Variable _var) {
        this.code = _code;
        this.owner = si;
        this.context = new Stack();
        this.metadata = new HashMap();
        _var.putScalar("$this", SleepUtils.getScalar(this));
        this.setVariables(_var);
        this.id = ccount = (ccount + 1) % Short.MAX_VALUE;
    }

    public ScriptInstance getOwner() {
        return this.owner;
    }

    public Block getRunnableCode() {
        return this.code;
    }

    public Variable getVariables() {
        return this.variables;
    }

    public void setVariables(Variable _variables) {
        this.variables = _variables;
    }

    public void run() {
        this.callClosure("run", null, null);
    }

    public Scalar callClosure(String message, ScriptInstance si, Stack locals) {
        if (si == null) {
            si = this.getOwner();
        }
        if (locals == null) {
            locals = new Stack();
        }
        si.getScriptEnvironment().pushSource("<internal>");
        si.getScriptEnvironment().CreateFrame();
        si.getScriptEnvironment().CreateFrame(locals);
        CallRequest.ClosureCallRequest request = new CallRequest.ClosureCallRequest(si.getScriptEnvironment(), -1, SleepUtils.getScalar(this), message);
        request.CallFunction();
        Scalar rv = si.getScriptEnvironment().getCurrentFrame().isEmpty() ? SleepUtils.getEmptyScalar() : (Scalar)si.getScriptEnvironment().getCurrentFrame().pop();
        si.getScriptEnvironment().KillFrame();
        si.getScriptEnvironment().clearReturn();
        si.getScriptEnvironment().popSource();
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scalar evaluate(String message, ScriptInstance si, Stack locals) {
        Scalar temp;
        if (this.owner == null) {
            this.owner = si;
        }
        ScriptVariables vars = si.getScriptVariables();
        ScriptEnvironment env = si.getScriptEnvironment();
        ScriptVariables scriptVariables = vars;
        synchronized (scriptVariables) {
            Stack toplevel = this.getToplevelContext();
            env.loadContext(toplevel, this.metadata);
            vars.pushClosureLevel(this.getVariables());
            if (toplevel.isEmpty()) {
                vars.beginToplevel(new LinkedList());
                vars.pushLocalLevel();
            } else {
                LinkedList levels = (LinkedList)toplevel.pop();
                vars.beginToplevel(levels);
            }
            Variable localLevel = vars.getLocalVariables();
            vars.setScalarLevel("$0", SleepUtils.getScalar(message), localLevel);
            BridgeUtilities.initLocalScope(vars, localLevel, locals);
            temp = toplevel.isEmpty() ? this.code.evaluate(env) : env.evaluateOldContext();
            LinkedList phear = vars.leaveToplevel();
            vars.popClosureLevel();
            if (si.getScriptEnvironment().isCallCC()) {
                SleepClosure tempc = SleepUtils.getFunctionFromScalar(si.getScriptEnvironment().getReturnValue(), si);
                tempc.putMetadata("continuation", SleepUtils.getScalar(this));
                tempc.putMetadata("sourceLine", si.getScriptEnvironment().getCurrentFrame().pop());
                tempc.putMetadata("sourceFile", si.getScriptEnvironment().getCurrentFrame().pop());
                si.getScriptEnvironment().flagReturn(si.getScriptEnvironment().getReturnValue(), 128);
            }
            this.saveToplevelContext(env.saveContext(), phear);
        }
        return temp;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.id);
        out.writeObject(this.code);
        out.writeObject(this.context);
        out.writeObject(this.variables);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.id = in.readInt();
        this.code = (Block)in.readObject();
        this.context = (Stack)in.readObject();
        this.metadata = new HashMap();
        this.variables = (Variable)in.readObject();
        this.owner = null;
    }

    private class ClosureIterator
    implements Iterator {
        protected Scalar current;
        protected Stack locals = new Stack();

        private ClosureIterator() {
        }

        public boolean hasNext() {
            this.current = SleepClosure.this.callClosure("eval", null, this.locals);
            return !SleepUtils.isEmptyScalar(this.current);
        }

        public Object next() {
            return this.current;
        }

        public void remove() {
        }
    }
}

