/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Predicate;
import sleep.parser.ParserConfig;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;
import sleep.taint.TaintUtils;

public class RegexBridge
implements Loadable {
    private static Map patternCache = Collections.synchronizedMap(new Cache(128));

    private static Pattern getPattern(String pattern) {
        Pattern temp = (Pattern)patternCache.get(pattern);
        if (temp != null) {
            return temp;
        }
        temp = Pattern.compile(pattern);
        patternCache.put(pattern, temp);
        return temp;
    }

    public void scriptUnloaded(ScriptInstance aScript) {
    }

    public void scriptLoaded(ScriptInstance aScript) {
        Hashtable temp = aScript.getScriptEnvironment().getEnvironment();
        isMatch matcher = new isMatch();
        temp.put("ismatch", matcher);
        temp.put("hasmatch", matcher);
        temp.put("&matched", matcher);
        temp.put("&split", new split());
        temp.put("&join", new join());
        temp.put("&matches", new getMatches());
        temp.put("&replace", new rreplace());
        temp.put("&find", new ffind());
    }

    private static String key(String text, Pattern p) {
        StringBuffer buffer = new StringBuffer(text.length() + p.pattern().length() + 1);
        buffer.append(text);
        buffer.append(p.pattern());
        return buffer.toString();
    }

    private static Scalar getLastMatcher(ScriptEnvironment env) {
        Scalar temp = (Scalar)env.getContextMetadata("matcher");
        return temp == null ? SleepUtils.getEmptyScalar() : temp;
    }

    private static Scalar getMatcher(ScriptEnvironment env, String key, String text, Pattern p) {
        Scalar temp;
        Map matchers = (Map)env.getContextMetadata("matchers");
        if (matchers == null) {
            matchers = new Cache(16);
            env.setContextMetadata("matchers", matchers);
        }
        if ((temp = (Scalar)matchers.get(key)) == null) {
            temp = SleepUtils.getScalar(p.matcher(text));
            matchers.put(key, temp);
            return temp;
        }
        return temp;
    }

    static {
        ParserConfig.addKeyword("ismatch");
        ParserConfig.addKeyword("hasmatch");
    }

    private static class rreplace
    implements Function {
        private rreplace() {
        }

        public Scalar evaluate(String n, ScriptInstance script, Stack l) {
            String a = BridgeUtilities.getString(l, "");
            String b = BridgeUtilities.getString(l, "");
            String c = BridgeUtilities.getString(l, "");
            int d = BridgeUtilities.getInt(l, -1);
            StringBuffer rv = new StringBuffer();
            Pattern pattern = RegexBridge.getPattern(b);
            Matcher matcher = pattern.matcher(a);
            for (int matches = 0; matcher.find() && matches != d; ++matches) {
                matcher.appendReplacement(rv, c);
            }
            matcher.appendTail(rv);
            return SleepUtils.getScalar(rv.toString());
        }
    }

    private static class join
    implements Function {
        private join() {
        }

        public Scalar evaluate(String n, ScriptInstance script, Stack l) {
            String a = ((Scalar)l.pop()).toString();
            Iterator i = BridgeUtilities.getIterator(l, script);
            StringBuffer result = new StringBuffer();
            if (i.hasNext()) {
                result.append(i.next().toString());
            }
            while (i.hasNext()) {
                result.append(a);
                result.append(i.next().toString());
            }
            return SleepUtils.getScalar(result.toString());
        }
    }

    private static class split
    implements Function {
        private split() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            String a = ((Scalar)l.pop()).toString();
            String b = ((Scalar)l.pop()).toString();
            Pattern pattern = RegexBridge.getPattern(a);
            String[] results = l.isEmpty() ? pattern.split(b) : pattern.split(b, BridgeUtilities.getInt(l, 0));
            Scalar array2 = SleepUtils.getArrayScalar();
            for (int x = 0; x < results.length; ++x) {
                array2.getArray().push(SleepUtils.getScalar(results[x]));
            }
            return array2;
        }
    }

    private static class getMatches
    implements Function {
        private getMatches() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            String a = ((Scalar)l.pop()).toString();
            String b = ((Scalar)l.pop()).toString();
            int c = BridgeUtilities.getInt(l, -1);
            int d = BridgeUtilities.getInt(l, c);
            Pattern pattern = RegexBridge.getPattern(b);
            Matcher matcher = pattern.matcher(a);
            Scalar value = SleepUtils.getArrayScalar();
            int temp = 0;
            while (matcher.find()) {
                int count = matcher.groupCount();
                if (temp == c) {
                    value = SleepUtils.getArrayScalar();
                }
                for (int x = 1; x <= count; ++x) {
                    value.getArray().push(SleepUtils.getScalar(matcher.group(x)));
                }
                if (temp == d) {
                    return value;
                }
                ++temp;
            }
            return value;
        }
    }

    private static class isMatch
    implements Predicate,
    Function {
        private isMatch() {
        }

        public boolean decide(String n, ScriptInstance i, Stack l) {
            boolean rv;
            Scalar bb = (Scalar)l.pop();
            Scalar aa = (Scalar)l.pop();
            Pattern pattern = RegexBridge.getPattern(bb.toString());
            Scalar container = null;
            Matcher matcher = null;
            if (n.equals("hasmatch")) {
                Map matchers;
                String key = RegexBridge.key(aa.toString(), pattern);
                container = RegexBridge.getMatcher(i.getScriptEnvironment(), key, aa.toString(), pattern);
                matcher = (Matcher)container.objectValue();
                rv = matcher.find();
                if (!rv && (matchers = (Map)i.getScriptEnvironment().getContextMetadata("matchers")) != null) {
                    matchers.remove(key);
                }
            } else {
                matcher = pattern.matcher(aa.toString());
                container = SleepUtils.getScalar(matcher);
                rv = matcher.matches();
            }
            if (TaintUtils.isTainted(aa) || TaintUtils.isTainted(bb)) {
                TaintUtils.taintAll(container);
            }
            i.getScriptEnvironment().setContextMetadata("matcher", rv ? container : null);
            return rv;
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            Scalar value = SleepUtils.getArrayScalar();
            Scalar container = RegexBridge.getLastMatcher(i.getScriptEnvironment());
            if (!SleepUtils.isEmptyScalar(container)) {
                Matcher matcher = (Matcher)container.objectValue();
                int count = matcher.groupCount();
                for (int x = 1; x <= count; ++x) {
                    value.getArray().push(SleepUtils.getScalar(matcher.group(x)));
                }
            }
            return TaintUtils.isTainted(container) ? TaintUtils.taintAll(value) : value;
        }
    }

    private static class ffind
    implements Function {
        private ffind() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            int start;
            String string = BridgeUtilities.getString(l, "");
            String patterns = BridgeUtilities.getString(l, "");
            Pattern pattern = RegexBridge.getPattern(patterns);
            Matcher matchit = pattern.matcher(string);
            boolean check = matchit.find(start = BridgeUtilities.normalize(BridgeUtilities.getInt(l, 0), string.length()));
            if (check) {
                i.getScriptEnvironment().setContextMetadata("matcher", SleepUtils.getScalar(matchit));
            } else {
                i.getScriptEnvironment().setContextMetadata("matcher", null);
            }
            return check ? SleepUtils.getScalar(matchit.start()) : SleepUtils.getEmptyScalar();
        }
    }

    private static class Cache
    extends LinkedHashMap {
        protected int count;

        public Cache(int count) {
            super(11, 0.75f, true);
            this.count = count;
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() >= this.count;
        }
    }
}

