/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges;

import java.io.File;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Stack;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Predicate;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class FileSystemBridge
implements Loadable,
Function,
Predicate {
    public void scriptUnloaded(ScriptInstance aScript) {
    }

    public void scriptLoaded(ScriptInstance aScript) {
        Hashtable temp = aScript.getScriptEnvironment().getEnvironment();
        temp.put("-exists", this);
        temp.put("-canread", this);
        temp.put("-canwrite", this);
        temp.put("-isDir", this);
        temp.put("-isFile", this);
        temp.put("-isHidden", this);
        temp.put("&createNewFile", this);
        temp.put("&deleteFile", this);
        temp.put("&chdir", this);
        temp.put("&cwd", this);
        temp.put("&getCurrentDirectory", this);
        temp.put("&getFileName", new getFileName());
        temp.put("&getFileProper", new getFileProper());
        temp.put("&getFileParent", new getFileParent());
        temp.put("&lastModified", new lastModified());
        temp.put("&lof", new lof());
        temp.put("&ls", new listFiles());
        temp.put("&listRoots", temp.get("&ls"));
        temp.put("&mkdir", this);
        temp.put("&rename", this);
        temp.put("&setLastModified", this);
        temp.put("&setReadOnly", this);
    }

    public Scalar evaluate(String n, ScriptInstance i, Stack l) {
        if (n.equals("&createNewFile")) {
            try {
                File a = BridgeUtilities.getFile(l, i);
                if (a.createNewFile()) {
                    return SleepUtils.getScalar(1);
                }
            }
            catch (Exception ex) {
                i.getScriptEnvironment().flagError(ex);
            }
        } else {
            if (n.equals("&cwd") || n.equals("&getCurrentDirectory")) {
                return SleepUtils.getScalar(i.cwd());
            }
            if (n.equals("&chdir")) {
                i.chdir(BridgeUtilities.getFile(l, i));
            } else if (n.equals("&deleteFile")) {
                File a = BridgeUtilities.getFile(l, i);
                if (a.delete()) {
                    return SleepUtils.getScalar(1);
                }
            } else if (n.equals("&mkdir")) {
                File a = BridgeUtilities.getFile(l, i);
                if (a.mkdirs()) {
                    return SleepUtils.getScalar(1);
                }
            } else if (n.equals("&rename")) {
                File b;
                File a = BridgeUtilities.getFile(l, i);
                if (a.renameTo(b = BridgeUtilities.getFile(l, i))) {
                    return SleepUtils.getScalar(1);
                }
            } else if (n.equals("&setLastModified")) {
                long b;
                File a = BridgeUtilities.getFile(l, i);
                if (a.setLastModified(b = BridgeUtilities.getLong(l))) {
                    return SleepUtils.getScalar(1);
                }
            } else if (n.equals("&setReadOnly")) {
                File a = BridgeUtilities.getFile(l, i);
                if (a.setReadOnly()) {
                    return SleepUtils.getScalar(1);
                }
                return SleepUtils.getEmptyScalar();
            }
        }
        return SleepUtils.getEmptyScalar();
    }

    public boolean decide(String n, ScriptInstance i, Stack l) {
        File a = BridgeUtilities.getFile(l, i);
        if (n.equals("-canread")) {
            return a.canRead();
        }
        if (n.equals("-canwrite")) {
            return a.canWrite();
        }
        if (n.equals("-exists")) {
            return a.exists();
        }
        if (n.equals("-isDir")) {
            return a.isDirectory();
        }
        if (n.equals("-isFile")) {
            return a.isFile();
        }
        if (n.equals("-isHidden")) {
            return a.isHidden();
        }
        return false;
    }

    private static class listFiles
    implements Function {
        private listFiles() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            File[] files;
            if (l.isEmpty() && n.equals("&listRoots")) {
                files = File.listRoots();
            } else {
                File a = BridgeUtilities.getFile(l, i);
                files = a.listFiles();
            }
            LinkedList<String> temp = new LinkedList<String>();
            if (files != null) {
                for (int x = 0; x < files.length; ++x) {
                    temp.add(files[x].getAbsolutePath());
                }
            }
            return SleepUtils.getArrayWrapper(temp);
        }
    }

    private static class lof
    implements Function {
        private lof() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            File a = BridgeUtilities.getFile(l, i);
            return SleepUtils.getScalar(a.length());
        }
    }

    private static class lastModified
    implements Function {
        private lastModified() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            File a = BridgeUtilities.getFile(l, i);
            return SleepUtils.getScalar(a.lastModified());
        }
    }

    private static class getFileParent
    implements Function {
        private getFileParent() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            File a = BridgeUtilities.getFile(l, i);
            return SleepUtils.getScalar(a.getParent());
        }
    }

    private static class getFileProper
    implements Function {
        private getFileProper() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            File start = BridgeUtilities.getFile(l, i);
            while (!l.isEmpty()) {
                start = new File(start, l.pop().toString());
            }
            return SleepUtils.getScalar(start.getAbsolutePath());
        }
    }

    private static class getFileName
    implements Function {
        private getFileName() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            File a = BridgeUtilities.getFile(l, i);
            return SleepUtils.getScalar(a.getName());
        }
    }
}

