/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Stack;
import sleep.bridges.BasicSubroutine;
import sleep.engine.Block;
import sleep.interfaces.Environment;
import sleep.interfaces.Loadable;
import sleep.runtime.ScriptInstance;

public class DefaultEnvironment
implements Loadable,
Environment {
    public HashMap func;

    public void scriptUnloaded(ScriptInstance si) {
        Hashtable env = si.getScriptEnvironment().getEnvironment();
        Enumeration en = env.keys();
        while (en.hasMoreElements()) {
            BasicSubroutine function2;
            String key = (String)en.nextElement();
            if (key.charAt(0) != '&' || !(env.get(key) instanceof BasicSubroutine) || (function2 = (BasicSubroutine)env.get(key)).getOwner().isLoaded()) continue;
            BasicSubroutine nextRoutine = this.getNextSafeSubroutine(function2);
            if (nextRoutine == null) {
                env.remove(key);
                continue;
            }
            env.put(key, nextRoutine);
        }
    }

    protected BasicSubroutine getNextSafeSubroutine(BasicSubroutine function2) {
        if (function2.getOwner().isLoaded()) {
            return function2;
        }
        if (!function2.getUnloadStack().isEmpty()) {
            BasicSubroutine temp = (BasicSubroutine)function2.getUnloadStack().pop();
            return this.getNextSafeSubroutine(temp);
        }
        return null;
    }

    public void scriptLoaded(ScriptInstance si) {
        Hashtable env = si.getScriptEnvironment().getEnvironment();
        env.put("sub", this);
        env.put("inline", this);
    }

    public void bindFunction(ScriptInstance si, String type, String name, Block code) {
        Hashtable env = si.getScriptEnvironment().getEnvironment();
        if (type.equals("sub")) {
            Stack unloadStack;
            if (env.get("&" + name) != null && env.get("&" + name) instanceof BasicSubroutine) {
                BasicSubroutine temp = (BasicSubroutine)env.get("&" + name);
                unloadStack = temp.getUnloadStack();
                unloadStack.push(temp);
            } else {
                unloadStack = new Stack();
            }
            env.put("&" + name, new BasicSubroutine(si, code, unloadStack));
        } else if (type.equals("inline")) {
            env.put("^&" + name, code);
        }
    }
}

