/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import sleep.bridges.KeyValuePair;
import sleep.bridges.SleepClosure;
import sleep.interfaces.Variable;
import sleep.parser.Checkers;
import sleep.runtime.CollectionWrapper;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarArray;
import sleep.runtime.ScalarHash;
import sleep.runtime.ScriptInstance;
import sleep.runtime.ScriptVariables;
import sleep.runtime.SleepUtils;

public class BridgeUtilities {
    private static final boolean doReplace = File.separatorChar != '/';
    static /* synthetic */ Class class$sleep$engine$types$ObjectValue;

    public static byte[] toByteArrayNoConversion(String textz) {
        byte[] data = new byte[textz.length()];
        for (int y = 0; y < data.length; ++y) {
            data[y] = (byte)textz.charAt(y);
        }
        return data;
    }

    public static int getInt(Stack arguments) {
        return BridgeUtilities.getInt(arguments, 0);
    }

    public static int getInt(Stack arguments, int defaultValue) {
        if (arguments.isEmpty()) {
            return defaultValue;
        }
        return ((Scalar)arguments.pop()).intValue();
    }

    public static Class getClass(Stack arguments, Class defaultValue) {
        Object obj = BridgeUtilities.getObject(arguments);
        if (obj == null) {
            return defaultValue;
        }
        return (Class)obj;
    }

    public static long getLong(Stack arguments) {
        return BridgeUtilities.getLong(arguments, 0L);
    }

    public static long getLong(Stack arguments, long defaultValue) {
        if (arguments.isEmpty()) {
            return defaultValue;
        }
        return ((Scalar)arguments.pop()).longValue();
    }

    public static double getDouble(Stack arguments) {
        return BridgeUtilities.getDouble(arguments, 0.0);
    }

    public static double getDouble(Stack arguments, double defaultValue) {
        if (arguments.isEmpty()) {
            return defaultValue;
        }
        return ((Scalar)arguments.pop()).doubleValue();
    }

    public static Map extractNamedParameters(Stack args) {
        HashMap<String, Scalar> rv = new HashMap<String, Scalar>();
        Iterator i = args.iterator();
        while (i.hasNext()) {
            Scalar temp = (Scalar)i.next();
            if (temp.objectValue() == null || temp.objectValue().getClass() != (class$sleep$bridges$KeyValuePair == null ? BridgeUtilities.class$("sleep.bridges.KeyValuePair") : class$sleep$bridges$KeyValuePair)) continue;
            i.remove();
            KeyValuePair value = (KeyValuePair)temp.objectValue();
            rv.put(value.getKey().toString(), value.getValue());
        }
        return rv;
    }

    public static Iterator getIterator(Stack arguments, ScriptInstance script) {
        if (arguments.isEmpty()) {
            return BridgeUtilities.getArray(arguments).scalarIterator();
        }
        Scalar temp = (Scalar)arguments.pop();
        if (temp.getArray() != null) {
            return temp.getArray().scalarIterator();
        }
        if (SleepUtils.isFunctionScalar(temp)) {
            return SleepUtils.getFunctionFromScalar(temp).scalarIterator();
        }
        throw new IllegalArgumentException("expected iterator (@array or &closure)--received: " + SleepUtils.describe(temp));
    }

    public static ScalarArray getArray(Stack arguments) {
        Scalar s = BridgeUtilities.getScalar(arguments);
        if (s.getArray() == null) {
            return SleepUtils.getArrayScalar().getArray();
        }
        return s.getArray();
    }

    public static ScalarHash getHash(Stack arguments) {
        if (arguments.isEmpty()) {
            return SleepUtils.getHashScalar().getHash();
        }
        return ((Scalar)arguments.pop()).getHash();
    }

    public static ScalarArray getWorkableArray(Stack arguments) {
        if (arguments.isEmpty()) {
            return SleepUtils.getArrayScalar().getArray();
        }
        Scalar temp = (Scalar)arguments.pop();
        if (temp.getArray().getClass() == CollectionWrapper.class) {
            ScalarArray array2 = SleepUtils.getArrayScalar().getArray();
            Iterator i = temp.getArray().scalarIterator();
            while (i.hasNext()) {
                array2.push((Scalar)i.next());
            }
            return array2;
        }
        return temp.getArray();
    }

    public static Object getObject(Stack arguments) {
        if (arguments.isEmpty()) {
            return null;
        }
        return ((Scalar)arguments.pop()).objectValue();
    }

    public static SleepClosure getFunction(Stack arguments, ScriptInstance script) {
        Scalar temp = BridgeUtilities.getScalar(arguments);
        SleepClosure func = SleepUtils.getFunctionFromScalar(temp, script);
        if (func == null) {
            throw new IllegalArgumentException("expected &closure--received: " + SleepUtils.describe(temp));
        }
        return func;
    }

    public static Scalar getScalar(Stack arguments) {
        if (arguments.isEmpty()) {
            return SleepUtils.getEmptyScalar();
        }
        return (Scalar)arguments.pop();
    }

    public static String getString(Stack arguments, String defaultValue) {
        if (arguments.isEmpty()) {
            return defaultValue;
        }
        String temp = arguments.pop().toString();
        if (temp == null) {
            return defaultValue;
        }
        return temp;
    }

    public static File toSleepFile(String text, ScriptInstance i) {
        File f;
        if (text == null) {
            return i.cwd();
        }
        if (doReplace) {
            text = text.replace('/', File.separatorChar);
        }
        if (!(f = new File(text)).isAbsolute()) {
            return new File(i.cwd(), text);
        }
        return f;
    }

    public static File getFile(Stack arguments, ScriptInstance i) {
        return BridgeUtilities.toSleepFile(arguments.isEmpty() ? null : arguments.pop().toString(), i);
    }

    public static KeyValuePair getKeyValuePair(Stack arguments) {
        String temp;
        Scalar temps = BridgeUtilities.getScalar(arguments);
        if (temps.objectValue() != null && temps.objectValue().getClass() == KeyValuePair.class) {
            return (KeyValuePair)temps.objectValue();
        }
        if (temps.getActualValue() != null && (temp = ((Object)temps.getActualValue()).toString()).indexOf(61) > -1) {
            Scalar key = SleepUtils.getScalar(temp.substring(0, temp.indexOf(61)));
            Scalar value = SleepUtils.getScalar(temp.substring(temp.indexOf(61) + 1, temp.length()));
            return new KeyValuePair(key, value);
        }
        throw new IllegalArgumentException("attempted to pass a malformed key value pair: " + temps);
    }

    public static Scalar flattenArray(Scalar fromValue, Scalar toValue) {
        return BridgeUtilities.flattenIterator(fromValue.getArray().scalarIterator(), toValue);
    }

    public static Scalar flattenIterator(Iterator i, Scalar toValue) {
        if (toValue == null) {
            toValue = SleepUtils.getArrayScalar();
        }
        while (i.hasNext()) {
            Scalar temp = (Scalar)i.next();
            if (temp.getArray() != null) {
                BridgeUtilities.flattenArray(temp, toValue);
                continue;
            }
            toValue.getArray().push(temp);
        }
        return toValue;
    }

    public static int initLocalScope(ScriptVariables vars, Variable localLevel, Stack locals) {
        int name = 1;
        Scalar args = SleepUtils.getArrayScalar();
        while (!locals.isEmpty()) {
            Scalar lvar = (Scalar)locals.pop();
            if (lvar.getActualValue() != null && lvar.getActualValue().getType() == (class$sleep$engine$types$ObjectValue == null ? BridgeUtilities.class$("sleep.engine.types.ObjectValue") : class$sleep$engine$types$ObjectValue) && lvar.getActualValue().objectValue() != null && lvar.getActualValue().objectValue().getClass() == (class$sleep$bridges$KeyValuePair == null ? BridgeUtilities.class$("sleep.bridges.KeyValuePair") : class$sleep$bridges$KeyValuePair)) {
                KeyValuePair kvp = (KeyValuePair)lvar.getActualValue().objectValue();
                if (!Checkers.isVariable(kvp.getKey().toString())) {
                    throw new IllegalArgumentException("unreachable named parameter: " + kvp.getKey());
                }
                vars.setScalarLevel(kvp.getKey().toString(), kvp.getValue(), localLevel);
                continue;
            }
            args.getArray().push(lvar);
            vars.setScalarLevel("$" + name, lvar, localLevel);
            ++name;
        }
        vars.setScalarLevel("@_", args, localLevel);
        return name;
    }

    public static final int normalize(int value, int length) {
        return value < 0 ? value + length : value;
    }

    public static boolean expectArray(String n, Scalar value) {
        if (value.getArray() == null) {
            throw new IllegalArgumentException(n + ": expected array. received " + SleepUtils.describe(value));
        }
        return true;
    }
}

