/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges;

import [Ljava.lang.Class;;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import sleep.bridges.BridgeUtilities;
import sleep.bridges.KeyValuePair;
import sleep.bridges.Semaphore;
import sleep.bridges.SleepClosure;
import sleep.engine.Block;
import sleep.engine.ObjectUtilities;
import sleep.engine.ProxyInterface;
import sleep.engine.atoms.Iterate;
import sleep.engine.types.OrderedHashContainer;
import sleep.error.YourCodeSucksException;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Operator;
import sleep.interfaces.Predicate;
import sleep.interfaces.Variable;
import sleep.parser.ParserConfig;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarArray;
import sleep.runtime.ScriptInstance;
import sleep.runtime.ScriptLoader;
import sleep.runtime.ScriptVariables;
import sleep.runtime.SleepUtils;
import sleep.runtime.WatchScalar;
import sleep.taint.TaintUtils;

public class BasicUtilities
implements Function,
Loadable,
Predicate {
    static /* synthetic */ Class class$java$lang$Object;

    public void scriptUnloaded(ScriptInstance i) {
    }

    public void scriptLoaded(ScriptInstance i) {
        Hashtable temp = i.getScriptEnvironment().getEnvironment();
        array f_array = new array();
        hash f_hash = new hash();
        temp.put("&array", f_array);
        temp.put("&hash", f_hash);
        temp.put("&ohash", f_hash);
        temp.put("&ohasha", f_hash);
        temp.put("&@", f_array);
        temp.put("&%", f_hash);
        temp.put("&concat", this);
        temp.put("&keys", this);
        temp.put("&size", this);
        temp.put("&push", this);
        temp.put("&pop", this);
        temp.put("&add", this);
        temp.put("&flatten", this);
        temp.put("&clear", this);
        temp.put("&splice", this);
        temp.put("&subarray", this);
        temp.put("&sublist", this);
        temp.put("&copy", new copy());
        temp.put("&setRemovalPolicy", this);
        temp.put("&setMissPolicy", this);
        temp.put("&untaint", TaintUtils.Sanitizer(this));
        temp.put("&taint", TaintUtils.Tainter(this));
        map map_f = new map();
        temp.put("&map", map_f);
        temp.put("&filter", map_f);
        f_cast f_cast2 = new f_cast();
        temp.put("&cast", f_cast2);
        temp.put("&casti", f_cast2);
        temp.put("&putAll", this);
        temp.put("&addAll", this);
        temp.put("&removeAll", this);
        temp.put("&retainAll", this);
        temp.put("&pushl", this);
        temp.put("&popl", this);
        temp.put("&search", this);
        temp.put("&reduce", this);
        temp.put("&values", this);
        temp.put("&remove", this);
        temp.put("-istrue", this);
        temp.put("-isarray", this);
        temp.put("-ishash", this);
        temp.put("-isfunction", this);
        temp.put("-istainted", this);
        temp.put("isa", this);
        temp.put("in", this);
        temp.put("=~", this);
        temp.put("&setField", this);
        temp.put("&typeOf", this);
        temp.put("&newInstance", this);
        temp.put("&scalar", this);
        temp.put("&exit", this);
        SetScope scopeFunctions = new SetScope();
        temp.put("&local", scopeFunctions);
        temp.put("&this", scopeFunctions);
        temp.put("&global", scopeFunctions);
        temp.put("&watch", this);
        temp.put("&debug", this);
        temp.put("&warn", this);
        temp.put("&profile", this);
        temp.put("&getStackTrace", this);
        temp.put("&reverse", new reverse());
        temp.put("&removeAt", new removeAt());
        temp.put("&shift", new shift());
        temp.put("&systemProperties", new systemProperties());
        temp.put("&use", TaintUtils.Sensitive(new f_use()));
        temp.put("&include", TaintUtils.Sensitive((Function)temp.get("&use")));
        temp.put("&checkError", this);
        temp.put("&lambda", new lambda());
        temp.put("&compile_closure", TaintUtils.Sensitive((Function)temp.get("&lambda")));
        temp.put("&let", temp.get("&lambda"));
        function funcs = new function();
        temp.put("&function", TaintUtils.Sensitive(funcs));
        temp.put("function", temp.get("&function"));
        temp.put("&setf", funcs);
        temp.put("&eval", TaintUtils.Sensitive(new eval()));
        temp.put("&expr", TaintUtils.Sensitive((Function)temp.get("&eval")));
        SyncPrimitives sync = new SyncPrimitives();
        temp.put("&semaphore", sync);
        temp.put("&acquire", sync);
        temp.put("&release", sync);
        temp.put("&invoke", this);
        temp.put("&inline", this);
        temp.put("=>", new HashKeyValueOp());
    }

    public boolean decide(String predName, ScriptInstance anInstance, Stack terms) {
        if (predName.equals("isa")) {
            Class blah = BridgeUtilities.getClass(terms, null);
            Object bleh = BridgeUtilities.getObject(terms);
            return blah != null && blah.isInstance(bleh);
        }
        if (predName.equals("=~")) {
            Scalar right = BridgeUtilities.getScalar(terms);
            Scalar left = BridgeUtilities.getScalar(terms);
            return left.sameAs(right);
        }
        if (predName.equals("in")) {
            Iterator iter = BridgeUtilities.getIterator(terms, anInstance);
            Scalar left = BridgeUtilities.getScalar(terms);
            while (iter.hasNext()) {
                Scalar right = (Scalar)iter.next();
                if (!left.sameAs(right)) continue;
                return true;
            }
            return false;
        }
        Scalar value = (Scalar)terms.pop();
        if (predName.equals("-istrue")) {
            return SleepUtils.isTrueScalar(value);
        }
        if (predName.equals("-isfunction")) {
            return SleepUtils.isFunctionScalar(value);
        }
        if (predName.equals("-istainted")) {
            return TaintUtils.isTainted(value);
        }
        if (predName.equals("-isarray")) {
            return value.getArray() != null;
        }
        if (predName.equals("-ishash")) {
            return value.getHash() != null;
        }
        return false;
    }

    public Scalar evaluate(String n, ScriptInstance i, Stack l) {
        block94: {
            Scalar value;
            block99: {
                block98: {
                    Object temp;
                    block97: {
                        Serializable blah;
                        block96: {
                            SleepClosure f;
                            block95: {
                                block93: {
                                    ScalarArray b;
                                    ScalarArray a;
                                    if (l.isEmpty() && n.equals("&remove")) {
                                        Stack iterators = (Stack)i.getScriptEnvironment().getContextMetadata("iterators");
                                        if (iterators == null || iterators.isEmpty()) {
                                            throw new RuntimeException("&remove: no active foreach loop to remove element from");
                                        }
                                        Iterate.IteratorData d = (Iterate.IteratorData)iterators.peek();
                                        d.iterator.remove();
                                        --d.count;
                                        return d.source;
                                    }
                                    if (n.equals("&watch")) {
                                        temp = BridgeUtilities.getString(l, "");
                                        String[] vars = ((String)temp).split(" ");
                                        for (int x = 0; x < vars.length; ++x) {
                                            Variable level = i.getScriptVariables().getScalarLevel(vars[x], i);
                                            if (level == null) {
                                                throw new IllegalArgumentException(vars[x] + " must already exist in a scope prior to watching");
                                            }
                                            WatchScalar watch = new WatchScalar(vars[x], i.getScriptEnvironment());
                                            watch.setValue(level.getScalar(vars[x]));
                                            i.getScriptVariables().setScalarLevel(vars[x], watch, level);
                                        }
                                    } else {
                                        if (n.equals("&scalar")) {
                                            return ObjectUtilities.BuildScalar(true, BridgeUtilities.getObject(l));
                                        }
                                        if (n.equals("&untaint") || n.equals("&taint")) {
                                            return !l.isEmpty() ? (Scalar)l.pop() : SleepUtils.getEmptyScalar();
                                        }
                                        if (n.equals("&newInstance")) {
                                            Scalar top = BridgeUtilities.getScalar(l);
                                            if (top.getArray() != null) {
                                                Class[] clz = (Class[])ObjectUtilities.buildArgument(Class;.class, top, i);
                                                SleepClosure closure = (SleepClosure)BridgeUtilities.getObject(l);
                                                return SleepUtils.getScalar(ProxyInterface.BuildInterface(clz, (Function)closure, i));
                                            }
                                            Class clz = (Class)top.objectValue();
                                            SleepClosure closure = (SleepClosure)BridgeUtilities.getObject(l);
                                            return SleepUtils.getScalar(SleepUtils.newInstance(clz, closure, i));
                                        }
                                        if (n.equals("&typeOf")) {
                                            Scalar s = BridgeUtilities.getScalar(l);
                                            if (s.getArray() != null) {
                                                return SleepUtils.getScalar(s.getArray().getClass());
                                            }
                                            if (s.getHash() != null) {
                                                return SleepUtils.getScalar(s.getHash().getClass());
                                            }
                                            return SleepUtils.getScalar(s.getActualValue().getType());
                                        }
                                        if (n.equals("&inline")) {
                                            SleepClosure c = BridgeUtilities.getFunction(l, i);
                                            c.getRunnableCode().evaluate(i.getScriptEnvironment());
                                            return SleepUtils.getEmptyScalar();
                                        }
                                        if (n.equals("&invoke")) {
                                            Map params = BridgeUtilities.extractNamedParameters(l);
                                            SleepClosure c = BridgeUtilities.getFunction(l, i);
                                            Stack args = new Stack();
                                            Iterator iter = BridgeUtilities.getIterator(l, i);
                                            while (iter.hasNext()) {
                                                args.add(0, iter.next());
                                            }
                                            String message = BridgeUtilities.getString(l, null);
                                            if (params.containsKey("parameters")) {
                                                Scalar h = (Scalar)params.get("parameters");
                                                Iterator it = h.getHash().keys().scalarIterator();
                                                while (it.hasNext()) {
                                                    Scalar key = (Scalar)it.next();
                                                    KeyValuePair temp2 = new KeyValuePair(key, h.getHash().getAt(key));
                                                    args.add(0, SleepUtils.getScalar(temp2));
                                                }
                                            }
                                            if (params.containsKey("message")) {
                                                message = params.get("message").toString();
                                            }
                                            Variable old = c.getVariables();
                                            if (params.containsKey("$this")) {
                                                SleepClosure t = (SleepClosure)((Scalar)params.get("$this")).objectValue();
                                                c.setVariables(t.getVariables());
                                            }
                                            Scalar rv = c.callClosure(message, i, args);
                                            c.setVariables(old);
                                            return rv;
                                        }
                                        if (n.equals("&checkError")) {
                                            Scalar value2 = BridgeUtilities.getScalar(l);
                                            value2.setValue(i.getScriptEnvironment().checkError());
                                            return value2;
                                        }
                                        if (n.equals("&profile")) {
                                            return SleepUtils.getArrayWrapper(i.getProfilerStatistics());
                                        }
                                        if (n.equals("&getStackTrace")) {
                                            return SleepUtils.getArrayWrapper(i.getStackTrace());
                                        }
                                        if (n.equals("&warn")) {
                                            i.fireWarning(BridgeUtilities.getString(l, "warning requested"), BridgeUtilities.getInt(l, -1));
                                            return SleepUtils.getEmptyScalar();
                                        }
                                        if (n.equals("&debug")) {
                                            if (!l.isEmpty()) {
                                                int flag = BridgeUtilities.getInt(l, 0);
                                                i.setDebugFlags(flag);
                                            }
                                            return SleepUtils.getScalar(i.getDebugFlags());
                                        }
                                        if (n.equals("&flatten")) {
                                            return BridgeUtilities.flattenIterator(BridgeUtilities.getIterator(l, i), null);
                                        }
                                        if (n.equals("&pushl") || n.equals("&popl")) {
                                            ScriptVariables vars = i.getScriptVariables();
                                            if (n.equals("&pushl")) {
                                                vars.pushLocalLevel();
                                            } else if (n.equals("&popl")) {
                                                if (vars.haveMoreLocals()) {
                                                    vars.popLocalLevel();
                                                } else {
                                                    throw new RuntimeException("&popl: no more local frames exist");
                                                }
                                            }
                                            if (!l.isEmpty()) {
                                                BridgeUtilities.initLocalScope(vars, vars.getLocalVariables(), l);
                                            }
                                            return SleepUtils.getEmptyScalar();
                                        }
                                        if (n.equals("&concat")) {
                                            Scalar value3 = SleepUtils.getArrayScalar();
                                            while (!l.isEmpty()) {
                                                Scalar temp3 = (Scalar)l.pop();
                                                if (temp3.getArray() != null) {
                                                    Iterator iter = temp3.getArray().scalarIterator();
                                                    while (iter.hasNext()) {
                                                        value3.getArray().push(SleepUtils.getScalar((Scalar)iter.next()));
                                                    }
                                                    continue;
                                                }
                                                value3.getArray().push(SleepUtils.getScalar(temp3));
                                            }
                                            return value3;
                                        }
                                    }
                                    value = BridgeUtilities.getScalar(l);
                                    if (n.equals("&push") && BridgeUtilities.expectArray(n, value)) {
                                        Scalar pushed = null;
                                        while (!l.isEmpty()) {
                                            pushed = (Scalar)l.pop();
                                            value.getArray().push(SleepUtils.getScalar(pushed));
                                        }
                                        return pushed == null ? SleepUtils.getEmptyScalar() : pushed;
                                    }
                                    if ((n.equals("&retainAll") || n.equals("&removeAll")) && BridgeUtilities.expectArray(n, value)) {
                                        a = value.getArray();
                                        b = BridgeUtilities.getArray(l);
                                        HashSet<Object> s = new HashSet<Object>();
                                        Iterator iter = b.scalarIterator();
                                        while (iter.hasNext()) {
                                            Scalar temp4 = (Scalar)iter.next();
                                            s.add(temp4.identity());
                                        }
                                        iter = a.scalarIterator();
                                        while (iter.hasNext()) {
                                            Scalar temp5 = (Scalar)iter.next();
                                            if (!s.contains(temp5.identity())) {
                                                if (!n.equals("&retainAll")) continue;
                                                iter.remove();
                                                continue;
                                            }
                                            if (!n.equals("&removeAll")) continue;
                                            iter.remove();
                                        }
                                        return SleepUtils.getArrayScalar(a);
                                    }
                                    if (n.equals("&addAll") && BridgeUtilities.expectArray(n, value)) {
                                        Scalar temp6;
                                        a = value.getArray();
                                        b = BridgeUtilities.getArray(l);
                                        HashSet<Object> s = new HashSet<Object>();
                                        Iterator iter = a.scalarIterator();
                                        while (iter.hasNext()) {
                                            temp6 = (Scalar)iter.next();
                                            s.add(temp6.identity());
                                        }
                                        iter = b.scalarIterator();
                                        while (iter.hasNext()) {
                                            temp6 = (Scalar)iter.next();
                                            if (s.contains(temp6.identity())) continue;
                                            a.push(SleepUtils.getScalar(temp6));
                                        }
                                        return SleepUtils.getArrayScalar(a);
                                    }
                                    if (n.equals("&add") && value.getArray() != null) {
                                        Scalar item = BridgeUtilities.getScalar(l);
                                        int index = BridgeUtilities.normalize(BridgeUtilities.getInt(l, 0), value.getArray().size() + 1);
                                        value.getArray().add(SleepUtils.getScalar(item), index);
                                        return value;
                                    }
                                    if (n.equals("&add") && value.getHash() != null) {
                                        while (!l.isEmpty()) {
                                            KeyValuePair kvp = BridgeUtilities.getKeyValuePair(l);
                                            blah = value.getHash().getAt(kvp.getKey());
                                            ((Scalar)blah).setValue(kvp.getValue());
                                        }
                                        return value;
                                    }
                                    if (n.equals("&splice") && BridgeUtilities.expectArray(n, value)) {
                                        ScalarArray insert = BridgeUtilities.getArray(l);
                                        int start = BridgeUtilities.normalize(BridgeUtilities.getInt(l, 0), value.getArray().size());
                                        int torem = BridgeUtilities.getInt(l, insert.size()) + start;
                                        int y = start;
                                        Iterator iter = value.getArray().scalarIterator();
                                        for (int x = 0; x < start && iter.hasNext(); ++x) {
                                            iter.next();
                                        }
                                        while (y < torem) {
                                            if (iter.hasNext()) {
                                                iter.next();
                                                iter.remove();
                                            }
                                            ++y;
                                        }
                                        ListIterator liter = (ListIterator)value.getArray().scalarIterator();
                                        for (int x = 0; x < start && liter.hasNext(); ++x) {
                                            liter.next();
                                        }
                                        Iterator j = insert.scalarIterator();
                                        while (j.hasNext()) {
                                            Scalar ins = (Scalar)j.next();
                                            liter.add(ins);
                                        }
                                        return value;
                                    }
                                    if (n.equals("&pop") && BridgeUtilities.expectArray(n, value)) {
                                        return value.getArray().pop();
                                    }
                                    if (n.equals("&size") && value.getArray() != null) {
                                        return SleepUtils.getScalar(value.getArray().size());
                                    }
                                    if (n.equals("&size") && value.getHash() != null) {
                                        return SleepUtils.getScalar(value.getHash().keys().size());
                                    }
                                    if (!n.equals("&clear")) break block93;
                                    if (value.getArray() != null) {
                                        Iterator iter = value.getArray().scalarIterator();
                                        while (iter.hasNext()) {
                                            iter.next();
                                            iter.remove();
                                        }
                                    } else if (value.getHash() != null) {
                                        value.setValue(SleepUtils.getHashScalar());
                                    } else {
                                        value.setValue(SleepUtils.getEmptyScalar());
                                    }
                                    break block94;
                                }
                                if (!n.equals("&search") || !BridgeUtilities.expectArray(n, value)) break block95;
                                f = BridgeUtilities.getFunction(l, i);
                                int start = BridgeUtilities.normalize(BridgeUtilities.getInt(l, 0), value.getArray().size());
                                int count = 0;
                                Stack<Scalar> locals = new Stack<Scalar>();
                                Iterator iter = value.getArray().scalarIterator();
                                while (iter.hasNext()) {
                                    Scalar temp7 = (Scalar)iter.next();
                                    if (start > 0) {
                                        --start;
                                        ++count;
                                        continue;
                                    }
                                    locals.push(SleepUtils.getScalar(count));
                                    locals.push(temp7);
                                    Scalar val = f.callClosure("eval", i, locals);
                                    if (!SleepUtils.isEmptyScalar(val)) {
                                        return val;
                                    }
                                    locals.clear();
                                    ++count;
                                }
                                break block94;
                            }
                            if (n.equals("&reduce") && SleepUtils.isFunctionScalar(value)) {
                                f = SleepUtils.getFunctionFromScalar(value, i);
                                Stack<Scalar> locals = new Stack<Scalar>();
                                Iterator iter = BridgeUtilities.getIterator(l, i);
                                Scalar a = iter.hasNext() ? (Scalar)iter.next() : SleepUtils.getEmptyScalar();
                                Scalar b = iter.hasNext() ? (Scalar)iter.next() : SleepUtils.getEmptyScalar();
                                Object temp8 = null;
                                locals.push(a);
                                locals.push(b);
                                a = f.callClosure("eval", i, locals);
                                locals.clear();
                                while (iter.hasNext()) {
                                    b = (Scalar)iter.next();
                                    locals.push(b);
                                    locals.push(a);
                                    a = f.callClosure("eval", i, locals);
                                    locals.clear();
                                }
                                return a;
                            }
                            if ((n.equals("&subarray") || n.equals("&sublist")) && BridgeUtilities.expectArray(n, value)) {
                                return BasicUtilities.sublist(value, BridgeUtilities.getInt(l, 0), BridgeUtilities.getInt(l, value.getArray().size()));
                            }
                            if (n.equals("&remove")) {
                                while (!l.isEmpty()) {
                                    Scalar scalar = (Scalar)l.pop();
                                    if (value.getArray() != null) {
                                        value.getArray().remove(scalar);
                                        continue;
                                    }
                                    if (value.getHash() == null) continue;
                                    value.getHash().remove(scalar);
                                }
                                return value;
                            }
                            if (!n.equals("&keys")) break block96;
                            if (value.getHash() != null) {
                                temp = SleepUtils.getEmptyScalar();
                                ((Scalar)temp).setValue(value.getHash().keys());
                                return temp;
                            }
                            break block94;
                        }
                        if (!n.equals("&setRemovalPolicy") && !n.equals("&setMissPolicy")) break block97;
                        if (value.getHash() == null || !(value.getHash() instanceof OrderedHashContainer)) {
                            throw new IllegalArgumentException(n + ": expected an ordered hash, received: " + SleepUtils.describe(value));
                        }
                        SleepClosure function2 = BridgeUtilities.getFunction(l, i);
                        blah = (OrderedHashContainer)value.getHash();
                        if (n.equals("&setMissPolicy")) {
                            ((OrderedHashContainer)blah).setMissPolicy(function2);
                        } else {
                            ((OrderedHashContainer)blah).setRemovalPolicy(function2);
                        }
                        break block94;
                    }
                    if (n.equals("&putAll")) {
                        if (value.getHash() != null) {
                            Iterator values;
                            Iterator keys = BridgeUtilities.getIterator(l, i);
                            Iterator iterator = values = l.isEmpty() ? keys : BridgeUtilities.getIterator(l, i);
                            while (keys.hasNext()) {
                                Scalar blah = value.getHash().getAt((Scalar)keys.next());
                                if (values.hasNext()) {
                                    blah.setValue((Scalar)values.next());
                                    continue;
                                }
                                blah.setValue(SleepUtils.getEmptyScalar());
                            }
                        }
                        return value;
                    }
                    if (!n.equals("&values")) break block98;
                    if (value.getHash() != null) {
                        temp = SleepUtils.getArrayScalar();
                        Iterator iter = value.getHash().getData().values().iterator();
                        while (iter.hasNext()) {
                            Scalar next = (Scalar)iter.next();
                            if (SleepUtils.isEmptyScalar(next)) continue;
                            ((Scalar)temp).getArray().push(next);
                        }
                        return temp;
                    }
                    break block94;
                }
                if (!n.equals("&exit")) break block99;
                i.getScriptEnvironment().flagReturn(null, 16);
                if (!SleepUtils.isEmptyScalar(value)) {
                    throw new RuntimeException(value.toString());
                }
                break block94;
            }
            if (!n.equals("&setField")) break block94;
            Field setMe = null;
            Class<?> aClass = null;
            Object inst = null;
            if (value.objectValue() == null) {
                throw new IllegalArgumentException("&setField: can not set field on a null object");
            }
            if (value.objectValue() instanceof Class) {
                aClass = (Class<?>)value.objectValue();
                inst = null;
            } else {
                inst = value.objectValue();
                aClass = inst.getClass();
            }
            while (!l.isEmpty()) {
                KeyValuePair pair = BridgeUtilities.getKeyValuePair(l);
                String name = pair.getKey().toString();
                Scalar arg = pair.getValue();
                try {
                    setMe = aClass.getDeclaredField(name);
                    if (ObjectUtilities.isArgMatch(setMe.getType(), arg) != 0) {
                        setMe.setAccessible(true);
                        setMe.set(inst, ObjectUtilities.buildArgument(setMe.getType(), arg, i));
                        continue;
                    }
                    throw new RuntimeException("unable to convert " + SleepUtils.describe(arg) + " to a " + setMe.getType());
                }
                catch (NoSuchFieldException fex) {
                    throw new RuntimeException("no field named " + name + " in " + aClass);
                }
                catch (RuntimeException rex) {
                    throw rex;
                }
                catch (Exception ex) {
                    throw new RuntimeException("cannot set " + name + " in " + aClass + ": " + ex.getMessage());
                }
            }
        }
        return SleepUtils.getEmptyScalar();
    }

    private static Scalar sublist(Scalar value, int _start, int _end) {
        int length = value.getArray().size();
        int start = BridgeUtilities.normalize(_start, length);
        int end = _end < 0 ? _end + length : _end;
        int n = end = end <= length ? end : length;
        if (start > end) {
            throw new IllegalArgumentException("illegal subarray(" + SleepUtils.describe(value) + ", " + _start + " -> " + start + ", " + _end + " -> " + end + ")");
        }
        return SleepUtils.getArrayScalar(value.getArray().sublist(start, end));
    }

    static {
        ParserConfig.addKeyword("isa");
        ParserConfig.addKeyword("in");
        ParserConfig.addKeyword("=~");
    }

    private static class eval
    implements Function {
        private eval() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            String code = l.pop().toString();
            try {
                if (n.equals("&eval")) {
                    Scalar temp = SleepUtils.getScalar(i.getScriptEnvironment().evaluateStatement(code));
                    return temp;
                }
                Scalar temp = SleepUtils.getScalar(i.getScriptEnvironment().evaluateExpression(code));
                return temp;
            }
            catch (YourCodeSucksException ex) {
                i.getScriptEnvironment().flagError(ex);
                return SleepUtils.getEmptyScalar();
            }
        }
    }

    private static class systemProperties
    implements Function {
        private systemProperties() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            return SleepUtils.getHashWrapper(System.getProperties());
        }
    }

    private static class SetScope
    implements Function {
        private Pattern splitter = Pattern.compile(" ");

        private SetScope() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            Variable level = null;
            if (n.equals("&local")) {
                level = i.getScriptVariables().getLocalVariables();
            } else if (n.equals("&this")) {
                level = i.getScriptVariables().getClosureVariables();
            } else if (n.equals("&global")) {
                level = i.getScriptVariables().getGlobalVariables();
            }
            String temp = l.pop().toString();
            if (level == null) {
                return SleepUtils.getEmptyScalar();
            }
            String[] vars = this.splitter.split(temp);
            for (int x = 0; x < vars.length; ++x) {
                if (level.scalarExists(vars[x])) continue;
                if (vars[x].charAt(0) == '$') {
                    i.getScriptVariables().setScalarLevel(vars[x], SleepUtils.getEmptyScalar(), level);
                    continue;
                }
                if (vars[x].charAt(0) == '@') {
                    i.getScriptVariables().setScalarLevel(vars[x], SleepUtils.getArrayScalar(), level);
                    continue;
                }
                if (vars[x].charAt(0) != '%') continue;
                i.getScriptVariables().setScalarLevel(vars[x], SleepUtils.getHashScalar(), level);
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class reverse
    implements Function {
        private reverse() {
        }

        public Scalar evaluate(String n, ScriptInstance si, Stack l) {
            Scalar value = SleepUtils.getArrayScalar();
            Iterator i = BridgeUtilities.getIterator(l, si);
            while (i.hasNext()) {
                value.getArray().add(SleepUtils.getScalar((Scalar)i.next()), 0);
            }
            return value;
        }
    }

    private static class shift
    implements Function {
        private shift() {
        }

        public Scalar evaluate(String n, ScriptInstance si, Stack l) {
            ScalarArray value = BridgeUtilities.getArray(l);
            return value.remove(0);
        }
    }

    private static class removeAt
    implements Function {
        private removeAt() {
        }

        public Scalar evaluate(String n, ScriptInstance si, Stack l) {
            block3: {
                Scalar value;
                block2: {
                    value = (Scalar)l.pop();
                    if (value.getArray() == null) break block2;
                    while (!l.isEmpty()) {
                        value.getArray().remove(BridgeUtilities.normalize(BridgeUtilities.getInt(l, 0), value.getArray().size()));
                    }
                    break block3;
                }
                if (value.getHash() == null) break block3;
                while (!l.isEmpty()) {
                    Scalar remove = value.getHash().getAt((Scalar)l.pop());
                    remove.setValue(SleepUtils.getEmptyScalar());
                }
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class copy
    implements Function {
        private copy() {
        }

        public Scalar evaluate(String n, ScriptInstance si, Stack l) {
            Scalar doit = BridgeUtilities.getScalar(l);
            if (doit.getArray() != null || SleepUtils.isFunctionScalar(doit)) {
                Iterator i;
                Scalar value = SleepUtils.getArrayScalar();
                Iterator iterator = i = doit.getArray() == null ? SleepUtils.getFunctionFromScalar(doit, si).scalarIterator() : doit.getArray().scalarIterator();
                while (i.hasNext()) {
                    value.getArray().push(SleepUtils.getScalar((Scalar)i.next()));
                }
                return value;
            }
            if (doit.getHash() != null) {
                Scalar value = SleepUtils.getHashScalar();
                Iterator i = doit.getHash().keys().scalarIterator();
                while (i.hasNext()) {
                    Scalar key = (Scalar)i.next();
                    Scalar temp = value.getHash().getAt(key);
                    temp.setValue(doit.getHash().getAt(key));
                }
                return value;
            }
            return SleepUtils.getScalar(doit);
        }
    }

    private static class map
    implements Function {
        private map() {
        }

        public Scalar evaluate(String n, ScriptInstance si, Stack l) {
            SleepClosure temp = BridgeUtilities.getFunction(l, si);
            Iterator i = BridgeUtilities.getIterator(l, si);
            Scalar rv = SleepUtils.getArrayScalar();
            Stack locals = new Stack();
            while (i.hasNext()) {
                locals.push(i.next());
                Scalar val = temp.callClosure("eval", si, locals);
                if (!SleepUtils.isEmptyScalar(val) || n.equals("&map")) {
                    rv.getArray().push(SleepUtils.getScalar(val));
                }
                locals.clear();
            }
            return rv;
        }
    }

    private static class lambda
    implements Function {
        private lambda() {
        }

        public Scalar evaluate(String n, ScriptInstance si, Stack l) {
            SleepClosure value;
            SleepClosure temp;
            if (n.equals("&lambda")) {
                temp = BridgeUtilities.getFunction(l, si);
                value = new SleepClosure(si, temp.getRunnableCode());
            } else if (n.equals("&compile_closure")) {
                String code = l.pop().toString();
                try {
                    value = temp = new SleepClosure(si, SleepUtils.ParseCode(code));
                }
                catch (YourCodeSucksException ex) {
                    si.getScriptEnvironment().flagError(ex);
                    return SleepUtils.getEmptyScalar();
                }
            } else {
                value = temp = BridgeUtilities.getFunction(l, si);
            }
            Variable vars = value.getVariables();
            while (!l.isEmpty()) {
                KeyValuePair kvp = BridgeUtilities.getKeyValuePair(l);
                if (kvp.getKey().toString().equals("$this")) {
                    SleepClosure c = (SleepClosure)kvp.getValue().objectValue();
                    value.setVariables(c.getVariables());
                    vars = c.getVariables();
                    continue;
                }
                vars.putScalar(kvp.getKey().toString(), SleepUtils.getScalar(kvp.getValue()));
            }
            return SleepUtils.getScalar(value);
        }
    }

    private static class hash
    implements Function {
        private hash() {
        }

        public Scalar evaluate(String n, ScriptInstance si, Stack l) {
            Scalar value = null;
            value = n.equals("&ohash") ? SleepUtils.getOrderedHashScalar() : (n.equals("&ohasha") ? SleepUtils.getAccessOrderedHashScalar() : SleepUtils.getHashScalar());
            while (!l.isEmpty()) {
                KeyValuePair kvp = BridgeUtilities.getKeyValuePair(l);
                Scalar blah = value.getHash().getAt(kvp.getKey());
                blah.setValue(kvp.getValue());
            }
            return value;
        }
    }

    private static class function
    implements Function {
        private function() {
        }

        public Scalar evaluate(String n, ScriptInstance si, Stack l) {
            if (n.equals("&function") || n.equals("function")) {
                String temp = BridgeUtilities.getString(l, "");
                if (temp.length() == 0 || temp.charAt(0) != '&') {
                    throw new IllegalArgumentException(n + ": requested function name must begin with '&'");
                }
                return SleepUtils.getScalar(si.getScriptEnvironment().getFunction(temp));
            }
            if (n.equals("&setf")) {
                String temp = BridgeUtilities.getString(l, "&eh");
                Object o = BridgeUtilities.getObject(l);
                if (temp.charAt(0) == '&' && (o == null || o instanceof Function)) {
                    if (o == null) {
                        si.getScriptEnvironment().getEnvironment().remove(temp);
                    } else {
                        si.getScriptEnvironment().getEnvironment().put(temp, o);
                    }
                } else {
                    if (temp.charAt(0) != '&') {
                        throw new IllegalArgumentException("&setf: invalid function name '" + temp + "'");
                    }
                    if (o != null) {
                        throw new IllegalArgumentException("&setf: can not set function " + temp + " to a " + o.getClass());
                    }
                }
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class f_cast
    implements Function {
        private f_cast() {
        }

        public Scalar evaluate(String n, ScriptInstance si, Stack l) {
            Scalar flat;
            Scalar value = BridgeUtilities.getScalar(l);
            Scalar type = BridgeUtilities.getScalar(l);
            if (n.equals("&casti")) {
                Class atype = ObjectUtilities.convertScalarDescriptionToClass(type);
                if (atype != null) {
                    Object tempo = ObjectUtilities.buildArgument(atype, value, si);
                    return SleepUtils.getScalar(tempo);
                }
                throw new RuntimeException("&casti: '" + type + "' is an invalid primitive cast identifier");
            }
            if (value.getArray() == null) {
                if (type.toString().charAt(0) == 'c') {
                    return SleepUtils.getScalar(value.toString().toCharArray());
                }
                if (type.toString().charAt(0) == 'b') {
                    return SleepUtils.getScalar((Object)BridgeUtilities.toByteArrayNoConversion(value.toString()));
                }
                return SleepUtils.getEmptyScalar();
            }
            if (l.size() == 0) {
                l.push(SleepUtils.getScalar(value.getArray().size()));
            }
            int[] dimensions = new int[l.size()];
            int totaldim = 1;
            int x = 0;
            while (!l.isEmpty()) {
                dimensions[x] = BridgeUtilities.getInt(l, 0);
                totaldim *= dimensions[x];
                ++x;
            }
            Class atype = ObjectUtilities.convertScalarDescriptionToClass(type);
            if (atype == null) {
                atype = ObjectUtilities.getArrayType(value, class$java$lang$Object == null ? (class$java$lang$Object = BasicUtilities.class$("java.lang.Object")) : class$java$lang$Object);
            }
            if (totaldim != (flat = BridgeUtilities.flattenArray(value, null)).getArray().size()) {
                throw new RuntimeException("&cast: specified dimensions " + totaldim + " is not equal to total array elements " + flat.getArray().size());
            }
            Object rv = Array.newInstance(atype, dimensions);
            int[] current = new int[dimensions.length];
            int x2 = 0;
            while (true) {
                Object tempa = rv;
                for (int z = 0; z < current.length - 1; ++z) {
                    tempa = Array.get(tempa, current[z]);
                }
                Object tempo = ObjectUtilities.buildArgument(atype, flat.getArray().getAt(x2), si);
                Array.set(tempa, current[current.length - 1], tempo);
                int n2 = current.length - 1;
                current[n2] = current[n2] + 1;
                int y = current.length - 1;
                while (current[y] >= dimensions[y]) {
                    if (y == 0) {
                        return SleepUtils.getScalar(rv);
                    }
                    current[y] = 0;
                    int n3 = y - 1;
                    current[n3] = current[n3] + 1;
                    --y;
                }
                ++x2;
            }
        }
    }

    private static class array
    implements Function {
        private array() {
        }

        public Scalar evaluate(String n, ScriptInstance si, Stack l) {
            Scalar value = SleepUtils.getArrayScalar();
            while (!l.isEmpty()) {
                value.getArray().push(SleepUtils.getScalar(BridgeUtilities.getScalar(l)));
            }
            return value;
        }
    }

    private static class f_use
    implements Function {
        private HashMap bridges = new HashMap();

        private f_use() {
        }

        public Scalar evaluate(String n, ScriptInstance si, Stack l) {
            block17: {
                File parent = null;
                String className = "";
                Class<?> bridge = null;
                if (l.size() == 2) {
                    parent = ParserConfig.findJarFile(l.pop().toString());
                    className = BridgeUtilities.getString(l, "");
                } else {
                    Scalar obj = (Scalar)l.pop();
                    if (obj.objectValue() instanceof Class && n.equals("&use")) {
                        bridge = (Class<?>)obj.objectValue();
                    } else {
                        File a = ParserConfig.findJarFile(obj.toString());
                        parent = a.getParentFile();
                        className = a.getName();
                    }
                }
                if (parent != null && !parent.exists()) {
                    throw new IllegalArgumentException(n + ": could not locate source '" + parent + "'");
                }
                try {
                    InputStream istream;
                    if (n.equals("&use")) {
                        Loadable temp;
                        if (bridge == null) {
                            if (parent != null) {
                                URLClassLoader loader = new URLClassLoader(new URL[]{parent.toURL()});
                                bridge = Class.forName(className, true, loader);
                            } else {
                                bridge = Class.forName(className);
                            }
                        }
                        if (this.bridges.get(bridge) == null) {
                            temp = (Loadable)bridge.newInstance();
                            this.bridges.put(bridge, temp);
                        } else {
                            temp = (Loadable)this.bridges.get(bridge);
                        }
                        temp.scriptLoaded(si);
                        break block17;
                    }
                    ScriptLoader sloader = (ScriptLoader)si.getScriptEnvironment().getEnvironment().get("(isloaded)");
                    if (parent != null) {
                        File theFile = parent.isDirectory() ? new File(parent, className) : parent;
                        URLClassLoader loader = new URLClassLoader(new URL[]{parent.toURL()});
                        sloader.touch(className, theFile.lastModified());
                        si.associateFile(theFile);
                        istream = loader.getResourceAsStream(className);
                    } else {
                        File tempf = BridgeUtilities.toSleepFile(className, si);
                        sloader.touch(className, tempf.lastModified());
                        si.associateFile(tempf);
                        istream = new FileInputStream(tempf);
                    }
                    if (istream != null) {
                        Block script = sloader.compileScript(className, istream);
                        SleepUtils.runCode(script, si.getScriptEnvironment());
                        break block17;
                    }
                    throw new IOException("unable to locate " + className + " from: " + parent);
                }
                catch (YourCodeSucksException yex) {
                    si.getScriptEnvironment().flagError(yex);
                }
                catch (Exception ex) {
                    si.getScriptEnvironment().flagError(ex);
                }
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class HashKeyValueOp
    implements Operator {
        private HashKeyValueOp() {
        }

        public Scalar operate(String name, ScriptInstance script, Stack locals) {
            Scalar identifier = (Scalar)locals.pop();
            Scalar value = (Scalar)locals.pop();
            return SleepUtils.getScalar(new KeyValuePair(identifier, value));
        }
    }

    private static class SyncPrimitives
    implements Function {
        private SyncPrimitives() {
        }

        public Scalar evaluate(String n, ScriptInstance si, Stack l) {
            if (n.equals("&semaphore")) {
                int initial = BridgeUtilities.getInt(l, 1);
                return SleepUtils.getScalar(new Semaphore(initial));
            }
            if (n.equals("&acquire")) {
                Semaphore sem = (Semaphore)BridgeUtilities.getObject(l);
                sem.P();
            } else if (n.equals("&release")) {
                Semaphore sem = (Semaphore)BridgeUtilities.getObject(l);
                sem.V();
            }
            return SleepUtils.getEmptyScalar();
        }
    }
}

