/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges;

import java.util.Comparator;
import java.util.Hashtable;
import java.util.Stack;
import sleep.bridges.BridgeUtilities;
import sleep.bridges.SleepClosure;
import sleep.bridges.Transliteration;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Operator;
import sleep.interfaces.Predicate;
import sleep.parser.ParserConfig;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarArray;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class BasicStrings
implements Loadable {
    public void scriptUnloaded(ScriptInstance aScript) {
    }

    public void scriptLoaded(ScriptInstance aScript) {
        Hashtable temp = aScript.getScriptEnvironment().getEnvironment();
        temp.put("&left", new func_left());
        temp.put("&right", new func_right());
        temp.put("&charAt", new func_charAt());
        temp.put("&byteAt", temp.get("&charAt"));
        temp.put("&uc", new func_uc());
        temp.put("&lc", new func_lc());
        func_substr f_substr = new func_substr();
        temp.put("&substr", f_substr);
        temp.put("&mid", f_substr);
        temp.put("&indexOf", new func_indexOf());
        temp.put("&lindexOf", temp.get("&indexOf"));
        temp.put("&strlen", new func_strlen());
        temp.put("&strrep", new func_strrep());
        temp.put("&replaceAt", new func_replaceAt());
        temp.put("&tr", new func_tr());
        temp.put("&asc", new func_asc());
        temp.put("&chr", new func_chr());
        temp.put("&sort", new func_sort());
        func_sorters funky = new func_sorters();
        temp.put("&sorta", funky);
        temp.put("&sortn", funky);
        temp.put("&sortd", funky);
        temp.put("eq", new pred_eq());
        temp.put("ne", new pred_ne());
        temp.put("lt", new pred_lt());
        temp.put("gt", new pred_gt());
        temp.put("-isletter", new pred_isletter());
        temp.put("-isnumber", new pred_isnumber());
        temp.put("isin", new pred_isin());
        temp.put("iswm", new pred_iswm());
        temp.put(".", new oper_concat());
        temp.put("x", new oper_multiply());
        temp.put("cmp", new oper_compare());
        temp.put("<=>", new oper_spaceship());
    }

    private static final String substring(String func, String str, int _start, int _end) {
        int length = str.length();
        int start = BridgeUtilities.normalize(_start, length);
        int end = _end < 0 ? _end + length : _end;
        int n = end = end <= length ? end : length;
        if (start == end) {
            return "";
        }
        if (start > end) {
            throw new IllegalArgumentException(func + ": illegal substring('" + str + "', " + _start + " -> " + start + ", " + _end + " -> " + end + ") indices");
        }
        return str.substring(start, end);
    }

    private static final char charAt(String str, int start) {
        return str.charAt(BridgeUtilities.normalize(start, str.length()));
    }

    static {
        ParserConfig.addKeyword("x");
        ParserConfig.addKeyword("eq");
        ParserConfig.addKeyword("ne");
        ParserConfig.addKeyword("lt");
        ParserConfig.addKeyword("gt");
        ParserConfig.addKeyword("isin");
        ParserConfig.addKeyword("iswm");
        ParserConfig.addKeyword("cmp");
    }

    private static class oper_spaceship
    implements Operator {
        private oper_spaceship() {
        }

        public Scalar operate(String o, ScriptInstance i, Stack l) {
            double left = BridgeUtilities.getDouble(l, 0.0);
            double right = BridgeUtilities.getDouble(l, 0.0);
            return SleepUtils.getScalar(left - right);
        }
    }

    private static class oper_compare
    implements Operator {
        private oper_compare() {
        }

        public Scalar operate(String o, ScriptInstance i, Stack l) {
            Scalar left = (Scalar)l.pop();
            Scalar right = (Scalar)l.pop();
            return SleepUtils.getScalar(left.toString().compareTo(right.toString()));
        }
    }

    private static class oper_multiply
    implements Operator {
        private oper_multiply() {
        }

        public Scalar operate(String o, ScriptInstance i, Stack l) {
            Scalar left = (Scalar)l.pop();
            Scalar right = (Scalar)l.pop();
            String str = left.toString();
            int num = right.intValue();
            StringBuffer value = new StringBuffer();
            for (int x = 0; x < num; ++x) {
                value.append(str);
            }
            return SleepUtils.getScalar(value);
        }
    }

    private static class oper_concat
    implements Operator {
        private oper_concat() {
        }

        public Scalar operate(String o, ScriptInstance i, Stack l) {
            Scalar left = (Scalar)l.pop();
            Scalar right = (Scalar)l.pop();
            if (o.equals(".")) {
                return SleepUtils.getScalar(left.toString() + right.toString());
            }
            return null;
        }
    }

    private static class CompareStrings
    implements Comparator {
        private CompareStrings() {
        }

        public int compare(Object a, Object b) {
            return a.toString().compareTo(b.toString());
        }
    }

    private static class CompareDoubles
    implements Comparator {
        private CompareDoubles() {
        }

        public int compare(Object a, Object b) {
            double bb;
            double aa = ((Scalar)a).doubleValue();
            if (aa == (bb = ((Scalar)b).doubleValue())) {
                return 0;
            }
            if (aa < bb) {
                return -1;
            }
            return 1;
        }
    }

    private static class CompareNumbers
    implements Comparator {
        private CompareNumbers() {
        }

        public int compare(Object a, Object b) {
            long aa = ((Scalar)a).longValue();
            long bb = ((Scalar)b).longValue();
            return (int)(aa - bb);
        }
    }

    private static class CompareFunction
    implements Comparator {
        protected SleepClosure func;
        protected ScriptInstance script;
        protected Stack locals;

        public CompareFunction(Function _func, ScriptInstance _script) {
            this.func = (SleepClosure)_func;
            this.script = _script;
            this.locals = new Stack();
        }

        public int compare(Object a, Object b) {
            this.locals.push(b);
            this.locals.push(a);
            Scalar temp = this.func.callClosure("&sort", this.script, this.locals);
            return temp.intValue();
        }
    }

    private static class func_sorters
    implements Function {
        private func_sorters() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            ScalarArray array2 = BridgeUtilities.getWorkableArray(l);
            if (n.equals("&sorta")) {
                array2.sort(new CompareStrings());
            } else if (n.equals("&sortn")) {
                array2.sort(new CompareNumbers());
            } else if (n.equals("&sortd")) {
                array2.sort(new CompareDoubles());
            }
            return SleepUtils.getArrayScalar(array2);
        }
    }

    private static class func_sort
    implements Function {
        private func_sort() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            if (l.size() != 2) {
                throw new IllegalArgumentException("&sort requires a function to specify how to sort the data");
            }
            SleepClosure my_func = BridgeUtilities.getFunction(l, i);
            ScalarArray array2 = BridgeUtilities.getWorkableArray(l);
            if (my_func == null) {
                return SleepUtils.getArrayScalar();
            }
            array2.sort(new CompareFunction(my_func, i));
            return SleepUtils.getArrayScalar(array2);
        }
    }

    private static class func_charAt
    implements Function {
        private func_charAt() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            String value = l.pop().toString();
            int start = BridgeUtilities.getInt(l);
            if (n.equals("&charAt")) {
                return SleepUtils.getScalar(BasicStrings.charAt(value, start) + "");
            }
            return SleepUtils.getScalar(BasicStrings.charAt(value, start));
        }
    }

    private static class func_indexOf
    implements Function {
        private func_indexOf() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            int rv;
            String value = l.pop().toString();
            String item = l.pop().toString();
            if (n.equals("&lindexOf")) {
                int start = BridgeUtilities.normalize(BridgeUtilities.getInt(l, value.length()), value.length());
                rv = value.lastIndexOf(item, start);
            } else {
                int start = BridgeUtilities.normalize(BridgeUtilities.getInt(l, 0), value.length());
                rv = value.indexOf(item, start);
            }
            if (rv == -1) {
                return SleepUtils.getEmptyScalar();
            }
            return SleepUtils.getScalar(rv);
        }
    }

    private static class func_substr
    implements Function {
        private func_substr() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            String value = BridgeUtilities.getString(l, "");
            int start = BridgeUtilities.getInt(l);
            int stop = n.equals("&mid") ? BridgeUtilities.getInt(l, value.length() - start) + start : BridgeUtilities.getInt(l, value.length());
            return SleepUtils.getScalar(BasicStrings.substring(n, value, start, stop));
        }
    }

    private static class func_replaceAt
    implements Function {
        private func_replaceAt() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            StringBuffer work = new StringBuffer(BridgeUtilities.getString(l, ""));
            String nstr = BridgeUtilities.getString(l, "");
            int index = BridgeUtilities.normalize(BridgeUtilities.getInt(l, 0), work.length());
            int nchar = BridgeUtilities.getInt(l, nstr.length());
            work.delete(index, index + nchar);
            work.insert(index, nstr);
            return SleepUtils.getScalar(work.toString());
        }
    }

    private static class func_strrep
    implements Function {
        private func_strrep() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            StringBuffer work = new StringBuffer(BridgeUtilities.getString(l, ""));
            while (!l.isEmpty()) {
                String oldstr = BridgeUtilities.getString(l, "");
                String newstr = BridgeUtilities.getString(l, "");
                if (oldstr.length() == 0) continue;
                int x = 0;
                int oldlen = oldstr.length();
                int newlen = newstr.length();
                while ((x = work.indexOf(oldstr, x)) > -1) {
                    work.replace(x, x + oldlen, newstr);
                    x += newstr.length();
                }
            }
            return SleepUtils.getScalar(work.toString());
        }
    }

    private static class func_strlen
    implements Function {
        private func_strlen() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            return SleepUtils.getScalar(l.pop().toString().length());
        }
    }

    private static class func_lc
    implements Function {
        private func_lc() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            return SleepUtils.getScalar(l.pop().toString().toLowerCase());
        }
    }

    private static class func_uc
    implements Function {
        private func_uc() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            return SleepUtils.getScalar(l.pop().toString().toUpperCase());
        }
    }

    private static class func_chr
    implements Function {
        private func_chr() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            return SleepUtils.getScalar((char)BridgeUtilities.getInt(l) + "");
        }
    }

    private static class func_asc
    implements Function {
        private func_asc() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            return SleepUtils.getScalar(BridgeUtilities.getString(l, "\u0000").charAt(0));
        }
    }

    private static class func_right
    implements Function {
        private func_right() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            String temp = l.pop().toString();
            int value = ((Scalar)l.pop()).intValue();
            return SleepUtils.getScalar(BasicStrings.substring(n, temp, 0 - value, temp.length()));
        }
    }

    private static class func_tr
    implements Function {
        private func_tr() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            String old = BridgeUtilities.getString(l, "");
            String pattern = BridgeUtilities.getString(l, "");
            String mapper = BridgeUtilities.getString(l, "");
            String optstr = BridgeUtilities.getString(l, "");
            int options = 0;
            if (optstr.indexOf(99) > -1) {
                options |= 2;
            }
            if (optstr.indexOf(100) > -1) {
                options |= 1;
            }
            if (optstr.indexOf(115) > -1) {
                options |= 4;
            }
            Transliteration temp = Transliteration.compile(pattern, mapper, options);
            return SleepUtils.getScalar(temp.translate(old));
        }
    }

    private static class func_left
    implements Function {
        private func_left() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            String temp = l.pop().toString();
            int value = ((Scalar)l.pop()).intValue();
            return SleepUtils.getScalar(BasicStrings.substring(n, temp, 0, value));
        }
    }

    private static class pred_iswm
    implements Predicate {
        private pred_iswm() {
        }

        public boolean decide(String name, ScriptInstance script, Stack locals) {
            String b = locals.pop().toString();
            String a = locals.pop().toString();
            try {
                if ((a.length() == 0 || b.length() == 0) && a.length() != b.length()) {
                    return false;
                }
                int aptr = 0;
                int bptr = 0;
                while (aptr < a.length()) {
                    if (a.charAt(aptr) == '*') {
                        int cptr;
                        boolean greedy;
                        boolean bl = greedy = aptr + 1 < a.length() && a.charAt(aptr + 1) == '*';
                        while (a.charAt(aptr) == '*') {
                            if (++aptr != a.length()) continue;
                            return true;
                        }
                        for (cptr = aptr; cptr < a.length() && a.charAt(cptr) != '?' && a.charAt(cptr) != '\\' && a.charAt(cptr) != '*'; ++cptr) {
                        }
                        if (cptr != aptr) {
                            cptr = greedy ? b.lastIndexOf(a.substring(aptr, cptr)) : b.indexOf(a.substring(aptr, cptr), bptr);
                            if (cptr == -1 || cptr < bptr) {
                                return false;
                            }
                            bptr = cptr;
                        }
                        if (a.charAt(aptr) == '?') {
                            --aptr;
                        }
                    } else {
                        if (bptr >= b.length()) {
                            return false;
                        }
                        if (a.charAt(aptr) == '\\' ? ++aptr < a.length() && a.charAt(aptr) != b.charAt(bptr) : a.charAt(aptr) != '?' && a.charAt(aptr) != b.charAt(bptr)) {
                            return false;
                        }
                    }
                    ++aptr;
                    ++bptr;
                }
                return bptr == b.length();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
    }

    private static class pred_lt
    implements Predicate {
        private pred_lt() {
        }

        public boolean decide(String n, ScriptInstance i, Stack l) {
            String b = BridgeUtilities.getString(l, "");
            String a = BridgeUtilities.getString(l, "");
            return a.compareTo(b) < 0;
        }
    }

    private static class pred_gt
    implements Predicate {
        private pred_gt() {
        }

        public boolean decide(String n, ScriptInstance i, Stack l) {
            String b = BridgeUtilities.getString(l, "");
            String a = BridgeUtilities.getString(l, "");
            return a.compareTo(b) > 0;
        }
    }

    private static class pred_ne
    implements Predicate {
        private pred_ne() {
        }

        public boolean decide(String n, ScriptInstance i, Stack l) {
            String b = BridgeUtilities.getString(l, "");
            String a = BridgeUtilities.getString(l, "");
            return !a.equals(b);
        }
    }

    private static class pred_isnumber
    implements Predicate {
        private pred_isnumber() {
        }

        public boolean decide(String n, ScriptInstance i, Stack l) {
            String check = l.pop().toString();
            if (check.length() <= 0) {
                return false;
            }
            if (check.indexOf(46) > -1 && check.indexOf(46) != check.lastIndexOf(46)) {
                return false;
            }
            for (int x = 0; x < check.length(); ++x) {
                if (Character.isDigit(check.charAt(x)) || check.charAt(x) == '.' && x + 1 < check.length()) continue;
                return false;
            }
            return true;
        }
    }

    private static class pred_isletter
    implements Predicate {
        private pred_isletter() {
        }

        public boolean decide(String n, ScriptInstance i, Stack l) {
            String check = l.pop().toString();
            if (check.length() <= 0) {
                return false;
            }
            for (int x = 0; x < check.length(); ++x) {
                if (Character.isLetter(check.charAt(x))) continue;
                return false;
            }
            return true;
        }
    }

    private static class pred_isin
    implements Predicate {
        private pred_isin() {
        }

        public boolean decide(String n, ScriptInstance i, Stack l) {
            String a;
            String b = BridgeUtilities.getString(l, "");
            return b.indexOf(a = BridgeUtilities.getString(l, "")) > -1;
        }
    }

    private static class pred_eq
    implements Predicate {
        private pred_eq() {
        }

        public boolean decide(String n, ScriptInstance i, Stack l) {
            String b = BridgeUtilities.getString(l, "");
            String a = BridgeUtilities.getString(l, "");
            return a.equals(b);
        }
    }
}

