/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges;

import java.math.BigInteger;
import java.util.Hashtable;
import java.util.Random;
import java.util.Stack;
import sleep.bridges.BridgeUtilities;
import sleep.engine.types.DoubleValue;
import sleep.engine.types.IntValue;
import sleep.engine.types.LongValue;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Operator;
import sleep.interfaces.Predicate;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarType;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;
import sleep.taint.TaintUtils;

public class BasicNumbers
implements Predicate,
Operator,
Loadable,
Function {
    public void scriptUnloaded(ScriptInstance aScript) {
    }

    public void scriptLoaded(ScriptInstance aScript) {
        Hashtable temp = aScript.getScriptEnvironment().getEnvironment();
        Object sanitized = TaintUtils.Sanitizer(this);
        String[] funcs = new String[]{"&abs", "&acos", "&asin", "&atan", "&atan2", "&ceil", "&cos", "&log", "&round", "&sin", "&sqrt", "&tan", "&radians", "&degrees", "&exp", "&floor"};
        for (int x = 0; x < funcs.length; ++x) {
            temp.put(funcs[x], sanitized);
        }
        temp.put("&double", sanitized);
        temp.put("&int", sanitized);
        temp.put("&uint", sanitized);
        temp.put("&long", sanitized);
        temp.put("&parseNumber", sanitized);
        temp.put("&formatNumber", sanitized);
        temp.put("+", sanitized);
        temp.put("-", sanitized);
        temp.put("/", sanitized);
        temp.put("*", sanitized);
        temp.put("**", sanitized);
        temp.put("% ", sanitized);
        temp.put("<<", sanitized);
        temp.put(">>", sanitized);
        temp.put("&", sanitized);
        temp.put("|", sanitized);
        temp.put("^", sanitized);
        temp.put("&not", sanitized);
        temp.put("==", this);
        temp.put("!=", this);
        temp.put("<=", this);
        temp.put(">=", this);
        temp.put("<", this);
        temp.put(">", this);
        temp.put("is", this);
        temp.put("&rand", sanitized);
        temp.put("&srand", sanitized);
    }

    public Scalar evaluate(String name, ScriptInstance si, Stack args) {
        if (name.equals("&abs")) {
            return SleepUtils.getScalar(Math.abs(BridgeUtilities.getDouble(args, 0.0)));
        }
        if (name.equals("&acos")) {
            return SleepUtils.getScalar(Math.acos(BridgeUtilities.getDouble(args, 0.0)));
        }
        if (name.equals("&asin")) {
            return SleepUtils.getScalar(Math.asin(BridgeUtilities.getDouble(args, 0.0)));
        }
        if (name.equals("&atan")) {
            return SleepUtils.getScalar(Math.atan(BridgeUtilities.getDouble(args, 0.0)));
        }
        if (name.equals("&atan2")) {
            return SleepUtils.getScalar(Math.atan2(BridgeUtilities.getDouble(args, 0.0), BridgeUtilities.getDouble(args, 0.0)));
        }
        if (name.equals("&ceil")) {
            return SleepUtils.getScalar(Math.ceil(BridgeUtilities.getDouble(args, 0.0)));
        }
        if (name.equals("&floor")) {
            return SleepUtils.getScalar(Math.floor(BridgeUtilities.getDouble(args, 0.0)));
        }
        if (name.equals("&cos")) {
            return SleepUtils.getScalar(Math.cos(BridgeUtilities.getDouble(args, 0.0)));
        }
        if (name.equals("&log") && args.size() == 1) {
            return SleepUtils.getScalar(Math.log(BridgeUtilities.getDouble(args, 0.0)));
        }
        if (name.equals("&log") && args.size() == 2) {
            return SleepUtils.getScalar(Math.log(BridgeUtilities.getDouble(args, 0.0)) / Math.log(BridgeUtilities.getDouble(args, 0.0)));
        }
        if (name.equals("&round")) {
            if (args.size() == 1) {
                return SleepUtils.getScalar(Math.round(BridgeUtilities.getDouble(args, 0.0)));
            }
            double number = BridgeUtilities.getDouble(args, 0.0);
            double places = Math.pow(10.0, BridgeUtilities.getInt(args, 0));
            number = Math.round(number * places);
            return SleepUtils.getScalar(number /= places);
        }
        if (name.equals("&sin")) {
            return SleepUtils.getScalar(Math.sin(BridgeUtilities.getDouble(args, 0.0)));
        }
        if (name.equals("&sqrt")) {
            return SleepUtils.getScalar(Math.sqrt(BridgeUtilities.getDouble(args, 0.0)));
        }
        if (name.equals("&tan")) {
            return SleepUtils.getScalar(Math.tan(BridgeUtilities.getDouble(args, 0.0)));
        }
        if (name.equals("&radians")) {
            return SleepUtils.getScalar(Math.toRadians(BridgeUtilities.getDouble(args, 0.0)));
        }
        if (name.equals("&degrees")) {
            return SleepUtils.getScalar(Math.toDegrees(BridgeUtilities.getDouble(args, 0.0)));
        }
        if (name.equals("&exp")) {
            return SleepUtils.getScalar(Math.exp(BridgeUtilities.getDouble(args, 0.0)));
        }
        if (name.equals("&not")) {
            ScalarType sa = ((Scalar)args.pop()).getActualValue();
            if (sa.getType() == IntValue.class) {
                return SleepUtils.getScalar(~sa.intValue());
            }
            return SleepUtils.getScalar(sa.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if (name.equals("&long")) {
            Scalar temp = BridgeUtilities.getScalar(args);
            return SleepUtils.getScalar(temp.longValue());
        }
        if (name.equals("&double")) {
            Scalar temp = BridgeUtilities.getScalar(args);
            return SleepUtils.getScalar(temp.doubleValue());
        }
        if (name.equals("&int")) {
            Scalar temp = BridgeUtilities.getScalar(args);
            return SleepUtils.getScalar(temp.intValue());
        }
        if (name.equals("&uint")) {
            int temp = BridgeUtilities.getInt(args, 0);
            long templ = 0xFFFFFFFFL & (long)temp;
            return SleepUtils.getScalar(templ);
        }
        if (name.equals("&parseNumber")) {
            String number = BridgeUtilities.getString(args, "0");
            int radix = BridgeUtilities.getInt(args, 10);
            BigInteger temp = new BigInteger(number, radix);
            return SleepUtils.getScalar(temp.longValue());
        }
        if (name.equals("&formatNumber")) {
            String number = BridgeUtilities.getString(args, "0");
            int from = 10;
            int to = 10;
            if (args.size() == 2) {
                from = BridgeUtilities.getInt(args, 10);
            }
            to = BridgeUtilities.getInt(args, 10);
            BigInteger temp = new BigInteger(number, from);
            return SleepUtils.getScalar(temp.toString(to));
        }
        if (name.equals("&srand")) {
            long seed = BridgeUtilities.getLong(args);
            si.getMetadata().put("__RANDOM__", new Random(seed));
        } else if (name.equals("&rand")) {
            if (si.getMetadata().get("__RANDOM__") == null) {
                si.getMetadata().put("__RANDOM__", new Random());
            }
            Random r = (Random)si.getMetadata().get("__RANDOM__");
            if (!args.isEmpty()) {
                Scalar temp = (Scalar)args.pop();
                if (temp.getArray() != null) {
                    int potential = r.nextInt(temp.getArray().size());
                    return temp.getArray().getAt(potential);
                }
                return SleepUtils.getScalar(r.nextInt(temp.intValue()));
            }
            return SleepUtils.getScalar(r.nextDouble());
        }
        return SleepUtils.getEmptyScalar();
    }

    public boolean decide(String n, ScriptInstance i, Stack l) {
        Stack env = i.getScriptEnvironment().getEnvironmentStack();
        Scalar vb = (Scalar)l.pop();
        Scalar va = (Scalar)l.pop();
        if (n.equals("is")) {
            return va.objectValue() == vb.objectValue();
        }
        ScalarType sb = vb.getActualValue();
        ScalarType sa = va.getActualValue();
        if (sa.getType() == DoubleValue.class || sb.getType() == DoubleValue.class) {
            double a = sa.doubleValue();
            double b = sb.doubleValue();
            if (n.equals("==")) {
                return a == b;
            }
            if (n.equals("!=")) {
                return a != b;
            }
            if (n.equals("<=")) {
                return a <= b;
            }
            if (n.equals(">=")) {
                return a >= b;
            }
            if (n.equals("<")) {
                return a < b;
            }
            if (n.equals(">")) {
                return a > b;
            }
        } else if (sa.getType() == LongValue.class || sb.getType() == LongValue.class) {
            long a = sa.longValue();
            long b = sb.longValue();
            if (n.equals("==")) {
                return a == b;
            }
            if (n.equals("!=")) {
                return a != b;
            }
            if (n.equals("<=")) {
                return a <= b;
            }
            if (n.equals(">=")) {
                return a >= b;
            }
            if (n.equals("<")) {
                return a < b;
            }
            if (n.equals(">")) {
                return a > b;
            }
        } else {
            int a = sa.intValue();
            int b = sb.intValue();
            if (n.equals("==")) {
                return a == b;
            }
            if (n.equals("!=")) {
                return a != b;
            }
            if (n.equals("<=")) {
                return a <= b;
            }
            if (n.equals(">=")) {
                return a >= b;
            }
            if (n.equals("<")) {
                return a < b;
            }
            if (n.equals(">")) {
                return a > b;
            }
        }
        return false;
    }

    public Scalar operate(String o, ScriptInstance i, Stack locals) {
        ScalarType left = ((Scalar)locals.pop()).getActualValue();
        ScalarType right = ((Scalar)locals.pop()).getActualValue();
        if (!(right.getType() != DoubleValue.class && left.getType() != DoubleValue.class || o.equals(">>") || o.equals("<<") || o.equals("&") || o.equals("|") || o.equals("^"))) {
            double a = left.doubleValue();
            double b = right.doubleValue();
            if (o.equals("+")) {
                return SleepUtils.getScalar(a + b);
            }
            if (o.equals("-")) {
                return SleepUtils.getScalar(a - b);
            }
            if (o.equals("*")) {
                return SleepUtils.getScalar(a * b);
            }
            if (o.equals("/")) {
                return SleepUtils.getScalar(a / b);
            }
            if (o.equals("% ")) {
                return SleepUtils.getScalar(a % b);
            }
            if (o.equals("**")) {
                return SleepUtils.getScalar(Math.pow(a, b));
            }
        } else if (right.getType() == LongValue.class || left.getType() == LongValue.class) {
            long a = left.longValue();
            long b = right.longValue();
            if (o.equals("+")) {
                return SleepUtils.getScalar(a + b);
            }
            if (o.equals("-")) {
                return SleepUtils.getScalar(a - b);
            }
            if (o.equals("*")) {
                return SleepUtils.getScalar(a * b);
            }
            if (o.equals("/")) {
                return SleepUtils.getScalar(a / b);
            }
            if (o.equals("% ")) {
                return SleepUtils.getScalar(a % b);
            }
            if (o.equals("**")) {
                return SleepUtils.getScalar(Math.pow(a, b));
            }
            if (o.equals(">>")) {
                return SleepUtils.getScalar(a >> (int)b);
            }
            if (o.equals("<<")) {
                return SleepUtils.getScalar(a << (int)b);
            }
            if (o.equals("&")) {
                return SleepUtils.getScalar(a & b);
            }
            if (o.equals("|")) {
                return SleepUtils.getScalar(a | b);
            }
            if (o.equals("^")) {
                return SleepUtils.getScalar(a ^ b);
            }
        } else {
            int a = left.intValue();
            int b = right.intValue();
            if (o.equals("+")) {
                return SleepUtils.getScalar(a + b);
            }
            if (o.equals("-")) {
                return SleepUtils.getScalar(a - b);
            }
            if (o.equals("*")) {
                return SleepUtils.getScalar(a * b);
            }
            if (o.equals("/")) {
                return SleepUtils.getScalar(a / b);
            }
            if (o.equals("% ")) {
                return SleepUtils.getScalar(a % b);
            }
            if (o.equals("**")) {
                return SleepUtils.getScalar(Math.pow(a, b));
            }
            if (o.equals(">>")) {
                return SleepUtils.getScalar(a >> b);
            }
            if (o.equals("<<")) {
                return SleepUtils.getScalar(a << b);
            }
            if (o.equals("&")) {
                return SleepUtils.getScalar(a & b);
            }
            if (o.equals("|")) {
                return SleepUtils.getScalar(a | b);
            }
            if (o.equals("^")) {
                return SleepUtils.getScalar(a ^ b);
            }
        }
        return SleepUtils.getEmptyScalar();
    }
}

