/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.ByteBuffer;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import sleep.bridges.BridgeUtilities;
import sleep.bridges.KeyValuePair;
import sleep.bridges.SleepClosure;
import sleep.bridges.io.BufferObject;
import sleep.bridges.io.DataPattern;
import sleep.bridges.io.FileObject;
import sleep.bridges.io.IOObject;
import sleep.bridges.io.ProcessObject;
import sleep.bridges.io.SocketObject;
import sleep.engine.types.ObjectValue;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Predicate;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarHash;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.ScriptInstance;
import sleep.runtime.ScriptVariables;
import sleep.runtime.SleepUtils;
import sleep.taint.TaintUtils;

public class BasicIO
implements Loadable,
Function {
    public void scriptUnloaded(ScriptInstance aScript) {
    }

    public void scriptLoaded(ScriptInstance aScript) {
        Hashtable temp = aScript.getScriptEnvironment().getEnvironment();
        temp.put("__EXEC__", TaintUtils.Tainter(TaintUtils.Sensitive(this)));
        temp.put("-eof", new iseof());
        temp.put("&openf", TaintUtils.Sensitive(new openf()));
        SocketFuncs f = new SocketFuncs();
        temp.put("&connect", TaintUtils.Sensitive(f));
        temp.put("&listen", f);
        temp.put("&exec", TaintUtils.Sensitive(new exec()));
        temp.put("&fork", new fork());
        temp.put("&allocate", this);
        temp.put("&sleep", new sleep());
        temp.put("&closef", new closef());
        temp.put("&read", new read());
        temp.put("&readln", TaintUtils.Tainter(new readln()));
        temp.put("&readAll", TaintUtils.Tainter(new readAll()));
        temp.put("&readc", TaintUtils.Tainter(this));
        temp.put("&readb", TaintUtils.Tainter(new readb()));
        temp.put("&consume", new consume());
        temp.put("&writeb", new writeb());
        temp.put("&bread", TaintUtils.Tainter(new bread()));
        temp.put("&bwrite", new bwrite());
        temp.put("&readObject", TaintUtils.Tainter(this));
        temp.put("&writeObject", this);
        temp.put("&readAsObject", TaintUtils.Tainter(this));
        temp.put("&writeAsObject", this);
        temp.put("&sizeof", this);
        temp.put("&pack", new pack());
        temp.put("&unpack", new unpack());
        temp.put("&available", new available());
        temp.put("&mark", new mark());
        temp.put("&skip", temp.get("&consume"));
        temp.put("&reset", new reset());
        temp.put("&wait", this);
        temp.put("&print", new print());
        temp.put("&setEncoding", this);
        println f_println = new println();
        temp.put("&println", f_println);
        temp.put("&printf", f_println);
        temp.put("&printAll", new printArray());
        temp.put("&printEOF", new printEOF());
        temp.put("&getConsole", new getConsoleObject());
        temp.put("&checksum", this);
        temp.put("&digest", this);
    }

    private static Checksum getChecksum(String algorithm) {
        if (algorithm.equals("Adler32")) {
            return new Adler32();
        }
        if (algorithm.equals("CRC32")) {
            return new CRC32();
        }
        return null;
    }

    public Scalar evaluate(String n, ScriptInstance i, Stack l) {
        if (n.equals("&wait")) {
            IOObject a = (IOObject)BridgeUtilities.getObject(l);
            long to = BridgeUtilities.getLong(l, 0L);
            return a.wait(i.getScriptEnvironment(), to);
        }
        if (n.equals("__EXEC__")) {
            Scalar rv = SleepUtils.getArrayScalar();
            try {
                Process proc = Runtime.getRuntime().exec(BridgeUtilities.getString(l, ""), null, i.cwd());
                IOObject reader = SleepUtils.getIOHandle(proc.getInputStream(), null);
                String text = null;
                while ((text = reader.readLine()) != null) {
                    rv.getArray().push(SleepUtils.getScalar(text));
                }
                if (proc.waitFor() != 0) {
                    i.getScriptEnvironment().flagError("abnormal termination: " + proc.exitValue());
                }
            }
            catch (Exception ex) {
                i.getScriptEnvironment().flagError(ex);
            }
            return rv;
        }
        if (n.equals("&writeObject") || n.equals("&writeAsObject")) {
            IOObject a = BasicIO.chooseSource(l, 2, i);
            while (!l.isEmpty()) {
                Scalar b = (Scalar)l.pop();
                try {
                    ObjectOutputStream ois = new ObjectOutputStream(a.getWriter());
                    if (n.equals("&writeAsObject")) {
                        ois.writeObject(b.objectValue());
                        continue;
                    }
                    ois.writeObject(b);
                }
                catch (Exception ex) {
                    i.getScriptEnvironment().flagError(ex);
                    a.close();
                }
            }
        } else if (n.equals("&readObject") || n.equals("&readAsObject")) {
            IOObject a = BasicIO.chooseSource(l, 1, i);
            try {
                ObjectInputStream ois = new ObjectInputStream(a.getReader());
                if (n.equals("&readAsObject")) {
                    return SleepUtils.getScalar(ois.readObject());
                }
                Scalar value = (Scalar)ois.readObject();
                return value;
            }
            catch (EOFException eofex) {
                a.close();
            }
            catch (Exception ex) {
                i.getScriptEnvironment().flagError(ex);
                a.close();
            }
        } else {
            if (n.equals("&allocate")) {
                int capacity = BridgeUtilities.getInt(l, 32768);
                BufferObject temp = new BufferObject();
                temp.allocate(capacity);
                return SleepUtils.getScalar(temp);
            }
            if (n.equals("&digest")) {
                Scalar s = BridgeUtilities.getScalar(l);
                if (s.objectValue() != null && s.objectValue() instanceof IOObject) {
                    boolean isRead = true;
                    String temp = BridgeUtilities.getString(l, "MD5");
                    if (temp.charAt(0) == '>') {
                        isRead = false;
                        temp = temp.substring(1);
                    }
                    IOObject io = (IOObject)s.objectValue();
                    try {
                        if (isRead) {
                            DigestInputStream cis = new DigestInputStream(io.getInputStream(), MessageDigest.getInstance(temp));
                            io.openRead(cis);
                            return SleepUtils.getScalar(cis.getMessageDigest());
                        }
                        DigestOutputStream cos = new DigestOutputStream(io.getOutputStream(), MessageDigest.getInstance(temp));
                        io.openWrite(cos);
                        return SleepUtils.getScalar(cos.getMessageDigest());
                    }
                    catch (NoSuchAlgorithmException ex) {
                        i.getScriptEnvironment().flagError(ex);
                    }
                } else {
                    if (s.objectValue() != null && s.objectValue() instanceof MessageDigest) {
                        MessageDigest sum = (MessageDigest)s.objectValue();
                        return SleepUtils.getScalar(sum.digest());
                    }
                    String temp = s.toString();
                    String algo = BridgeUtilities.getString(l, "MD5");
                    try {
                        MessageDigest doit = MessageDigest.getInstance(algo);
                        doit.update(BridgeUtilities.toByteArrayNoConversion(temp), 0, temp.length());
                        return SleepUtils.getScalar(doit.digest());
                    }
                    catch (NoSuchAlgorithmException ex) {
                        i.getScriptEnvironment().flagError(ex);
                    }
                }
                return SleepUtils.getEmptyScalar();
            }
            if (n.equals("&sizeof")) {
                return SleepUtils.getScalar(DataPattern.EstimateSize(BridgeUtilities.getString(l, "")));
            }
            if (n.equals("&setEncoding")) {
                IOObject a = BasicIO.chooseSource(l, 1, i);
                String name = BridgeUtilities.getString(l, "");
                try {
                    a.setEncoding(name);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("&setEncoding: specified a non-existent encoding '" + name + "'");
                }
            } else {
                if (n.equals("&readc")) {
                    IOObject a = BasicIO.chooseSource(l, 1, i);
                    return SleepUtils.getScalar(a.readCharacter());
                }
                if (n.equals("&checksum")) {
                    Scalar s = BridgeUtilities.getScalar(l);
                    if (s.objectValue() != null && s.objectValue() instanceof IOObject) {
                        boolean isRead = true;
                        String temp = BridgeUtilities.getString(l, "CRC32");
                        if (temp.charAt(0) == '>') {
                            isRead = false;
                            temp = temp.substring(1);
                        }
                        IOObject io = (IOObject)s.objectValue();
                        if (isRead) {
                            CheckedInputStream cis = new CheckedInputStream(io.getInputStream(), BasicIO.getChecksum(temp));
                            io.openRead(cis);
                            return SleepUtils.getScalar(cis.getChecksum());
                        }
                        CheckedOutputStream cos = new CheckedOutputStream(io.getOutputStream(), BasicIO.getChecksum(temp));
                        io.openWrite(cos);
                        return SleepUtils.getScalar(cos.getChecksum());
                    }
                    if (s.objectValue() != null && s.objectValue() instanceof Checksum) {
                        Checksum sum = (Checksum)s.objectValue();
                        return SleepUtils.getScalar(sum.getValue());
                    }
                    String temp = s.toString();
                    String algo = BridgeUtilities.getString(l, "CRC32");
                    Checksum doit = BasicIO.getChecksum(algo);
                    doit.update(BridgeUtilities.toByteArrayNoConversion(temp), 0, temp.length());
                    return SleepUtils.getScalar(doit.getValue());
                }
            }
        }
        return SleepUtils.getEmptyScalar();
    }

    private static IOObject chooseSource(Stack l, int args, ScriptInstance i) {
        if (l.size() < args && !l.isEmpty()) {
            Scalar temp = (Scalar)l.peek();
            if (temp.getActualValue() != null && temp.getActualValue().getType() == ObjectValue.class && temp.objectValue() instanceof IOObject) {
                l.pop();
                return (IOObject)temp.objectValue();
            }
        } else if (l.size() >= args) {
            Scalar b = (Scalar)l.pop();
            if (!(b.objectValue() instanceof IOObject)) {
                throw new IllegalArgumentException("expected I/O handle argument, received: " + SleepUtils.describe(b));
            }
            return (IOObject)b.objectValue();
        }
        return IOObject.getConsole(i.getScriptEnvironment());
    }

    private static Scalar ReadFormatted(String format, InputStream in, ScriptEnvironment env, IOObject control) {
        Scalar temp = SleepUtils.getArrayScalar();
        DataPattern pattern = DataPattern.Parse(format);
        byte[] bdata = new byte[8];
        ByteBuffer buffer = ByteBuffer.wrap(bdata);
        int read2 = 0;
        while (pattern != null) {
            buffer.order(pattern.order);
            if (pattern.value == 'M') {
                if (pattern.count == 1) {
                    pattern.count = 10240;
                }
                in.mark(pattern.count);
            } else if (pattern.value == 'x') {
                try {
                    in.skip(pattern.count);
                }
                catch (Exception ex) {}
            } else if (pattern.value == 'h' || pattern.value == 'H') {
                StringBuffer temps = new StringBuffer();
                try {
                    for (int z = 0; z < pattern.count || pattern.count == -1; ++z) {
                        read2 = in.read(bdata, 0, 1);
                        if (read2 < 1) {
                            throw new EOFException();
                        }
                        int early = (buffer.get(0) & 0xF0) >> 4;
                        int later = buffer.get(0) & 0xF;
                        if (pattern.value == 'h') {
                            temps.append(Integer.toHexString(later));
                            temps.append(Integer.toHexString(early));
                            continue;
                        }
                        temps.append(Integer.toHexString(early));
                        temps.append(Integer.toHexString(later));
                    }
                }
                catch (Exception fex) {
                    if (control != null) {
                        control.close();
                    }
                    temp.getArray().push(SleepUtils.getScalar(temps.toString()));
                    return temp;
                }
                temp.getArray().push(SleepUtils.getScalar(temps.toString()));
            } else if (pattern.value == 'z' || pattern.value == 'Z' || pattern.value == 'U' || pattern.value == 'u') {
                StringBuffer temps = new StringBuffer();
                try {
                    int z;
                    int tempval;
                    if (pattern.value == 'u' || pattern.value == 'U') {
                        read2 = in.read(bdata, 0, 2);
                        if (read2 < 2) {
                            throw new EOFException();
                        }
                        tempval = buffer.getChar(0);
                    } else {
                        tempval = in.read();
                        if (tempval == -1) {
                            throw new EOFException();
                        }
                    }
                    for (z = 1; tempval != 0 && z != pattern.count; ++z) {
                        temps.append((char)tempval);
                        if (pattern.value == 'u' || pattern.value == 'U') {
                            read2 = in.read(bdata, 0, 2);
                            if (read2 < 2) {
                                throw new EOFException();
                            }
                            tempval = buffer.getChar(0);
                            continue;
                        }
                        tempval = in.read();
                        if (tempval != -1) continue;
                        throw new EOFException();
                    }
                    if (tempval != 0) {
                        temps.append((char)tempval);
                    }
                    if ((pattern.value == 'Z' || pattern.value == 'U') && z < pattern.count) {
                        int skipby = (pattern.count - z) * (pattern.value == 'U' ? 2 : 1);
                        in.skip(skipby);
                    }
                }
                catch (Exception fex) {
                    if (control != null) {
                        control.close();
                    }
                    temp.getArray().push(SleepUtils.getScalar(temps.toString()));
                    return temp;
                }
                temp.getArray().push(SleepUtils.getScalar(temps.toString()));
            } else {
                for (int z = 0; z != pattern.count; ++z) {
                    Scalar value = null;
                    try {
                        switch (pattern.value) {
                            case 'R': {
                                in.reset();
                                break;
                            }
                            case 'C': {
                                read2 = in.read(bdata, 0, 1);
                                if (read2 < 1) {
                                    throw new EOFException();
                                }
                                value = SleepUtils.getScalar((char)bdata[0] + "");
                                break;
                            }
                            case 'c': {
                                read2 = in.read(bdata, 0, 2);
                                if (read2 < 2) {
                                    throw new EOFException();
                                }
                                value = SleepUtils.getScalar(buffer.getChar(0) + "");
                                break;
                            }
                            case 'b': {
                                bdata[0] = (byte)in.read();
                                if (bdata[0] == -1) {
                                    throw new EOFException();
                                }
                                value = SleepUtils.getScalar((int)bdata[0]);
                                break;
                            }
                            case 'B': {
                                read2 = in.read();
                                if (read2 == -1) {
                                    throw new EOFException();
                                }
                                value = SleepUtils.getScalar(read2);
                                break;
                            }
                            case 's': {
                                read2 = in.read(bdata, 0, 2);
                                if (read2 < 2) {
                                    throw new EOFException();
                                }
                                value = SleepUtils.getScalar(buffer.getShort(0));
                                break;
                            }
                            case 'S': {
                                read2 = in.read(bdata, 0, 2);
                                if (read2 < 2) {
                                    throw new EOFException();
                                }
                                value = SleepUtils.getScalar(buffer.getShort(0) & 0xFFFF);
                                break;
                            }
                            case 'i': {
                                read2 = in.read(bdata, 0, 4);
                                if (read2 < 4) {
                                    throw new EOFException();
                                }
                                value = SleepUtils.getScalar(buffer.getInt(0));
                                break;
                            }
                            case 'I': {
                                read2 = in.read(bdata, 0, 4);
                                if (read2 < 4) {
                                    throw new EOFException();
                                }
                                value = SleepUtils.getScalar((long)buffer.getInt(0) & 0xFFFFFFFFL);
                                break;
                            }
                            case 'f': {
                                read2 = in.read(bdata, 0, 4);
                                if (read2 < 4) {
                                    throw new EOFException();
                                }
                                value = SleepUtils.getScalar(buffer.getFloat(0));
                                break;
                            }
                            case 'd': {
                                read2 = in.read(bdata, 0, 8);
                                if (read2 < 8) {
                                    throw new EOFException();
                                }
                                value = SleepUtils.getScalar(buffer.getDouble(0));
                                break;
                            }
                            case 'l': {
                                read2 = in.read(bdata, 0, 8);
                                if (read2 < 8) {
                                    throw new EOFException();
                                }
                                value = SleepUtils.getScalar(buffer.getLong(0));
                                break;
                            }
                            case 'o': {
                                ObjectInputStream ois = new ObjectInputStream(in);
                                value = (Scalar)ois.readObject();
                                break;
                            }
                            default: {
                                env.showDebugMessage("unknown file pattern character: " + pattern.value);
                                break;
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (control != null) {
                            control.close();
                        }
                        if (value != null) {
                            temp.getArray().push(value);
                        }
                        return temp;
                    }
                    if (value == null) continue;
                    temp.getArray().push(value);
                }
            }
            pattern = pattern.next;
        }
        return temp;
    }

    /*
     * Unable to fully structure code
     */
    private static void WriteFormatted(String format, OutputStream out, ScriptEnvironment env, Stack arguments, IOObject control) {
        pattern = DataPattern.Parse(format);
        if (arguments.size() == 1 && ((Scalar)arguments.peek()).getArray() != null) {
            temp = new Stack<E>();
            i = ((Scalar)arguments.peek()).getArray().scalarIterator();
            while (i.hasNext()) {
                temp.push(i.next());
            }
            BasicIO.WriteFormatted(format, out, env, temp, control);
            return;
        }
        bdata = new byte[8];
        buffer = ByteBuffer.wrap(bdata);
        while (pattern != null) {
            buffer.order(pattern.order);
            if (pattern.value == 'z' || pattern.value == 'Z' || pattern.value == 'u' || pattern.value == 'U') {
                try {
                    tempchars = BridgeUtilities.getString(arguments, "").toCharArray();
                    for (y = 0; y < tempchars.length; ++y) {
                        if (pattern.value == 'u' || pattern.value == 'U') {
                            buffer.putChar(0, tempchars[y]);
                            out.write(bdata, 0, 2);
                            continue;
                        }
                        out.write(tempchars[y]);
                    }
                    block31: for (z = tempchars.length; z < pattern.count; ++z) {
                        switch (pattern.value) {
                            case 'U': {
                                out.write(0);
                                out.write(0);
                                continue block31;
                            }
                            case 'Z': {
                                out.write(0);
                            }
                        }
                    }
                    if (pattern.value == 'z' || pattern.value == 'Z' && pattern.count == -1) {
                        out.write(0);
                    }
                    if (pattern.value != 'u' && (pattern.value != 'U' || pattern.count != -1)) ** GOTO lbl140
                    out.write(0);
                    out.write(0);
                }
                catch (Exception ex) {
                    if (control != null) {
                        control.close();
                    }
                    return;
                }
            } else if (pattern.value == 'h' || pattern.value == 'H') {
                try {
                    number = new StringBuffer("FF");
                    argzz = BridgeUtilities.getString(arguments, "");
                    if (argzz.length() % 2 != 0) {
                        throw new IllegalArgumentException("can not pack '" + argzz + "' as hex string, number of characters must be even");
                    }
                    tempchars = argzz.toCharArray();
                    for (y = 0; y < tempchars.length; y += 2) {
                        if (pattern.value == 'H') {
                            number.setCharAt(0, tempchars[y]);
                            number.setCharAt(1, tempchars[y + 1]);
                        } else {
                            number.setCharAt(0, tempchars[y + 1]);
                            number.setCharAt(1, tempchars[y]);
                        }
                        buffer.putInt(0, Integer.parseInt(number.toString(), 16));
                        out.write(bdata, 3, 1);
                    }
                }
                catch (IllegalArgumentException aex) {
                    if (control != null) {
                        control.close();
                    }
                    throw aex;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (control != null) {
                        control.close();
                    }
                    return;
                }
            } else {
                for (z = 0; z != pattern.count && !arguments.isEmpty(); ++z) {
                    temp = null;
                    if (pattern.value != 'x') {
                        temp = BridgeUtilities.getScalar(arguments);
                    }
                    try {
                        switch (pattern.value) {
                            case 'x': {
                                out.write(0);
                                break;
                            }
                            case 'c': {
                                buffer.putChar(0, temp.toString().charAt(0));
                                out.write(bdata, 0, 2);
                                break;
                            }
                            case 'C': {
                                out.write(temp.toString().charAt(0));
                                break;
                            }
                            case 'B': 
                            case 'b': {
                                out.write(temp.intValue());
                                break;
                            }
                            case 'S': 
                            case 's': {
                                buffer.putShort(0, (short)temp.intValue());
                                out.write(bdata, 0, 2);
                                break;
                            }
                            case 'i': {
                                buffer.putInt(0, temp.intValue());
                                out.write(bdata, 0, 4);
                                break;
                            }
                            case 'I': {
                                buffer.putInt(0, (int)temp.longValue());
                                out.write(bdata, 0, 4);
                                break;
                            }
                            case 'f': {
                                buffer.putFloat(0, (float)temp.doubleValue());
                                out.write(bdata, 0, 4);
                                break;
                            }
                            case 'd': {
                                buffer.putDouble(0, temp.doubleValue());
                                out.write(bdata, 0, 8);
                                break;
                            }
                            case 'l': {
                                buffer.putLong(0, temp.longValue());
                                out.write(bdata, 0, 8);
                                break;
                            }
                            case 'o': {
                                try {
                                    oos = new ObjectOutputStream(out);
                                    oos.writeObject(temp);
                                    break;
                                }
                                catch (Exception ex) {
                                    env.flagError(ex);
                                    if (control != null) {
                                        control.close();
                                    }
                                    return;
                                }
                            }
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        if (control != null) {
                            control.close();
                        }
                        return;
                    }
                }
            }
lbl140:
            // 5 sources

            pattern = pattern.next;
        }
        try {
            out.flush();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private static class CallbackReader
    implements Runnable {
        protected IOObject source;
        protected ScriptInstance script;
        protected SleepClosure function;
        protected int bytes;

        public CallbackReader(IOObject s, ScriptInstance si, SleepClosure func, int byteme) {
            this.source = s;
            this.script = si;
            this.function = func;
            this.bytes = byteme;
        }

        public void run() {
            Stack<Scalar> args = new Stack<Scalar>();
            if (this.bytes <= 0) {
                String temp;
                while (this.script.isLoaded() && (temp = this.source.readLine()) != null) {
                    args.push(SleepUtils.getScalar(temp));
                    args.push(SleepUtils.getScalar(this.source));
                    this.function.callClosure("&read", this.script, args);
                }
            } else {
                StringBuffer tempb = null;
                try {
                    while (this.script.isLoaded() && !this.source.isEOF()) {
                        tempb = new StringBuffer(this.bytes);
                        for (int x = 0; x < this.bytes; ++x) {
                            tempb.append((char)this.source.getReader().readUnsignedByte());
                        }
                        args.push(SleepUtils.getScalar(tempb.toString()));
                        args.push(SleepUtils.getScalar(this.source));
                        this.function.callClosure("&read", this.script, args);
                    }
                }
                catch (Exception ex) {
                    if (tempb.length() > 0) {
                        args.push(SleepUtils.getScalar(tempb.toString()));
                        args.push(SleepUtils.getScalar(this.source));
                        this.function.callClosure("&read", this.script, args);
                    }
                    this.source.close();
                    this.script.getScriptEnvironment().flagError(ex);
                }
            }
        }
    }

    private static class iseof
    implements Predicate {
        private iseof() {
        }

        public boolean decide(String n, ScriptInstance i, Stack l) {
            IOObject a = (IOObject)BridgeUtilities.getObject(l);
            return a.isEOF();
        }
    }

    private static class read
    implements Function {
        private read() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            IOObject a = BasicIO.chooseSource(l, 2, i);
            SleepClosure b = BridgeUtilities.getFunction(l, i);
            Thread fred = new Thread(new CallbackReader(a, i, b, BridgeUtilities.getInt(l, 0)));
            a.setThread(fred);
            fred.start();
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class consume
    implements Function {
        private consume() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            IOObject a = BasicIO.chooseSource(l, 2, i);
            int to = BridgeUtilities.getInt(l, 1);
            int size = BridgeUtilities.getInt(l, 32768);
            int last = 0;
            if (a.getReader() != null) {
                int read2;
                byte[] temp = new byte[size];
                try {
                    for (read2 = 0; read2 < to && (last = to - read2 < size ? a.getReader().read(temp, 0, to - read2) : a.getReader().read(temp, 0, size)) != -1; read2 += last) {
                    }
                }
                catch (Exception ex) {
                    a.close();
                    i.getScriptEnvironment().flagError(ex);
                }
                if (read2 > 0) {
                    return SleepUtils.getScalar(read2);
                }
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class readb
    implements Function {
        private readb() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            IOObject a = BasicIO.chooseSource(l, 2, i);
            int to = BridgeUtilities.getInt(l, 1);
            int last = 0;
            byte[] temp = null;
            StringBuffer buffer = null;
            if (a.getReader() != null) {
                int read2;
                block10: {
                    try {
                        if (to == -1) {
                            buffer = new StringBuffer(BridgeUtilities.getInt(l, 2048));
                            while ((last = a.getReader().read()) != -1) {
                                char append = (char)(last & 0xFF);
                                buffer.append(append);
                                ++read2;
                            }
                        } else {
                            temp = new byte[to];
                            for (read2 = 0; read2 < to && (last = a.getReader().read(temp, read2, to - read2)) != -1; read2 += last) {
                            }
                        }
                    }
                    catch (Exception ex) {
                        a.close();
                        if (to == -1) break block10;
                        i.getScriptEnvironment().flagError(ex);
                    }
                }
                if (read2 > 0) {
                    if (temp != null) {
                        return SleepUtils.getScalar(temp, read2);
                    }
                    if (buffer != null) {
                        return SleepUtils.getScalar(buffer.toString());
                    }
                }
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class writeb
    implements Function {
        private writeb() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            IOObject a = BasicIO.chooseSource(l, 2, i);
            String data = BridgeUtilities.getString(l, "");
            try {
                for (int x = 0; x < data.length(); ++x) {
                    a.getWriter().writeByte((byte)data.charAt(x));
                }
                a.getWriter().flush();
            }
            catch (Exception ex) {
                a.close();
                i.getScriptEnvironment().flagError(ex);
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class pack
    implements Function {
        private pack() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            String pattern = BridgeUtilities.getString(l, "");
            ByteArrayOutputStream temp = new ByteArrayOutputStream(DataPattern.EstimateSize(pattern) + 128);
            BasicIO.WriteFormatted(pattern, new DataOutputStream(temp), i.getScriptEnvironment(), l, null);
            return SleepUtils.getScalar(temp.toByteArray(), temp.size());
        }
    }

    private static class unpack
    implements Function {
        private unpack() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            String pattern = BridgeUtilities.getString(l, "");
            String data = BridgeUtilities.getString(l, "");
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream(data.length());
                DataOutputStream toBytes = new DataOutputStream(out);
                toBytes.writeBytes(data);
                return BasicIO.ReadFormatted(pattern, new DataInputStream(new ByteArrayInputStream(out.toByteArray())), i.getScriptEnvironment(), null);
            }
            catch (Exception ex) {
                return SleepUtils.getArrayScalar();
            }
        }
    }

    private static class reset
    implements Function {
        private reset() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            try {
                IOObject a = BasicIO.chooseSource(l, 1, i);
                a.getInputBuffer().reset();
            }
            catch (Exception ex) {
                // empty catch block
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class available
    implements Function {
        private available() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            try {
                IOObject a = BasicIO.chooseSource(l, 1, i);
                if (l.isEmpty()) {
                    return SleepUtils.getScalar(a.getInputBuffer().available());
                }
                String delim = BridgeUtilities.getString(l, "\n");
                StringBuffer temp = new StringBuffer();
                int y = a.getInputBuffer().available();
                a.getInputBuffer().mark(y);
                for (int x = 0; x < y; ++x) {
                    temp.append((char)a.getReader().readUnsignedByte());
                }
                a.getInputBuffer().reset();
                return SleepUtils.getScalar(temp.indexOf(delim) > -1);
            }
            catch (Exception ex) {
                return SleepUtils.getEmptyScalar();
            }
        }
    }

    private static class mark
    implements Function {
        private mark() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            IOObject a = BasicIO.chooseSource(l, 2, i);
            if (a.getInputBuffer() == null) {
                throw new RuntimeException("&mark: input buffer for " + SleepUtils.describe(SleepUtils.getScalar(a)) + " is closed");
            }
            a.getInputBuffer().mark(BridgeUtilities.getInt(l, 102400));
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class bwrite
    implements Function {
        private bwrite() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            IOObject a = BasicIO.chooseSource(l, 3, i);
            String pattern = BridgeUtilities.getString(l, "");
            BasicIO.WriteFormatted(pattern, a.getWriter(), i.getScriptEnvironment(), l, a);
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class bread
    implements Function {
        private bread() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            IOObject a = BasicIO.chooseSource(l, 2, i);
            String pattern = BridgeUtilities.getString(l, "");
            return a.getReader() != null ? BasicIO.ReadFormatted(pattern, a.getReader(), i.getScriptEnvironment(), a) : SleepUtils.getEmptyScalar();
        }
    }

    private static class getConsoleObject
    implements Function {
        private getConsoleObject() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            return SleepUtils.getScalar(IOObject.getConsole(i.getScriptEnvironment()));
        }
    }

    private static class printEOF
    implements Function {
        private printEOF() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            IOObject a = BasicIO.chooseSource(l, 1, i);
            a.sendEOF();
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class print
    implements Function {
        private print() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            IOObject a = BasicIO.chooseSource(l, 2, i);
            String temp = BridgeUtilities.getString(l, "");
            a.print(temp);
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class printArray
    implements Function {
        private printArray() {
        }

        public Scalar evaluate(String n, ScriptInstance inst, Stack l) {
            IOObject a = BasicIO.chooseSource(l, 2, inst);
            Iterator i = BridgeUtilities.getIterator(l, inst);
            while (i.hasNext()) {
                a.printLine(i.next().toString());
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class println
    implements Function {
        private println() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            IOObject a = BasicIO.chooseSource(l, 2, i);
            String temp = BridgeUtilities.getString(l, "");
            a.printLine(temp);
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class readAll
    implements Function {
        private readAll() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            String temp;
            IOObject a = BasicIO.chooseSource(l, 1, i);
            Scalar ar = SleepUtils.getArrayScalar();
            while ((temp = a.readLine()) != null) {
                ar.getArray().push(SleepUtils.getScalar(temp));
            }
            return ar;
        }
    }

    private static class readln
    implements Function {
        private readln() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            IOObject a = BasicIO.chooseSource(l, 1, i);
            String temp = a.readLine();
            if (temp == null) {
                return SleepUtils.getEmptyScalar();
            }
            return SleepUtils.getScalar(temp);
        }
    }

    private static class closef
    implements Function {
        private closef() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            if (!l.isEmpty() && ((Scalar)l.peek()).objectValue() instanceof IOObject) {
                IOObject a = (IOObject)BridgeUtilities.getObject(l);
                a.close();
            } else {
                int port = BridgeUtilities.getInt(l, 80);
                SocketObject.release(port);
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class SocketFuncs
    implements Function {
        private SocketFuncs() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            Map options = BridgeUtilities.extractNamedParameters(l);
            SocketObject.SocketHandler handler = new SocketObject.SocketHandler();
            handler.socket = new SocketObject();
            handler.script = i;
            handler.lport = options.containsKey("lport") ? ((Scalar)options.get("lport")).intValue() : 0;
            handler.laddr = options.containsKey("laddr") ? ((Scalar)options.get("laddr")).toString() : null;
            handler.linger = options.containsKey("linger") ? ((Scalar)options.get("linger")).intValue() : 5;
            int n2 = handler.backlog = options.containsKey("backlog") ? ((Scalar)options.get("backlog")).intValue() : 0;
            if (n.equals("&listen")) {
                handler.port = BridgeUtilities.getInt(l, -1);
                handler.timeout = BridgeUtilities.getInt(l, 60000);
                handler.callback = BridgeUtilities.getScalar(l);
                handler.type = 1;
            } else {
                handler.host = BridgeUtilities.getString(l, "127.0.0.1");
                handler.port = BridgeUtilities.getInt(l, 1);
                handler.timeout = BridgeUtilities.getInt(l, 60000);
                handler.type = 2;
            }
            if (!l.isEmpty()) {
                handler.function = BridgeUtilities.getFunction(l, i);
            }
            handler.start();
            return SleepUtils.getScalar(handler.socket);
        }
    }

    private static class fork
    implements Function {
        private fork() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            SleepClosure param = BridgeUtilities.getFunction(l, i);
            ScriptInstance child = i.fork();
            child.installBlock(param.getRunnableCode());
            ScriptVariables vars = child.getScriptVariables();
            while (!l.isEmpty()) {
                KeyValuePair kvp = BridgeUtilities.getKeyValuePair(l);
                vars.putScalar(kvp.getKey().toString(), SleepUtils.getScalar(kvp.getValue()));
            }
            IOObject parent_io = new IOObject();
            IOObject child_io = new IOObject();
            try {
                PipedInputStream parent_in = new PipedInputStream();
                PipedOutputStream parent_out = new PipedOutputStream();
                parent_in.connect(parent_out);
                PipedInputStream child_in = new PipedInputStream();
                PipedOutputStream child_out = new PipedOutputStream();
                child_in.connect(child_out);
                parent_io.openRead(child_in);
                parent_io.openWrite(parent_out);
                child_io.openRead(parent_in);
                child_io.openWrite(child_out);
                child.getScriptVariables().putScalar("$source", SleepUtils.getScalar(child_io));
                Thread temp = new Thread((Runnable)child, "fork of " + child.getRunnableBlock().getSourceLocation());
                parent_io.setThread(temp);
                child_io.setThread(temp);
                child.setParent(parent_io);
                temp.start();
            }
            catch (Exception ex) {
                i.getScriptEnvironment().flagError(ex);
            }
            return SleepUtils.getScalar(parent_io);
        }
    }

    private static class sleep
    implements Function {
        private sleep() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            try {
                Thread.currentThread();
                Thread.sleep(BridgeUtilities.getLong(l, 0L));
            }
            catch (Exception ex) {
                // empty catch block
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class exec
    implements Function {
        private exec() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            Scalar cmd = l.isEmpty() ? SleepUtils.getEmptyScalar() : (Scalar)l.pop();
            String[] command = cmd.getArray() != null ? SleepUtils.getListFromArray(cmd.getArray()).toArray(new String[0]) : cmd.toString().split("\\s");
            String[] envp = null;
            File start = null;
            if (!l.isEmpty()) {
                if (SleepUtils.isEmptyScalar((Scalar)l.peek())) {
                    l.pop();
                } else {
                    ScalarHash env = BridgeUtilities.getHash(l);
                    Iterator keys = env.keys().scalarIterator();
                    envp = new String[env.keys().size()];
                    for (int x = 0; x < envp.length; ++x) {
                        Scalar key = (Scalar)keys.next();
                        envp[x] = key.toString() + "=" + env.getAt(key);
                    }
                }
            }
            if (!l.isEmpty() && !SleepUtils.isEmptyScalar((Scalar)l.peek())) {
                if (SleepUtils.isEmptyScalar((Scalar)l.peek())) {
                    l.pop();
                } else {
                    start = BridgeUtilities.getFile(l, i);
                }
            }
            ProcessObject temp = new ProcessObject();
            temp.open(command, envp, start, i.getScriptEnvironment());
            return SleepUtils.getScalar(temp);
        }
    }

    private static class openf
    implements Function {
        private openf() {
        }

        public Scalar evaluate(String n, ScriptInstance i, Stack l) {
            String a = ((Scalar)l.pop()).toString();
            FileObject temp = new FileObject();
            temp.open(a, i.getScriptEnvironment());
            return SleepUtils.getScalar(temp);
        }
    }
}

