/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Stack;
import sleep.engine.types.ArrayContainer;
import sleep.interfaces.Variable;
import sleep.runtime.Scalar;

public class ArgumentArray
extends ArrayContainer {
    private int sz;
    private Variable store;

    public ArgumentArray(int size, Variable varStore) {
        this.sz = size - 1;
        this.store = varStore;
        this.values = null;
    }

    private void check() {
        if (this.values == null) {
            this.values = new Stack();
            for (int x = 0; x < this.sz; ++x) {
                this.values.push(this.store.getScalar("$" + (x + 1)));
            }
        }
    }

    public Scalar pop() {
        this.check();
        return super.pop();
    }

    public Scalar push(Scalar value) {
        this.check();
        return super.push(value);
    }

    public int size() {
        if (this.values == null) {
            return this.sz;
        }
        return super.size();
    }

    public Scalar getAt(int index) {
        this.check();
        return super.getAt(index);
    }

    public Iterator scalarIterator() {
        this.check();
        return super.scalarIterator();
    }

    public Scalar add(Scalar value, int index) {
        this.check();
        return super.add(value, index);
    }

    public void remove(Scalar value) {
        this.check();
        super.remove(value);
    }

    public Scalar remove(int index) {
        this.check();
        return super.remove(index);
    }

    public void sort(Comparator compare) {
        this.check();
        super.sort(compare);
    }

    public String toString() {
        this.check();
        return super.toString();
    }
}

