/*
 * Decompiled with CFR 0.152.
 */
package rero.util;

import rero.util.hidden.MyTokenizer;

public class TokenizedString {
    protected String text;
    protected String tokenDelimeter;
    protected String[] stringToken;
    protected String[] tokenUpCache;
    protected String[] tokenDownCache;
    protected int totalTokens;

    public String getString() {
        return this.text;
    }

    public TokenizedString(String str) {
        this.text = str;
    }

    public TokenizedString(String str, String delim) {
        this.text = str;
        this.tokenize(delim);
    }

    public int tokenize(String delim) {
        MyTokenizer erect = new MyTokenizer(this.text, delim);
        this.stringToken = new String[erect.countTokens()];
        this.tokenUpCache = new String[erect.countTokens()];
        this.tokenDownCache = new String[erect.countTokens()];
        this.totalTokens = this.stringToken.length;
        this.tokenDelimeter = delim;
        for (int x = 0; x < this.totalTokens; ++x) {
            this.stringToken[x] = erect.nextToken();
        }
        return this.totalTokens;
    }

    public String getTokenRange(int a, int b) {
        if (a == 0) {
            return this.getTokenTo(b);
        }
        if (a == b) {
            return "";
        }
        if (a > b) {
            return "";
        }
        String startOfRange = this.getTokenTo(a);
        String endOfRange = this.getTokenTo(b + 1);
        int lenStart = startOfRange.length();
        int lenEnd = endOfRange.length();
        int lenDelim = this.tokenDelimeter.length();
        int lenText = this.text.length();
        while (lenStart + lenDelim < lenText && this.text.substring(lenStart, lenStart + lenDelim).equals(this.tokenDelimeter)) {
            lenStart += lenDelim;
        }
        return this.text.substring(lenStart, lenEnd);
    }

    public String getTokenTo(int x) {
        if (x >= this.tokenDownCache.length) {
            return this.text;
        }
        if (this.tokenDownCache[x] == null) {
            this.tokenDownCache[x] = TokenizedString.gettokdn(this.text, x, this.tokenDelimeter);
        }
        return this.tokenDownCache[x];
    }

    public String getTokenFrom(int x) {
        if (x >= this.tokenDownCache.length) {
            return "";
        }
        if (this.tokenUpCache[x] == null) {
            this.tokenUpCache[x] = TokenizedString.gettokup(this.text, x, this.tokenDelimeter);
        }
        return this.tokenUpCache[x];
    }

    public boolean isTokenized(String text, String delim) {
        return text.equals(this.text) && delim.equals(this.tokenDelimeter);
    }

    public int getTotalTokens() {
        return this.totalTokens;
    }

    public String getToken(int x) {
        if (x < this.totalTokens) {
            return this.stringToken[x];
        }
        return null;
    }

    public String toString() {
        String t = "---     jString:Report      ---\n";
        t = t + "Original String: " + this.text + "\n";
        t = t + "Token Delimeter: \"" + this.tokenDelimeter + "\"\n";
        t = t + "Total Tokens   : " + this.totalTokens + "\n";
        t = t + "---       Token:Breakdown   ---\n";
        for (int x = 0; x < this.totalTokens; ++x) {
            t = t + x + ")  " + this.getToken(x) + "\n";
        }
        t = t + "---         END:REPORT      ---\n";
        return t;
    }

    protected static String gettokup(String text, int occurence, String delim) {
        if (occurence == 0) {
            return text;
        }
        String tokensPrior = TokenizedString.gettokdn(text, occurence, delim);
        int lenPrior = tokensPrior.length();
        int lenDelim = delim.length();
        int lenText = text.length();
        if (lenPrior < lenText) {
            while (lenPrior + lenDelim < lenText && text.substring(lenPrior, lenPrior + lenDelim).equals(delim)) {
                lenPrior += lenDelim;
            }
            return text.substring(lenPrior, lenText);
        }
        return "";
    }

    protected static String gettokdn(String text, int occurence, String delim) {
        if (occurence == 0) {
            return "";
        }
        int occ = 0;
        int dlen = delim.length();
        int tlen = text.length();
        for (int x = 0; x < tlen; ++x) {
            if (x + dlen >= tlen || !text.substring(x, x + dlen).equals(delim)) continue;
            if (++occ == occurence) {
                return text.substring(0, x);
            }
            while (x + dlen < tlen && text.substring(x, x + dlen).equals(delim)) {
                x += dlen;
            }
        }
        return text;
    }

    public boolean isToken(String token) {
        return this.findToken(token) >= 0;
    }

    public int findToken(String token) {
        for (int x = 0; x < this.getTotalTokens(); ++x) {
            if (!this.getToken(x).toUpperCase().equals(token.toUpperCase())) continue;
            return x;
        }
        return -1;
    }
}

