/*
 * Decompiled with CFR 0.152.
 */
package rero.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import rero.util.TimedEvent;
import rero.util.TimerListener;

public class TimerUtil
implements Runnable {
    protected long resolution = 15000L;
    protected List timers = new LinkedList();

    public void setResolution(long _resolution) {
        this.resolution = _resolution == 0L && this.resolution > 1000L ? 1000L : _resolution;
    }

    public void start() {
        Thread timerThread = new Thread(this);
        timerThread.setName("jIRCii TIMER Thread");
        timerThread.setDaemon(true);
        timerThread.setPriority(1);
        timerThread.start();
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Iterator i = this.timers.iterator();
                    while (i.hasNext()) {
                        TimedEvent temp = (TimedEvent)i.next();
                        if (temp.isValid()) {
                            if (!temp.isReady()) continue;
                            temp.timerExecute();
                            continue;
                        }
                        i.remove();
                    }
                    Thread.sleep(this.resolution);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void addTimer(TimerListener l, long delay, int repeat) {
        if (delay < this.resolution) {
            this.setResolution(delay);
        }
        this.addTimer(new TimedEvent(l, delay, repeat));
    }

    public void addTimer(TimerListener l, long delay) {
        if (delay < this.resolution) {
            this.setResolution(delay);
        }
        this.addTimer(new TimedEvent(l, delay));
    }

    public void stopTimer(TimerListener l) {
        HashSet removeMe = new HashSet();
        ListIterator i = this.timers.listIterator();
        while (i.hasNext()) {
            TimedEvent temp = (TimedEvent)i.next();
            if (temp.getListener() != l) continue;
            temp.finish();
        }
    }

    public void addTimer(TimedEvent temp) {
        this.timers.add(temp);
    }
}

