/*
 * Decompiled with CFR 0.152.
 */
package rero.util;

import javax.swing.SwingUtilities;
import rero.util.TimerListener;

public class TimedEvent {
    protected TimerListener listener;
    protected Runnable executeMe;
    protected long lastTouched;
    protected int repeats;
    protected long waitTime;

    public TimedEvent(TimerListener _listener) {
        this(_listener, 60000L, -1);
    }

    public TimedEvent(TimerListener _listener, long _waitTime) {
        this(_listener, _waitTime, -1);
    }

    public TimedEvent(TimerListener _listener, long _waitTime, int _repeats) {
        this.listener = _listener;
        this.lastTouched = System.currentTimeMillis();
        this.repeats = _repeats;
        this.waitTime = _waitTime;
        this.executeMe = new Runnable(){

            public void run() {
                TimedEvent.this.listener.timerExecute();
            }
        };
    }

    public TimerListener getListener() {
        return this.listener;
    }

    public void finish() {
        this.repeats = 0;
    }

    public boolean isValid() {
        return this.repeats != 0;
    }

    public boolean isReady() {
        return System.currentTimeMillis() - this.lastTouched >= this.waitTime;
    }

    public void timerExecute() {
        SwingUtilities.invokeLater(this.executeMe);
        this.lastTouched = System.currentTimeMillis();
        if (this.repeats > 0) {
            --this.repeats;
        }
    }
}

