/*
 * Decompiled with CFR 0.152.
 */
package rero.util;

import java.awt.Container;
import java.awt.Font;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import rero.config.ClientDefaults;
import rero.config.ClientState;
import rero.dialogs.DialogUtilities;
import rero.util.TokenizedString;
import text.AttributedString;
import text.TextSource;

public class ClientUtils {
    private static String CP437TABLE = "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00a2\u00a3\u00a5\u20a7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u2310\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u00df\u0393\u03c0\u03a3\u03c3\u00b5\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u03c6\u03b5\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0 ";

    public static void invokeLater(Runnable doIt) {
        if (SwingUtilities.isEventDispatchThread()) {
            doIt.run();
        } else {
            SwingUtilities.invokeLater(doIt);
        }
    }

    public static JFrame getFrameForComponent(JComponent c) {
        for (Container temp = c.getParent(); temp != null; temp = temp.getParent()) {
            if (!(temp instanceof JFrame)) continue;
            return (JFrame)temp;
        }
        return null;
    }

    public static String strip(String text) {
        return AttributedString.CreateAttributedString(text).getText();
    }

    public static String ShowVersion() {
        String tagline = ClientUtils.tagline();
        return "jIRCii " + ClientState.getClientState().getString("version.string", "05.09.08") + " " + System.getProperty("os.name").replaceAll(" ", "") + " : " + ClientState.getClientState().getString("version.addons", ClientUtils.tagline());
    }

    public static String tagline() {
        String[] taglines = new String[]{"highly caffeinated", "Fat butane, grubbin' on French fries", "Clean. Christian. Comprehensive."};
        int r = ClientUtils.ctime() % taglines.length;
        return taglines[r];
    }

    public static String formatTime(long seconds) {
        StringBuffer rv = new StringBuffer();
        if (seconds < 60L) {
            return seconds + " seconds";
        }
        if (seconds < 3600L) {
            return seconds / 60L + " minutes";
        }
        if (seconds < 86400L) {
            return seconds / 3600L + " hours";
        }
        return seconds / 86400L + " days";
    }

    public static String formatTime2(long secs) {
        StringBuffer rv = new StringBuffer();
        int seconds = (int)secs;
        int minutes = 0;
        int hours = 0;
        int days = 0;
        days = seconds / 86400;
        hours = seconds / 3600 % 24;
        minutes = seconds / 60 % 60;
        seconds %= 60;
        if (days > 0) {
            rv.append(days);
            rv.append(":");
        }
        if (hours > 0) {
            if (hours < 10) {
                rv.append("0");
            }
            rv.append(hours);
            rv.append(":");
        }
        if (minutes > 0) {
            if (minutes < 10) {
                rv.append("0");
            }
            rv.append(minutes);
            rv.append(":");
        }
        if (seconds < 10) {
            rv.append("0");
        }
        rv.append(seconds);
        return rv.toString();
    }

    public static String formatTime3(long secs) {
        int seconds = (int)secs;
        int minutes = 0;
        int hours = 0;
        int days = 0;
        days = seconds / 86400;
        hours = seconds / 3600 % 24;
        minutes = seconds / 60 % 60;
        seconds %= 60;
        StringBuffer buf = new StringBuffer();
        if (days > 0) {
            buf.append(days).append(days != 1 ? " days, " : " day, ");
        }
        if (days > 0 || hours > 0) {
            buf.append(hours).append(hours != 1 ? " hours, " : " hour, ");
        }
        if (hours > 0 || minutes > 0) {
            buf.append(minutes).append(minutes != 1 ? " minutes, " : " minute, ");
        }
        buf.append(seconds).append(seconds != 1 ? " seconds" : " second");
        return buf.toString();
    }

    public static String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + "b";
        }
        if ((bytes /= 1024L) < 1024L) {
            return bytes + "kb";
        }
        if ((bytes /= 1024L) < 1024L) {
            return bytes + "mb";
        }
        return (bytes /= 1024L) + "GB";
    }

    public static String encodeFont(Font value) {
        StringBuffer saved = new StringBuffer();
        saved.append(value.getFamily());
        saved.append("-");
        if (value.isBold()) {
            saved.append("BOLD");
        } else if (value.isItalic()) {
            saved.append("ITALIC");
        } else {
            saved.append("PLAIN");
        }
        saved.append("-");
        saved.append(value.getSize());
        return saved.toString();
    }

    public static void openURL(String location) {
        try {
            Runtime.getRuntime().exec(ClientState.getClientState().getString("ui.openfiles", ClientDefaults.ui_openfiles) + " " + location);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String mask(String address, int type) {
        if (address.length() == 0 || address.indexOf(33) < 1 || address.indexOf(64) < 1 || address.indexOf(46) < 1) {
            return "<bad address, use nick!user@host format>";
        }
        String n = address.substring(0, address.indexOf(33));
        String u = address.substring(address.indexOf(33) + 1, address.indexOf(64));
        String h = address.substring(address.indexOf(64) + 1, address.length());
        String d = address.lastIndexOf(46, address.lastIndexOf(46) - 1) > -1 ? "*" + address.substring(address.lastIndexOf(46, address.lastIndexOf(46) - 1), address.length()) : h;
        switch (type) {
            case 0: {
                return "*!" + u + "@" + h;
            }
            case 1: {
                return "*!*" + u + "@" + h;
            }
            case 2: {
                return "*!*@" + h;
            }
            case 3: {
                return "*!*" + u + "@" + d;
            }
            case 4: {
                return "*!*@" + d;
            }
            case 5: {
                return n + "!" + u + "@" + h;
            }
            case 6: {
                return n + "!*" + u + "@" + h;
            }
            case 7: {
                return n + "!*@" + h;
            }
            case 8: {
                return n + "!*" + u + "@" + d;
            }
            case 9: {
                return n + "!*@" + d;
            }
        }
        return address;
    }

    public static String longip(String l) {
        TokenizedString s = new TokenizedString(l);
        s.tokenize(".");
        if (s.getTotalTokens() == 4) {
            long a = Long.parseLong(s.getToken(0));
            long b = Long.parseLong(s.getToken(1));
            long c = Long.parseLong(s.getToken(2));
            long d = Long.parseLong(s.getToken(3));
            long x = (a << 24) + (b << 16) + (c << 8) + d;
            return x + "";
        }
        long x = Long.parseLong(l);
        long a = (x & 0xFFFFFFFFFF000000L) >> 24;
        long b = (x & 0xFF0000L) >> 16;
        long c = (x & 0xFF00L) >> 8;
        long d = x & 0xFFL;
        return a + "." + b + "." + c + "." + d;
    }

    public static String TimeStamp() {
        Date rightNow = new Date();
        String am_pm = "am";
        int hours = rightNow.getHours();
        int minutes = rightNow.getMinutes();
        if (hours == 0) {
            hours = 12;
            am_pm = "am";
        } else if (hours > 12) {
            hours -= 12;
            am_pm = "pm";
        } else if (hours == 12) {
            am_pm = "pm";
        }
        String rv = minutes <= 9 ? hours + ":0" + minutes + am_pm : hours + ":" + minutes + am_pm;
        return rv;
    }

    public static HashMap getEventHashMap(String target, String parms) {
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("$data", target + " " + parms);
        temp.put("$parms", parms);
        return temp;
    }

    public static String TimeDateStamp(long l) {
        Date temp = new Date(l * 1000L);
        String am_pm = "am";
        int hours = temp.getHours();
        int minutes = temp.getMinutes();
        StringBuffer value = new StringBuffer("");
        StringBuffer rv = new StringBuffer("");
        if (hours >= 12) {
            am_pm = "pm";
            if ((hours -= 12) == 0) {
                hours = 12;
            }
        }
        if (minutes <= 9) {
            value.append(hours);
            value.append(":0");
            value.append(minutes);
            value.append(am_pm);
        } else {
            value.append(hours);
            value.append(":");
            value.append(minutes);
            value.append(am_pm);
        }
        rv.append(ClientUtils.intToDay(temp.getDay()));
        rv.append(" ");
        rv.append(ClientUtils.intToMonth(temp.getMonth()));
        rv.append(" ");
        rv.append(temp.getDate());
        rv.append(" ");
        rv.append(temp.getYear() + 1900);
        rv.append(" ");
        rv.append(value.toString());
        return rv.toString();
    }

    public static String intToDay(int d) {
        switch (d %= 7) {
            case 0: {
                return "Sun";
            }
            case 1: {
                return "Mon";
            }
            case 2: {
                return "Tues";
            }
            case 3: {
                return "Wed";
            }
            case 4: {
                return "Thurs";
            }
            case 5: {
                return "Fri";
            }
            case 6: {
                return "Sat";
            }
        }
        return "Unknown Day: " + d;
    }

    public static boolean isNumeric(String n) {
        return Character.isDigit(n.charAt(0));
    }

    public static String intToMonth(int m) {
        switch (m) {
            case 0: {
                return "Jan";
            }
            case 1: {
                return "Feb";
            }
            case 2: {
                return "Mar";
            }
            case 3: {
                return "Apr";
            }
            case 4: {
                return "May";
            }
            case 5: {
                return "Jun";
            }
            case 6: {
                return "Jul";
            }
            case 7: {
                return "Aug";
            }
            case 8: {
                return "Sep";
            }
            case 9: {
                return "Oct";
            }
            case 10: {
                return "Nov";
            }
            case 11: {
                return "Dec";
            }
        }
        return "Unknown Month: " + m;
    }

    public static boolean isChannel(String target) {
        return target.length() > 0 && (target.charAt(0) == '#' || target.charAt(0) == '&');
    }

    public static int ctime() {
        Long temp = new Long(System.currentTimeMillis() / 1000L);
        return temp.intValue();
    }

    public static String BuildCP437String(String text) {
        char[] temp = text.toCharArray();
        for (int x = 0; x < temp.length; ++x) {
            char value = temp[x];
            if (value >= CP437TABLE.length()) continue;
            temp[x] = CP437TABLE.charAt(value);
        }
        return new String(temp);
    }

    public static void dump2(HashMap data) {
        Iterator i = data.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            System.out.println(key + "=> " + data.get(key));
        }
        System.out.println("   ... Done ...");
    }

    public static String formatLongAsDecimal(long l) {
        String rv = l + "";
        if (rv.length() < 3) {
            while (rv.length() < 3) {
                rv = "0" + rv;
            }
            return "." + rv;
        }
        return rv.substring(0, rv.length() - 3) + "." + rv.substring(rv.length() - 3, rv.length());
    }

    public static void removeAll(Collection source, Set remove) {
        Iterator i = remove.iterator();
        while (i.hasNext()) {
            source.remove(i.next());
        }
    }

    public static String generateThemeScript(String name) {
        File file;
        if ((name == null || name.length() == 0) && (file = DialogUtilities.showSaveDialog("Save Theme Script")) != null) {
            name = file.getAbsolutePath();
        }
        if (name == null || name.length() == 0) {
            return null;
        }
        StringBuffer temp = new StringBuffer();
        temp.append("# jIRCii Theme File, scripters feel free to edit this file to export more settings\n");
        temp.append("#     by default only color settings are exported.\n\n");
        temp.append("# some miscellaneous colors\n");
        temp.append(ClientUtils.generateThemeLine("statusbar.color", null));
        temp.append(ClientUtils.generateThemeLine("window.color", null));
        temp.append(ClientUtils.generateThemeLine("desktop.color", null));
        temp.append(ClientUtils.generateThemeLine("switchbar.color", null));
        temp.append(ClientUtils.generateThemeLine("ui.editcolor", null));
        temp.append("\n");
        temp.append("# the actual color map\n");
        for (int x = 0; x < 100; ++x) {
            temp.append("setMappedColor(");
            temp.append(x);
            temp.append(", \"");
            temp.append(TextSource.colorTable[x].getRGB());
            temp.append("\");\n");
        }
        temp.append("\n# force jIRCii to update settings right away\n");
        temp.append("setProperty(\"desktop\", -1);\n");
        temp.append("setProperty(\"statusbar\", -1);\n");
        temp.append("setProperty(\"window\", -1);\n");
        temp.append("\nsaveColorMap();\n");
        try {
            PrintWriter output = new PrintWriter(new FileOutputStream(new File(name), false));
            output.println(temp.toString());
            output.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return new File(name).getName();
    }

    private static String generateThemeLine(String var, String comment) {
        StringBuffer temp = new StringBuffer();
        if (ClientState.getClientState().getString(var, null) != null) {
            if (comment != null) {
                temp.append("# " + comment + "\n");
            }
            temp.append("setProperty(\"");
            temp.append(var);
            temp.append("\", \"");
            temp.append(ClientState.getClientState().getString(var, null));
            temp.append("\");\n");
        }
        return temp.toString();
    }

    public static File getFile(String file) {
        if (file.length() > 0 && file.charAt(0) == '~' && System.getProperty("user.home") != null) {
            return new File(System.getProperty("user.home").toString(), file.substring(1));
        }
        return new File(file);
    }

    public static LinkedList fileCompleteAll(String pfile) {
        File cwd;
        LinkedList<String> rv = new LinkedList<String>();
        String cwf = null;
        File temp = ClientUtils.getFile(pfile);
        if (temp.isDirectory()) {
            cwd = temp;
            cwf = null;
        } else if (temp.getParentFile() != null && temp.getParentFile().isDirectory()) {
            cwd = temp.getParentFile();
            cwf = temp.getName();
        } else {
            cwd = new File(new File("").getAbsolutePath());
            cwf = pfile;
        }
        File[] files = cwd.listFiles();
        for (int x = 0; x < files.length; ++x) {
            String tempn = files[x].getName();
            if (cwf == null) {
                rv.add(files[x].getAbsolutePath());
                continue;
            }
            if (tempn.length() >= cwf.length() && tempn.toUpperCase().substring(0, cwf.length()).equals(cwf.toUpperCase())) {
                rv.add(0, files[x].getAbsolutePath());
                continue;
            }
            if (tempn.toUpperCase().indexOf(cwf.toUpperCase()) <= -1) continue;
            rv.add(files[x].getAbsolutePath());
        }
        rv.add(pfile);
        return rv;
    }
}

