/*
 * Decompiled with CFR 0.152.
 */
package rero.test;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.net.URI;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import rero.config.ClientState;
import rero.gui.GlobalCapabilities;
import rero.gui.SessionManager;
import rero.ident.IdentDaemon;
import rero.test.ProxySettings;
import rero.test.QuickConnect;

public class WindowTest {
    protected JFrame frame;

    private static void checkEnvironment() {
        boolean invalidenv = false;
        try {
            String envs = System.getProperty("java.specification.version");
            double ver = Double.parseDouble(envs);
            invalidenv = ver == 1.4 ? System.getProperty("java.vm.version").indexOf("1.4.1") > -1 || System.getProperty("java.vm.version").indexOf("1.4.0") > -1 : ver < 1.4;
        }
        catch (Exception ex) {
            invalidenv = true;
        }
        if (invalidenv) {
            String outdated = "Outdated Java Error:\njIRC Requires a java virtual machine compatible \nwith Java 1.4.2 or greater.  Download the latest \nversion of " + System.getProperty("java.vendor") + "'s Java at\n" + System.getProperty("java.vendor.url") + "\nYou are running: Java " + System.getProperty("java.version");
            System.err.println(outdated);
            Frame temp = new Frame();
            JOptionPane.showMessageDialog(temp, outdated, "Outdated Java Error", 0);
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        WindowTest.checkEnvironment();
        int ARGNO = 0;
        if (System.getProperty("mrj.version") != null) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.macos.smallTabs", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "jIRCii");
            try {
                Class<?> osxAdapter = Class.forName("apple.OSXAdapter");
                Class[] defArgs = new Class[]{};
                Method registerMethod = osxAdapter.getDeclaredMethod("registerMacOSXApplication", defArgs);
                if (registerMethod != null) {
                    registerMethod.invoke(osxAdapter, new Object[0]);
                }
            }
            catch (Exception ex) {
                System.err.println("Exception while loading the OSXAdapter:");
                ex.printStackTrace();
            }
        }
        if (ARGNO + 1 < args.length && args[ARGNO].equals("-settings")) {
            ClientState.setBaseDirectory(args[ARGNO + 1]);
            ARGNO += 2;
        }
        try {
            if (ARGNO + 1 < args.length && args[ARGNO].equals("-lnf")) {
                UIManager.setLookAndFeel(args[ARGNO + 1]);
                ARGNO += 2;
            } else if (ClientState.getClientState().isOption("ui.native", true) && !"com.sun.java.swing.plaf.gtk.GTKLookAndFeel".equals(UIManager.getSystemLookAndFeelClassName())) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
        catch (Exception e) {
            System.err.println("Could not load specified look and feel, using system default");
            e.printStackTrace();
        }
        ProxySettings.initialize();
        IdentDaemon.initialize();
        if (ARGNO < args.length && (args[ARGNO].indexOf("irc://") > -1 || args[ARGNO].indexOf("ircs://") > -1)) {
            try {
                new QuickConnect(new URI(args[ARGNO]));
            }
            catch (Exception urlex) {
                urlex.printStackTrace();
            }
            ++ARGNO;
        }
        new WindowTest();
    }

    public WindowTest() {
        GlobalCapabilities.frame = this.frame = new JFrame("jIRCii");
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)new SessionManager(this.frame), "Center");
        this.frame.setIconImage(ClientState.getClientState().getIcon("jirc.icon", "jicon.jpg").getImage());
        int inset = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 2;
        this.frame.setBounds(ClientState.getClientState().getBounds("desktop.bounds", Toolkit.getDefaultToolkit().getScreenSize(), new Dimension(640, 480)));
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent ev) {
                SessionManager.getGlobalCapabilities().QuitClient();
            }
        });
        this.frame.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent ev) {
                if (ClientState.getClientState().isOption("desktop.relative", false) || ClientState.getClientState().isOption("window.relative", false) || ClientState.getClientState().isOption("statusbar.relative", false)) {
                    WindowTest.this.frame.validate();
                    ClientState.getClientState().fireChange("desktop");
                    ClientState.getClientState().fireChange("window");
                    ClientState.getClientState().fireChange("statusbar");
                    WindowTest.this.frame.repaint();
                }
            }
        });
        this.frame.show();
    }
}

