/*
 * Decompiled with CFR 0.152.
 */
package rero.test;

import java.net.URI;

public class QuickConnect {
    private static QuickConnect qc = null;
    private URI info;

    public static boolean IsQuickConnect() {
        return qc != null;
    }

    public QuickConnect(URI _info) {
        qc = this;
        this.info = _info;
    }

    public String getConnectCommand() {
        StringBuffer doit = new StringBuffer();
        doit.append("/server ");
        if (this.isSSL()) {
            doit.append("-ssl ");
        }
        doit.append(this.getServer());
        doit.append(" ");
        doit.append(this.getPort());
        return doit.toString();
    }

    public static QuickConnect GetInformation() {
        return qc;
    }

    public URI getURL() {
        return this.info;
    }

    public String getNickname() {
        if (this.info.getUserInfo() != null) {
            return this.info.getUserInfo();
        }
        return "Guest_" + System.currentTimeMillis() % 100L;
    }

    public boolean isSSL() {
        System.out.println(this.info.getScheme());
        return "ircs".equals(this.info.getScheme());
    }

    public String getPort() {
        if (this.info.getPort() > -1) {
            return this.info.getPort() + "";
        }
        return "6667";
    }

    public String getServer() {
        String temp = this.info.getHost();
        if (this.info.getPath() == null || this.info.getPath().length() == 0) {
            qc = null;
            this.info = null;
        }
        return temp;
    }

    public String getCommand() {
        String temp = "/join #" + this.info.getPath().substring(1, this.info.getPath().length()) + " " + this.info.getQuery();
        qc = null;
        this.info = null;
        return temp;
    }
}

