/*
 * Decompiled with CFR 0.152.
 */
package rero.script;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Stack;
import java.util.WeakHashMap;
import rero.bridges.BridgeKeeper;
import rero.config.ClientState;
import rero.ircfw.ChatFramework;
import rero.script.GlobalVariables;
import rero.script.LocalVariables;
import sleep.engine.Block;
import sleep.interfaces.Loadable;
import sleep.parser.CodeGenerator;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.ScriptLoader;
import sleep.runtime.ScriptVariables;
import sleep.runtime.SleepUtils;

public class ScriptCore
implements Loadable {
    protected ScriptLoader scriptLoader;
    protected Hashtable environment;
    protected ScriptVariables variables;
    protected GlobalVariables globalData;
    protected BridgeKeeper bridges;
    protected static Scalar GLOBAL_HASH;

    public ScriptCore() {
        if (GLOBAL_HASH == null) {
            GLOBAL_HASH = SleepUtils.getHashScalar();
        }
        this.scriptLoader = new ScriptLoader();
        this.environment = new Hashtable();
        this.globalData = new GlobalVariables();
        this.globalData.putScalar("%GLOBAL", GLOBAL_HASH);
        this.variables = new ScriptVariables(this.globalData);
        this.bridges = new BridgeKeeper();
        this.scriptLoader.setCharsetConversion(false);
        this.scriptLoader.setGlobalCache(true);
        this.scriptLoader.addSpecificBridge(this);
        CodeGenerator.installEscapeConstant('B', "\u0002");
        CodeGenerator.installEscapeConstant('U', "\u001f");
        CodeGenerator.installEscapeConstant('R', "\u0016");
        CodeGenerator.installEscapeConstant('C', "\u0003");
        CodeGenerator.installEscapeConstant('O', "\u000f");
        CodeGenerator.installEscapeConstant('b', "\u0002");
        CodeGenerator.installEscapeConstant('u', "\u001f");
        CodeGenerator.installEscapeConstant('r', "\u0016");
        CodeGenerator.installEscapeConstant('c', "\u0003");
        CodeGenerator.installEscapeConstant('o', "\u000f");
        SleepUtils.addKeyword("wait");
        SleepUtils.addKeyword("on");
        SleepUtils.addKeyword("alias");
        SleepUtils.addKeyword("bind");
        Loadable[] blist = this.bridges.getScriptBridges();
        for (int x = 0; x < blist.length; ++x) {
            this.addBridge(blist[x]);
        }
    }

    public void announceFramework(ChatFramework ircfw) {
        this.bridges.announceFramework(ircfw);
    }

    public void addBridge(Loadable l) {
        this.scriptLoader.addGlobalBridge(l);
    }

    public void storeDataStructures(WeakHashMap centralDataRepository) {
        centralDataRepository.put("scriptVariables", this.variables);
        centralDataRepository.put("globalVariables", this.globalData);
        centralDataRepository.put("scriptLoader", this.scriptLoader);
        centralDataRepository.put("sharedEnvironment", this.environment);
        this.bridges.storeDataStructures(centralDataRepository);
    }

    public Scalar callFunction(String function2, Stack parameters) {
        if (function2.charAt(0) != '&') {
            function2 = '&' + function2;
        }
        ScriptInstance si = (ScriptInstance)this.scriptLoader.getScripts().getFirst();
        return si.callFunction(function2, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runCode(ScriptInstance owner, Block code, HashMap locals) {
        ScriptVariables scriptVariables = owner.getScriptVariables();
        synchronized (scriptVariables) {
            ScriptVariables vars = owner.getScriptVariables();
            vars.pushLocalLevel();
            LocalVariables localLevel = (LocalVariables)vars.getLocalVariables();
            if (locals != null) {
                localLevel.setDataSource(locals);
            }
            SleepUtils.runCode(code, owner.getScriptEnvironment());
            vars.popLocalLevel();
        }
    }

    public void scriptLoaded(ScriptInstance si) {
        si.setScriptVariables(this.variables);
        ClientState.getClientState().fireChange("loaded.scripts", si.getName());
    }

    public void scriptUnloaded(ScriptInstance si) {
        ClientState.getClientState().fireChange("loaded.scripts", si.getName());
    }
}

