/*
 * Decompiled with CFR 0.152.
 */
package rero.script;

import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Pattern;
import rero.util.StringParser;
import rero.util.TokenizedString;
import sleep.interfaces.Variable;
import sleep.runtime.Scalar;
import sleep.runtime.SleepUtils;

public class LocalVariables
implements Variable {
    protected HashMap data = new HashMap();
    protected static Pattern rangePattern = Pattern.compile("\\$(\\d+)\\-(\\d+)");
    protected static Pattern rangeFromPattern = Pattern.compile("\\$(\\d+)\\-");
    protected static Pattern rangeToPattern = Pattern.compile("\\$\\-(\\d+)");
    protected static Pattern normalPattern = Pattern.compile("\\$(\\d+)");
    protected String parmsValue = null;

    public void setDataSource(HashMap _data) {
        Iterator iter = _data.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            if (key.equals("$data")) {
                this.parmsValue = (String)_data.get(key);
            }
            this.data.put(key, SleepUtils.getScalar((String)_data.get(key)));
        }
    }

    public boolean scalarExists(String key) {
        if (this.data.containsKey(key) || "%localData".equals(key)) {
            return true;
        }
        return this.parmsValue != null && (Character.isDigit(key.charAt(1)) || key.charAt(1) == '-');
    }

    public Scalar getScalar(String key) {
        if ("%localData".equals(key)) {
            return SleepUtils.getHashWrapper(this.data);
        }
        Scalar temp = (Scalar)this.data.get(key);
        if (temp == null && this.parmsValue != null && (Character.isDigit(key.charAt(1)) || key.charAt(1) == '-')) {
            TokenizedString tokenizer = new TokenizedString(this.parmsValue, " ");
            StringParser parser = new StringParser(key, rangePattern);
            if (parser.matches()) {
                int begin = Integer.parseInt(parser.getParsedStrings()[0]);
                int end = Integer.parseInt(parser.getParsedStrings()[1]);
                return SleepUtils.getScalar(tokenizer.getTokenRange(begin, end));
            }
            parser = new StringParser(key, rangeToPattern);
            if (parser.matches()) {
                int begin = Integer.parseInt(parser.getParsedStrings()[0]);
                return SleepUtils.getScalar(tokenizer.getTokenTo(begin));
            }
            parser = new StringParser(key, rangeFromPattern);
            if (parser.matches()) {
                int begin = Integer.parseInt(parser.getParsedStrings()[0]);
                return SleepUtils.getScalar(tokenizer.getTokenFrom(begin));
            }
            parser = new StringParser(key, normalPattern);
            if (parser.matches()) {
                int begin = Integer.parseInt(parser.getParsedStrings()[0]);
                return SleepUtils.getScalar(tokenizer.getToken(begin));
            }
        }
        return temp;
    }

    public Scalar putScalar(String key, Scalar value) {
        return this.data.put(key, value);
    }

    public void removeScalar(String key) {
    }

    public Variable createLocalVariableContainer() {
        return null;
    }

    public Variable createInternalVariableContainer() {
        return null;
    }
}

