/*
 * Decompiled with CFR 0.152.
 */
package rero.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.ListIterator;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.net.SecureSocket;
import rero.net.SocketEvent;
import rero.net.SocketInformation;
import rero.net.interfaces.SocketDataListener;
import rero.net.interfaces.SocketStatusListener;
import rero.util.ClientUtils;

public class SocketConnection
implements Runnable,
ClientStateListener {
    protected Socket aSocket;
    protected Thread readThread;
    protected PrintStream aSocketOutput;
    protected BufferedReader aSocketInput;
    protected long delay;
    protected SocketInformation connectionInformation;
    private static boolean stripcodes;
    private static ClientStateListener listener2;
    LinkedList connectDisconnectListeners = new LinkedList();
    LinkedList messageReadListeners = new LinkedList();
    SocketEvent event = new SocketEvent();

    public void propertyChanged(String property, String value) {
        try {
            if (this.aSocketInput != null && this.aSocket.isConnected()) {
                this.aSocketInput = new BufferedReader(ClientState.getProperInputStream(this.aSocket.getInputStream()));
                this.aSocketOutput = ClientState.getProperPrintStream(this.aSocket.getOutputStream());
            }
        }
        catch (Exception ex) {
            System.out.println("Unable to switch encodings...");
            ex.printStackTrace();
        }
    }

    public void println(String message) {
        try {
            this.aSocketOutput.println(message);
            this.aSocketOutput.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void disconnect() {
        if (this.aSocket != null && this.aSocket.isConnected()) {
            try {
                if (!this.aSocket.isOutputShutdown()) {
                    this.aSocket.shutdownOutput();
                }
                if (!this.aSocket.isInputShutdown()) {
                    this.aSocket.shutdownInput();
                }
                this.aSocket.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.aSocket = null;
        }
    }

    public void connect(String host, int port) {
        this.connect(host, port, 0L, null, false);
    }

    public void connect(String host, int port, long _delay, String password, boolean secure) {
        this.delay = _delay;
        if (this.readThread != null) {
            try {
                this.disconnect();
                this.readThread.interrupt();
                this.readThread.join(1000L);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.getSocketInformation().hostname = host;
        this.getSocketInformation().port = port;
        this.getSocketInformation().isSecure = secure;
        this.getSocketInformation().password = password;
        this.getSocketInformation().network = "Unknown";
        this.readThread = new Thread(this);
        this.readThread.setName("Socket Read Thread for: " + host);
        this.readThread.start();
    }

    public void run() {
        this.aSocketInput = null;
        this.aSocketOutput = null;
        try {
            if (this.delay > 0L) {
                Thread.sleep(this.delay);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        try {
            this.aSocket = this.getSocketInformation().isSecure ? new SecureSocket(this.getSocketInformation().hostname, this.getSocketInformation().port).getSocket() : new Socket(this.getSocketInformation().hostname, this.getSocketInformation().port);
            this.aSocket.setSoLinger(true, 5);
            this.aSocket.setTcpNoDelay(true);
            this.aSocket.setSoTimeout(300000);
            this.aSocketOutput = ClientState.getProperPrintStream(this.aSocket.getOutputStream());
            this.aSocketInput = new BufferedReader(ClientState.getProperInputStream(this.aSocket.getInputStream()));
        }
        catch (UnknownHostException ex1) {
            this.fireStatusEvent("unable to resolve hostname", false);
            return;
        }
        catch (Exception ex2) {
            if (Thread.currentThread() != this.readThread) {
                return;
            }
            this.fireStatusEvent(ex2.getMessage(), false);
            return;
        }
        if (this.aSocket != null) {
            this.fireStatusEvent("success", true);
        }
        String data = null;
        do {
            try {
                data = this.aSocketInput.readLine();
                if (data == null) continue;
                this.fireReadEvent(data);
            }
            catch (SocketException ex1) {
                this.fireStatusEvent(ex1.getMessage(), false);
                this.shutdownSocket();
                return;
            }
            catch (IOException ex2) {
                this.fireStatusEvent(ex2.getMessage(), false);
                this.shutdownSocket();
                return;
            }
            catch (Exception ex3) {
                if (this.aSocket == null || !this.aSocket.isConnected()) {
                    this.fireStatusEvent(ex3.getMessage(), false);
                    this.shutdownSocket();
                    return;
                }
                ex3.printStackTrace();
            }
        } while (this.aSocket != null && this.aSocket.isConnected() && data != null);
        this.fireStatusEvent("disconnected.", false);
        this.shutdownSocket();
    }

    private void shutdownSocket() {
        try {
            if (this.aSocketInput != null) {
                this.aSocketInput.close();
            }
            if (this.aSocketOutput != null) {
                this.aSocketOutput.close();
            }
            if (this.aSocket != null) {
                this.aSocket.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public SocketInformation getSocketInformation() {
        return this.connectionInformation;
    }

    public SocketConnection() {
        this.connectionInformation = new SocketInformation();
        this.event.socket = this;
        this.event.data = this.connectionInformation;
        ClientState.getClientState().addClientStateListener("client.encoding", this);
        if (listener2 == null) {
            listener2 = new ClientStateListener(){

                public void propertyChanged(String key, String value) {
                    stripcodes = ClientState.getClientState().isOption("client.stripcodes", false);
                }
            };
            listener2.propertyChanged(null, null);
            ClientState.getClientState().addClientStateListener("client.stripcodes", listener2);
        }
    }

    public void removeSocketStatusListener(SocketStatusListener l) {
        this.connectDisconnectListeners.remove(l);
    }

    public void removeSocketDataListener(SocketDataListener l) {
        this.messageReadListeners.remove(l);
    }

    public void addSocketStatusListener(SocketStatusListener l) {
        this.connectDisconnectListeners.addFirst(l);
    }

    public void addSocketDataListener(SocketDataListener l) {
        this.messageReadListeners.addFirst(l);
    }

    public void fireStatusEvent(String message, boolean isConnected) {
        this.getSocketInformation().isConnected = isConnected;
        this.event.message = message;
        this.event.valid = true;
        ListIterator en = this.connectDisconnectListeners.listIterator();
        while (en.hasNext() && this.event.valid) {
            SocketStatusListener temp = (SocketStatusListener)en.next();
            temp.socketStatusChanged(this.event);
        }
    }

    public void fireReadEvent(String message) {
        if (stripcodes) {
            message = ClientUtils.strip(message);
        }
        this.event.message = message;
        this.event.valid = true;
        ListIterator en = this.messageReadListeners.listIterator();
        while (en.hasNext() && this.event.valid) {
            SocketDataListener temp = (SocketDataListener)en.next();
            temp.socketDataRead(this.event);
        }
    }

    static {
        listener2 = null;
    }
}

