/*
 * Decompiled with CFR 0.152.
 */
package rero.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SecureSocket {
    protected SSLSocket socket = null;

    public SecureSocket(String host, int port) throws Exception {
        DummySSLSocketFactory factory = new DummySSLSocketFactory();
        this.socket = (SSLSocket)factory.createSocket(host, port);
        this.socket.startHandshake();
    }

    public Socket getSocket() {
        return this.socket;
    }

    private static class DummyTrustManager
    implements X509TrustManager {
        private DummyTrustManager() {
        }

        public void checkClientTrusted(X509Certificate[] ax509certificate, String authType) {
        }

        public void checkServerTrusted(X509Certificate[] ax509certificate, String authType) {
        }

        public boolean isClientTrusted(X509Certificate[] cert) {
            return true;
        }

        public boolean isServerTrusted(X509Certificate[] cert) {
            return true;
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static class DummySSLSocketFactory
    extends SSLSocketFactory {
        private SSLSocketFactory factory;

        public DummySSLSocketFactory() {
            try {
                SSLContext sslcontext = SSLContext.getInstance("SSL");
                sslcontext.init(null, new TrustManager[]{new DummyTrustManager()}, new SecureRandom());
                this.factory = sslcontext.getSocketFactory();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public static SocketFactory getDefault() {
            return new DummySSLSocketFactory();
        }

        public Socket createSocket(Socket socket, String s, int i, boolean flag) throws IOException {
            return this.factory.createSocket(socket, s, i, flag);
        }

        public Socket createSocket(InetAddress inaddr, int i, InetAddress inaddr1, int j) throws IOException {
            return this.factory.createSocket(inaddr, i, inaddr1, j);
        }

        public Socket createSocket(InetAddress inaddr, int i) throws IOException {
            return this.factory.createSocket(inaddr, i);
        }

        public Socket createSocket(String s, int i, InetAddress inaddr, int j) throws IOException {
            return this.factory.createSocket(s, i, inaddr, j);
        }

        public Socket createSocket(String s, int i) throws IOException {
            return this.factory.createSocket(s, i);
        }

        public String[] getDefaultCipherSuites() {
            return this.factory.getSupportedCipherSuites();
        }

        public String[] getSupportedCipherSuites() {
            return this.factory.getSupportedCipherSuites();
        }
    }
}

