/*
 * Decompiled with CFR 0.152.
 */
package rero.ircfw.data;

import java.util.HashMap;
import java.util.regex.Pattern;
import rero.ircfw.data.DataEventAction;
import rero.ircfw.interfaces.FrameworkConstants;
import rero.util.StringParser;

public class UserHostParser
extends DataEventAction
implements FrameworkConstants {
    protected static Pattern userHostPattern = Pattern.compile("(.*?)=(.*)");

    public boolean isEvent(HashMap data) {
        return "302".equals(data.get("$event"));
    }

    public void process(HashMap data) {
        StringParser temp = new StringParser(data.get("$parms").toString(), userHostPattern);
        if (temp.matches()) {
            String address = temp.getParsedStrings()[1];
            address = address.trim();
            String nick = temp.getParsedStrings()[0];
            nick = nick.trim();
            if (address.charAt(0) == '+' || address.charAt(0) == '-') {
                address = address.substring(1, address.length());
            }
            if (nick.charAt(nick.length() - 1) == '*') {
                nick = nick.substring(0, nick.length() - 1);
            }
            data.put("$nick", nick);
            data.put("$address", address);
        }
    }
}

