/*
 * Decompiled with CFR 0.152.
 */
package rero.ircfw.data;

import java.util.HashMap;
import java.util.regex.Pattern;
import rero.ircfw.data.DataEventAction;
import rero.ircfw.interfaces.FrameworkConstants;
import rero.util.StringParser;

public class MyInformationTracker
extends DataEventAction
implements FrameworkConstants {
    private static String supportPattern = ":.*? 005 .*? (.*?) :.*";
    private static Pattern isSupport = Pattern.compile(supportPattern);

    public boolean isEvent(HashMap data) {
        String temp = (String)data.get("$event");
        if ("001".equals(temp)) {
            return true;
        }
        if ("305".equals(temp)) {
            return true;
        }
        if ("306".equals(temp)) {
            return true;
        }
        return "005".equals(temp);
    }

    public void process(HashMap data) {
        StringParser parser;
        if ("001".equals(data.get("$event"))) {
            this.dataList.setMyNick((String)data.get("$target"));
        }
        if ("305".equals(data.get("$event"))) {
            this.dataList.getMyUserInformation().setBack();
        }
        if ("306".equals(data.get("$event"))) {
            this.dataList.getMyUserInformation().setAway();
        }
        if ("005".equals(data.get("$event")) && (parser = new StringParser(data.get("$raw").toString(), isSupport)).matches()) {
            String[] temp = parser.getParsedString(0).split(" ");
            for (int x = 0; x < temp.length; ++x) {
                if (temp[x].indexOf(61) > -1) {
                    String[] groups;
                    String key = temp[x].substring(0, temp[x].indexOf(61));
                    String value = temp[x].substring(key.length() + 1, temp[x].length());
                    this.dataList.addSupportInfo(key, value);
                    if (key.equals("PREFIX")) {
                        String chars = value.substring(1, value.indexOf(41));
                        String modes = value.substring(chars.length() + 2, value.length());
                        this.dataList.setPrefixInfo(chars, modes);
                        continue;
                    }
                    if (!key.equals("CHANMODES") || (groups = value.split(",")).length != 4) continue;
                    this.dataList.setChanGroupMode("A", groups[0]);
                    this.dataList.setChanGroupMode("B", groups[1]);
                    this.dataList.setChanGroupMode("C", groups[2]);
                    this.dataList.setChanGroupMode("D", groups[3]);
                    continue;
                }
                this.dataList.addSupportInfo(temp[x], "true");
            }
        }
    }
}

