/*
 * Decompiled with CFR 0.152.
 */
package rero.ircfw;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import rero.ircfw.Channel;
import rero.ircfw.User;

public class UserMode {
    private String modes;
    private String chars;

    public UserMode(String m, String c) {
        this.modes = m;
        this.chars = c;
    }

    public Set getUsersWithMode(Channel channel, char mode) {
        LinkedHashSet<User> copy2 = new LinkedHashSet<User>();
        Iterator i = channel.getAllUsers().iterator();
        while (i.hasNext()) {
            User temp = (User)i.next();
            int m = temp.getModeFor(channel);
            if (!this.isMode(m, mode)) continue;
            copy2.add(temp);
        }
        return copy2;
    }

    public boolean isPrefixMode(char m) {
        return this.modes.indexOf(m) > -1;
    }

    public boolean isPrefixChar(char m) {
        return this.chars.indexOf(m) > -1;
    }

    public char getDisplayForMode(char mode) {
        return this.chars.charAt(this.modes.indexOf(mode));
    }

    public char getModeForDisplay(char display) {
        return this.modes.charAt(this.chars.indexOf(display));
    }

    public int getValueFor(char mchar) {
        return 1 << this.modes.length() - this.modes.indexOf(mchar);
    }

    public int setMode(int original, char mchar) {
        int value = this.getValueFor(mchar);
        return original | value;
    }

    public int unsetMode(int original, char mchar) {
        int value = this.getValueFor(mchar);
        return original & ~value;
    }

    public boolean isMode(int original, char mchar) {
        if (mchar == ' ' && original == 0) {
            return true;
        }
        int value = this.getValueFor(mchar);
        return (original & value) == value;
    }

    public String getModes() {
        return this.modes;
    }

    public String getChars() {
        return this.chars;
    }

    public String toString(int original) {
        for (int x = 0; x < this.modes.length(); ++x) {
            if (!this.isMode(original, this.modes.charAt(x))) continue;
            return String.valueOf(this.chars.charAt(x));
        }
        return "";
    }

    public String toString() {
        return "[UCM:(" + this.modes + ")" + this.chars + "]";
    }
}

