/*
 * Decompiled with CFR 0.152.
 */
package rero.ircfw;

import java.util.HashMap;
import java.util.Set;
import rero.ircfw.Channel;
import rero.ircfw.interfaces.FrameworkConstants;

public class User
implements Comparable,
FrameworkConstants {
    protected String nickname = "";
    protected HashMap channels = new HashMap();
    protected String address = "";
    protected long idle = System.currentTimeMillis();

    public void setNick(String n) {
        this.nickname = n;
    }

    public String getNick() {
        return this.nickname;
    }

    public User copy() {
        User temp = new User(this.nickname);
        temp.channels = new HashMap(this.channels);
        temp.address = this.address;
        temp.idle = this.idle;
        return temp;
    }

    public int compareTo(Object b) {
        User bb = (User)b;
        if (bb == null) {
            return -1;
        }
        return this.getNick().toUpperCase().compareTo(bb.getNick().toUpperCase());
    }

    public User(String nick) {
        this.nickname = nick;
    }

    public HashMap getChannelData() {
        return this.channels;
    }

    public Set getChannels() {
        return this.channels.keySet();
    }

    public int getModeFor(Channel ch) {
        return (Integer)this.channels.get(ch);
    }

    public void setModeFor(Channel ch, int modes) {
        this.channels.put(ch, new Integer(modes));
    }

    public void setAddress(String a) {
        this.address = a;
    }

    public String getAddress() {
        return this.address;
    }

    public String getFullAddress() {
        return this.getNick() + "!" + this.getAddress();
    }

    public void touch() {
        this.idle = System.currentTimeMillis();
    }

    public int getIdleTime() {
        return (int)((System.currentTimeMillis() - this.idle) / 1000L);
    }

    public boolean isIdle() {
        return System.currentTimeMillis() - this.idle > 300000L;
    }

    public String toString() {
        return this.getNick();
    }
}

