/*
 * Decompiled with CFR 0.152.
 */
package rero.ircfw;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import rero.ircfw.interfaces.ChatListener;
import rero.ircfw.interfaces.FrameworkConstants;

public class ProtocolDispatcher
implements FrameworkConstants {
    protected LinkedList temporary = new LinkedList();
    protected LinkedList permanent = new LinkedList();
    protected ChatListener internal = null;

    public void dispatchEvent(HashMap eventDescription) {
        String eventId = (String)eventDescription.get("$event");
        int rv = 1;
        if (this.internal != null && this.internal.isChatEvent(eventId, eventDescription)) {
            rv = this.internal.fireChatEvent(eventDescription);
        }
        if (rv == 1) {
            rv = this.easyDispatch(this.temporary, eventId, eventDescription);
        }
        if (rv == 1) {
            rv = this.easyDispatch(this.permanent, eventId, eventDescription);
        }
    }

    private int easyDispatch(List listeners, String eventId, HashMap eventDescription) {
        ListIterator iter = listeners.listIterator();
        while (iter.hasNext()) {
            ChatListener l = (ChatListener)iter.next();
            if (!l.isChatEvent(eventId, eventDescription)) continue;
            int rv = l.fireChatEvent(eventDescription);
            if ((rv & 4) == 4) {
                iter.remove();
            }
            if ((rv & 2) != 2) continue;
            return 2;
        }
        return 1;
    }

    public void addTemporaryListener(ChatListener l) {
        this.temporary.addFirst(l);
    }

    public void addChatListener(ChatListener l) {
        this.permanent.addFirst(l);
    }

    public void setInternalListener(ChatListener l) {
        this.internal = l;
    }
}

