/*
 * Decompiled with CFR 0.152.
 */
package rero.ircfw;

import java.util.HashMap;
import java.util.regex.Pattern;
import rero.ircfw.interfaces.FrameworkConstants;
import rero.util.StringParser;

public class Parsed1459
implements FrameworkConstants {
    protected static String nickPattern = "(.+?)";
    protected static String userPattern = "(.+?)";
    protected static String hostPattern2 = "(.+?)";
    protected static String hostPattern = "([\\w\\-\\=]++[[\\.|\\:][\\w\\-\\=]++]*)";
    protected static String channelPattern = "([\\#|\\&]\\S++)";
    protected static Pattern isHost = Pattern.compile(hostPattern);
    protected static Pattern isNickUserHost = Pattern.compile(nickPattern + "!(" + userPattern + "@" + hostPattern2 + ")");
    protected static Pattern isNick = Pattern.compile(nickPattern);
    protected static Pattern isNumeric = Pattern.compile("\\d++");
    protected static Pattern isColonPresent = Pattern.compile(":(.++)");
    protected static Pattern isWhiteSpace = Pattern.compile("XXX");
    protected HashMap eventInformation;

    public HashMap parseString(String data) {
        this.eventInformation = new HashMap();
        this.eventInformation.put("$raw", data);
        this.phase1(data, this.eventInformation);
        return this.eventInformation;
    }

    private HashMap phase1(String data, HashMap eventInformation) {
        String[] text;
        StringParser parser = new StringParser(data, isColonPresent);
        if (parser.matches()) {
            text = parser.getParsedString(0).split("\\s", 2);
            this.parseSourceInformation(text[0], eventInformation);
            data = text[1];
        }
        if (isNumeric.matcher((text = data.split("\\s", 2))[0]).matches()) {
            eventInformation.put("$numeric", text[0]);
        }
        eventInformation.put("$event", text[0]);
        data = text.length > 1 ? text[1] : "";
        this.parseParameterInformation(data, eventInformation);
        return eventInformation;
    }

    private HashMap parseParameterInformation(String data, HashMap eventInformation) {
        StringParser parser = new StringParser(data, isColonPresent);
        String[] text = data.split("\\s", 2);
        int targetLength = 0;
        if (!parser.matches()) {
            text = data.split("\\s", 2);
            eventInformation.put("$target", text[0]);
            targetLength = text[0].length() + 1;
        } else {
            if ((data.charAt(1) == '#' || data.charAt(1) == '&') && data.indexOf(32) == -1) {
                data = data.substring(1, data.length());
                return this.parseParameterInformation(data, eventInformation);
            }
            data = "<null> " + data;
            targetLength = "<null>".length() + 1;
            text = data.split("\\s", 2);
            parser = new StringParser(data, isColonPresent);
        }
        StringBuffer parmsString = new StringBuffer();
        while (!parser.matches() && text.length > 1) {
            text = data.split("\\s", 2);
            if (text.length <= 1) continue;
            data = text[1];
            parmsString.append(text[0]);
            parmsString.append(" ");
            parser = new StringParser(data, isColonPresent);
        }
        if (parser.matches()) {
            parmsString.append(parser.getParsedString(0));
        } else if (!data.equals(":")) {
            parmsString.append(data);
        }
        eventInformation.put("$data", parmsString.toString());
        if (targetLength < parmsString.toString().length()) {
            eventInformation.put("$parms", parmsString.toString().substring(targetLength, parmsString.toString().length()));
        } else {
            eventInformation.put("$parms", "");
        }
        return eventInformation;
    }

    private HashMap parseSourceInformation(String text, HashMap eventInformation) {
        StringParser parser = new StringParser(text, isNickUserHost);
        if (parser.matches()) {
            String[] data = parser.getParsedStrings();
            eventInformation.put("$nick", data[0]);
            eventInformation.put("$address", data[1]);
            eventInformation.put("$user", data[2]);
            eventInformation.put("$host", data[3]);
            eventInformation.put("$source", data[0]);
            return eventInformation;
        }
        parser = new StringParser(text, isHost);
        if (parser.matches()) {
            String[] data = parser.getParsedStrings();
            eventInformation.put("$server", data[0]);
            eventInformation.put("$nick", data[0]);
            eventInformation.put("$source", data[0]);
            return eventInformation;
        }
        parser = new StringParser(text, isNick);
        if (parser.matches()) {
            String[] data = parser.getParsedStrings();
            eventInformation.put("$nick", data[0]);
            eventInformation.put("$source", data[0]);
        }
        return eventInformation;
    }
}

