/*
 * Decompiled with CFR 0.152.
 */
package rero.ircfw;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import rero.ircfw.Channel;
import rero.ircfw.MyUser;
import rero.ircfw.User;
import rero.ircfw.UserMode;
import rero.ircfw.interfaces.ChannelDataWatch;

public class InternalDataList {
    protected String myNickname = "<Unknown>";
    protected HashMap users = new HashMap();
    protected MyUser myInformation = new MyUser();
    protected HashMap channels = new HashMap();
    protected HashMap sync = new HashMap();
    protected HashMap wasOn = new HashMap();
    protected UserMode umode = new UserMode("ohv", "@%+");
    protected HashMap iSupport = new HashMap();
    protected HashMap chanModes = new HashMap();

    public void reset() {
        this.myNickname = "<Unknown>";
        this.users = new HashMap();
        this.myInformation = new MyUser();
        this.channels = new HashMap();
        this.umode = new UserMode("ohv", "@%+");
        this.iSupport = new HashMap();
        this.chanModes = new HashMap();
    }

    public boolean isChanGroupMode(String group, char mode) {
        if (!this.chanModes.containsKey(group)) {
            return false;
        }
        String modes = (String)this.chanModes.get(group);
        return modes.indexOf(mode) > -1;
    }

    public void setChanGroupMode(String group, String modes) {
        this.chanModes.put(group, modes);
    }

    public Set getChannelsFromPriorLife(String nick) {
        Set temp = (Set)this.wasOn.get(nick);
        this.wasOn.remove(temp);
        return temp;
    }

    public HashMap getSupportInfo() {
        return this.iSupport;
    }

    public void addSupportInfo(String key, String value) {
        this.iSupport.put(key, value);
    }

    public String getMyNick() {
        return this.myNickname;
    }

    public User getMyUser() {
        return this.getUser(this.getMyNick());
    }

    public UserMode getPrefixInfo() {
        return this.umode;
    }

    public void setPrefixInfo(String modes, String chars) {
        this.umode = new UserMode(modes, chars);
    }

    public void setMyNick(String n) {
        this.myNickname = n;
    }

    public MyUser getMyUserInformation() {
        return this.myInformation;
    }

    public void installChannelWatch(String channel, ChannelDataWatch ch) {
        this.sync.put(channel.toUpperCase(), ch);
    }

    public ChannelDataWatch getChannelDataWatch(Channel ch) {
        return (ChannelDataWatch)this.sync.get(ch.getName().toUpperCase());
    }

    public LinkedList nickCompleteAll(String pnick, String channel) {
        LinkedList<String> rv = new LinkedList<String>();
        if (this.getChannel(channel) != null) {
            Set users = this.getChannel(channel).getAllUsers();
            Iterator i = users.iterator();
            while (i.hasNext()) {
                User temp = (User)i.next();
                if (temp.getNick().length() < pnick.length()) continue;
                if (temp.getNick().toLowerCase().substring(0, pnick.length()).equals(pnick.toLowerCase())) {
                    rv.addFirst(temp.getNick());
                    continue;
                }
                if (temp.getNick().toLowerCase().indexOf(pnick.toLowerCase()) <= -1 || temp.getNick().toLowerCase().equals(this.getMyNick().toLowerCase())) continue;
                rv.addLast(temp.getNick());
            }
        }
        rv.addLast(pnick);
        return rv;
    }

    public String nickComplete(String pnick, String channel) {
        if (this.getChannel(channel) == null) {
            return pnick;
        }
        Set users = this.getChannel(channel).getAllUsers();
        if (this.isUser(pnick) && users.contains(this.getUser(pnick))) {
            return pnick;
        }
        String possible = null;
        Iterator i = users.iterator();
        while (i.hasNext()) {
            User temp = (User)i.next();
            if (temp.getNick().length() < pnick.length()) continue;
            if (temp.getNick().toLowerCase().substring(0, pnick.length()).equals(pnick.toLowerCase())) {
                return temp.getNick();
            }
            if (temp.getNick().toLowerCase().indexOf(pnick.toLowerCase()) <= -1 || temp.getNick().toLowerCase().equals(this.getMyNick().toLowerCase())) continue;
            possible = temp.getNick();
        }
        if (possible != null) {
            return possible;
        }
        return pnick;
    }

    public Collection getAllUsers() {
        return this.users.values();
    }

    public String toString() {
        return "[IDL for " + this.myNickname + " - users: " + this.users.size() + ", channels:  " + this.channels.size() + "]";
    }

    public boolean isUser(String nickname) {
        return this.users.get(nickname) != null;
    }

    public User getUser(String nickname) {
        if (this.users.get(nickname) == null) {
            this.users.put(nickname, new User(nickname));
        }
        return (User)this.users.get(nickname);
    }

    public Set getUsersWithMode(String channel, char mode) {
        return this.umode.getUsersWithMode(this.getChannel(channel), mode);
    }

    public void QuitNick(String nickname) {
        HashSet<String> oldchannels = new HashSet<String>();
        Iterator iter = new LinkedList(this.getUser(nickname).getChannels()).iterator();
        while (iter.hasNext()) {
            Channel temp = (Channel)iter.next();
            this.RemoveUser(this.getUser(nickname), temp);
            oldchannels.add(temp.getName());
        }
        this.wasOn.put(nickname, oldchannels);
        this.users.remove(nickname);
    }

    public void PartNick(String nickname, Channel channel) {
        if (this.getMyNick().equals(nickname)) {
            Iterator iter = channel.getAllUsers().iterator();
            while (iter.hasNext()) {
                User temp = (User)iter.next();
                temp.getChannelData().remove(channel);
                if (temp.getChannelData().size() != 0) continue;
                this.users.remove(temp);
            }
            channel.getAllUsers().clear();
            this.channels.remove(channel.getName().toUpperCase());
        }
        this.RemoveUser(this.getUser(nickname), channel);
    }

    public void JoinNick(String nickname, String channel) {
        if (this.getMyNick().equals(nickname)) {
            this.createChannel(channel);
        }
        this.getUser(nickname).getChannelData().put(this.getChannel(channel), new Integer(0));
        this.getChannel(channel).getAllUsers().add(this.getUser(nickname));
        if (this.getChannelDataWatch(this.getChannel(channel)) != null) {
            this.getChannelDataWatch(this.getChannel(channel)).userAdded(this.getUser(nickname));
        }
    }

    public void ChangeNick(String oldnick, String newnick) {
        Channel channel;
        User temp = this.getUser(oldnick);
        Iterator iter = temp.getChannels().iterator();
        while (iter.hasNext()) {
            channel = (Channel)iter.next();
            channel.getAllUsers().remove(temp);
        }
        this.users.remove(oldnick);
        temp.setNick(newnick);
        this.users.put(newnick, temp);
        iter = temp.getChannels().iterator();
        while (iter.hasNext()) {
            channel = (Channel)iter.next();
            channel.getAllUsers().add(temp);
            if (this.getChannelDataWatch(channel) == null) continue;
            this.getChannelDataWatch(channel).userChanged();
        }
        if (oldnick.equals(this.getMyNick())) {
            this.setMyNick(newnick);
        }
    }

    public boolean isOn(User user, Channel channel) {
        return user != null && user.getChannels().contains(channel);
    }

    public void AddUser(String nickname, Channel channel) {
        int modes = 0;
        while (this.umode.isPrefixChar(nickname.charAt(0))) {
            modes = this.umode.setMode(modes, this.umode.getModeForDisplay(nickname.charAt(0)));
            nickname = nickname.substring(1, nickname.length());
        }
        User user = this.getUser(nickname);
        if (user.getChannelData().containsKey(channel)) {
            if ((Integer)user.getChannelData().get(channel) != modes) {
                user.getChannelData().put(channel, new Integer(modes));
            }
        } else {
            user.getChannelData().put(channel, new Integer(modes));
            channel.getAllUsers().add(user);
        }
    }

    public Channel getChannel(String channel) {
        return (Channel)this.channels.get(channel.toUpperCase());
    }

    public void createChannel(String channel) {
        this.channels.put(channel.toUpperCase(), new Channel(channel));
        if (this.getChannelDataWatch(this.getChannel(channel)) != null) {
            this.getChannelDataWatch(this.getChannel(channel)).createChannel(this.getChannel(channel));
        }
    }

    public void synchronizeUserPreChange(User user, Channel channel) {
        channel.getAllUsers().remove(user);
    }

    public void synchronizeUserPostChange(User user, Channel channel) {
        channel.getAllUsers().add(user);
        if (this.getChannelDataWatch(channel) != null) {
            this.getChannelDataWatch(channel).userChanged();
        }
    }

    public void RemoveUser(User user, Channel channel) {
        channel.getAllUsers().remove(user);
        user.getChannelData().remove(channel);
        if (user.getChannelData().size() == 0) {
            this.users.remove(user);
        }
        if (this.getChannelDataWatch(channel) != null) {
            this.getChannelDataWatch(channel).userRemoved(user);
        }
    }
}

