/*
 * Decompiled with CFR 0.152.
 */
package rero.ircfw;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import rero.ircfw.User;
import rero.ircfw.data.GenericMode;
import rero.ircfw.interfaces.FrameworkConstants;

public class Channel
implements FrameworkConstants,
Comparator {
    protected String topic = "";
    protected int limit;
    protected String key;
    protected GenericMode mode = new GenericMode();
    protected String name;
    protected SortedSet allusers = Collections.synchronizedSortedSet(new TreeSet(this));

    public void setTopic(String t) {
        this.topic = t;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setLimit(int l) {
        this.limit = l;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setKey(String k) {
        this.key = k;
    }

    public String getKey() {
        return this.key;
    }

    public void setMode(String m) {
        this.mode = new GenericMode(m);
    }

    public GenericMode getMode() {
        return this.mode;
    }

    public String getName() {
        return this.name;
    }

    public Channel(String name) {
        this.name = name;
    }

    public int compare(Object aa, Object bb) {
        User a = (User)aa;
        User b = (User)bb;
        if (a == null || b == null) {
            return 0;
        }
        int aM = a.getModeFor(this);
        int bM = b.getModeFor(this);
        int result = bM - aM;
        if (result == 0) {
            return a.compareTo(b);
        }
        return result;
    }

    public Set getAllUsers() {
        return this.allusers;
    }

    public String toString() {
        StringBuffer temp = new StringBuffer();
        temp.append(this.getName());
        temp.append(" \"");
        temp.append(this.getTopic());
        temp.append("\", ");
        temp.append(this.getMode());
        if (this.getMode().isSet('k')) {
            temp.append(" key=" + this.key);
        }
        if (this.getMode().isSet('l')) {
            temp.append(" limit=" + this.limit);
        }
        temp.append(", ");
        Iterator iter = this.getAllUsers().iterator();
        while (iter.hasNext()) {
            User tempa = (User)iter.next();
            temp.append("?");
            temp.append(tempa.getNick());
            temp.append(" ");
        }
        return temp.toString();
    }
}

