/*
 * Decompiled with CFR 0.152.
 */
package rero.ircfw;

import java.util.HashMap;
import java.util.regex.Pattern;
import rero.ircfw.interfaces.FrameworkConstants;
import rero.util.StringParser;

public class CTCPParser
implements FrameworkConstants {
    protected static String ctcpPattern = "\u0001(\\w++)(\\s*)(.*)\u0001";
    protected static Pattern isCTCP = Pattern.compile(ctcpPattern);

    public HashMap parseEvent(HashMap eventData) {
        String event = (String)eventData.get("$event");
        String parms = (String)eventData.get("$parms");
        String target = (String)eventData.get("$target");
        if (!event.equals("NOTICE") && !event.equals("PRIVMSG") || parms == null) {
            return eventData;
        }
        StringParser parser = new StringParser(parms, isCTCP);
        if (!parser.matches()) {
            return eventData;
        }
        String type = parser.getParsedString(0);
        String parameters = parser.getParsedString(2);
        parms = type + " " + parameters;
        String data = target + " " + parms;
        if (event.equals("PRIVMSG") && type.equals("ACTION")) {
            event = "ACTION";
            data = target + " " + parameters;
            String whitespace = parser.getParsedString(1);
            if (whitespace.length() > 1) {
                parameters = whitespace.substring(1) + parameters;
            }
            parms = parameters;
        }
        if (event.equals("PRIVMSG")) {
            event = "REQUEST";
        }
        if (event.equals("NOTICE")) {
            event = "REPLY";
        }
        eventData.put("$data", data);
        eventData.put("$parms", parms);
        eventData.put("$event", event);
        eventData.put("$type", type);
        return eventData;
    }
}

