/*
 * Decompiled with CFR 0.152.
 */
package rero.ident;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;
import java.util.LinkedList;
import rero.config.ClientDefaults;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.ident.IdentListener;

public class IdentDaemon
implements Runnable,
ClientStateListener {
    private static IdentDaemon identd;
    protected LinkedList listeners = new LinkedList();
    private Thread serverThread;
    private Socket activeClient;
    private ServerSocket listener;
    private BufferedReader socketInput;
    private PrintWriter socketOutput;

    public void addIdentListener(IdentListener l) {
        this.listeners.add(new WeakReference<IdentListener>(l));
    }

    public void fireEvent(String host, String text) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            WeakReference temp = (WeakReference)i.next();
            if (temp.get() == null) continue;
            ((IdentListener)temp.get()).identRequest(host, text);
        }
    }

    public static void initialize() {
        identd = new IdentDaemon();
    }

    public static IdentDaemon getIdentDaemon() {
        return identd;
    }

    public void propertyChanged(String key, String value) {
        this.setup();
    }

    public IdentDaemon() {
        ClientState.getClientState().addClientStateListener("ident.enabled", this);
        this.setup();
    }

    public void setup() {
        if (ClientState.getClientState().isOption("ident.enabled", ClientDefaults.ident_enabled) && this.serverThread == null) {
            this.serverThread = new Thread(this);
            this.serverThread.setPriority(1);
            this.serverThread.setName("jIRCii Ident Daemon");
            this.serverThread.start();
        } else if (!ClientState.getClientState().isOption("ident.enabled", ClientDefaults.ident_enabled) && this.serverThread != null) {
            this.close();
        }
    }

    public void close() {
        if (this.serverThread != null) {
            if (this.listener != null && !this.listener.isClosed()) {
                try {
                    this.listener.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (this.activeClient != null && !this.activeClient.isClosed()) {
                try {
                    this.activeClient.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.serverThread.interrupt();
            this.serverThread = null;
        }
    }

    public void run() {
        try {
            this.listener = new ServerSocket(ClientState.getClientState().getInteger("ident.port", 113));
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
            this.close();
            return;
        }
        while (Thread.currentThread() == this.serverThread) {
            try {
                this.activeClient = this.listener.accept();
                if (this.activeClient == null || !this.activeClient.isConnected()) continue;
                this.socketInput = new BufferedReader(new InputStreamReader(this.activeClient.getInputStream()));
                this.socketOutput = new PrintWriter(this.activeClient.getOutputStream(), true);
                String text = this.socketInput.readLine();
                this.fireEvent(this.activeClient.getInetAddress().getHostAddress(), text);
                this.socketOutput.print(text + " : USERID : " + ClientState.getClientState().getString("ident.system", ClientDefaults.ident_system) + " : " + ClientState.getClientState().getString("ident.userid", ClientDefaults.ident_userid));
                this.socketOutput.flush();
                this.socketInput.close();
                this.socketOutput.close();
                this.activeClient.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    Thread.sleep(10000L);
                    if (this.listener != null && !this.listener.isClosed()) continue;
                    this.listener = new ServerSocket(ClientState.getClientState().getInteger("ident.port", 113));
                }
                catch (Exception ex1) {
                    ex1.printStackTrace();
                }
            }
        }
    }
}

