/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.windows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rero.client.Capabilities;
import rero.client.notify.Lag;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.gui.IRCAwareComponent;
import rero.gui.background.BackgroundToolBar;
import rero.gui.windows.StatusWindow;
import text.LabelDisplay;

public class WindowStatusBar
extends BackgroundToolBar
implements IRCAwareComponent,
ChangeListener,
ClientStateListener {
    protected LabelDisplay contents = new LabelDisplay();
    protected HashMap event;
    protected StatusWindow parent;
    protected Capabilities capabilities;
    protected long lastRehash;

    public void installCapabilities(Capabilities c) {
        this.capabilities = c;
        Lag temp = (Lag)this.capabilities.getDataStructure("lag");
        temp.addChangeListener(this);
    }

    public void stateChanged(ChangeEvent ev) {
        this.rehash();
        this.repaint();
    }

    public WindowStatusBar(StatusWindow _parent) {
        this.setFloatable(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.contents, "Center");
        this.event = new HashMap();
        this.parent = _parent;
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.rehashValues();
        ClientState.getClientState().addClientStateListener("ui.sbarlines", this);
        ClientState.getClientState().addClientStateListener("ui.showsbar", this);
        ClientState.getClientState().addClientStateListener("ui.font", this);
    }

    public Dimension getPreferredSize() {
        if (this.contents.getTotalLines() == 0) {
            return new Dimension(Integer.MAX_VALUE, 1);
        }
        return super.getPreferredSize();
    }

    public void rehashValues() {
        if (ClientState.getClientState().isOption("ui.showsbar", true)) {
            int lines = ClientState.getClientState().getInteger("ui.sbarlines", 1);
            this.contents.setNumberOfLines(lines);
        } else {
            this.contents.setNumberOfLines(0);
        }
    }

    public void propertyChanged(String var, String parms) {
        if (var.equals("statusbar")) {
            this.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WindowStatusBar.this.rehashValues();
                    WindowStatusBar.this.rehash();
                    WindowStatusBar.this.revalidate();
                    WindowStatusBar.this.repaint();
                }
            });
        }
    }

    public void rehash() {
        if (this.capabilities == null) {
            return;
        }
        this.event.put("$query", this.parent.getQuery());
        this.event.put("$window", this.parent.getName());
        for (int x = 0; x < this.contents.getTotalLines(); ++x) {
            this.event.put("$line", "" + x);
            String lhs = this.capabilities.getOutputCapabilities().parseSet(this.event, "SBAR_LEFT");
            String rhs = this.capabilities.getOutputCapabilities().parseSet(this.event, "SBAR_RIGHT");
            if (lhs == null) {
                lhs = "";
            }
            if (rhs == null) {
                rhs = "";
            }
            this.contents.setLine(lhs, rhs, x);
        }
        this.lastRehash = System.currentTimeMillis();
    }

    public void paint(Graphics g) {
        if (System.currentTimeMillis() - this.lastRehash > 10000L) {
            this.rehash();
        }
        super.paint(g);
    }
}

