/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.windows;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.gui.windows.StatusWindow;
import rero.gui.windows.SwitchBarOptions;

public abstract class WindowManager
extends JPanel
implements ClientStateListener,
ActionListener {
    protected SwitchBarOptions switchOptions;
    protected JToolBar switchbar;
    protected LinkedList windows;
    protected HashMap windowMap;
    protected boolean isRelative;

    public StatusWindow getWindowFor(Object o) {
        return (StatusWindow)this.windowMap.get(o);
    }

    public void addToSwitchbar(StatusWindow window) {
        if (ClientState.getClientState().isOption("switchbar.sort", false)) {
            Iterator i = this.windows.iterator();
            int pos = 0;
            while (i.hasNext()) {
                StatusWindow temp = (StatusWindow)i.next();
                if (window.compareTo(temp) < 0) {
                    this.switchbar.add((Component)window.getButton(), pos);
                    this.windows.add(pos, window);
                    this.switchbar.revalidate();
                    return;
                }
                ++pos;
            }
        }
        this.windows.add(window);
        this.switchbar.add(window.getButton());
        this.switchbar.revalidate();
    }

    public void actionPerformed(ActionEvent e) {
        JToggleButton source = (JToggleButton)e.getSource();
        if (source.isSelected()) {
            this.doActivate(this.getWindowFor(e.getSource()));
        } else {
            this.doDeactivate(this.getWindowFor(e.getSource()));
            int index = this.windows.indexOf(this.getWindowFor(e.getSource()));
            this.newActive(index, false);
        }
    }

    public void newActive(int index, boolean includeCurrent) {
        StatusWindow temp;
        int x;
        for (x = index - 1; x >= 0; --x) {
            temp = (StatusWindow)this.windows.get(x);
            if (temp == null || temp.getWindow().isIcon()) continue;
            this.doActivate(temp);
            return;
        }
        if (includeCurrent) {
            index = -1;
        }
        for (x = this.windows.size() - 1; x > index; --x) {
            temp = (StatusWindow)this.windows.get(x);
            if (temp == null || temp.getWindow().isIcon()) continue;
            this.doActivate(temp);
            return;
        }
    }

    public void propertyChanged(String key, String value) {
        this.isRelative = ClientState.getClientState().isOption("window.relative", false);
        if (ClientState.getClientState().isOption("switchbar.sort", false)) {
            this.switchbar.removeAll();
            Collections.sort(this.windows);
            Iterator i = this.windows.iterator();
            while (i.hasNext()) {
                StatusWindow window = (StatusWindow)i.next();
                this.switchbar.add(window.getButton());
            }
            this.switchbar.revalidate();
        }
    }

    public WindowManager() {
        this.init();
        ClientState.getClientState().addClientStateListener("switchbar.sort", this);
        ClientState.getClientState().addClientStateListener("window", this);
        this.isRelative = ClientState.getClientState().isOption("window.relative", false);
    }

    public LinkedList getAllWindows() {
        return this.windows;
    }

    public abstract void init();

    public abstract void addWindow(StatusWindow var1, boolean var2);

    public abstract StatusWindow getActiveWindow();

    protected abstract void doActivate(StatusWindow var1);

    protected abstract void doDeactivate(StatusWindow var1);
}

