/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.windows;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import rero.bridges.menu.MenuBridge;
import rero.client.Capabilities;
import rero.config.ClientState;
import rero.gui.IRCAwareComponent;
import rero.gui.IRCSession;
import rero.gui.background.BackgroundPanel;
import rero.gui.input.InputField;
import rero.gui.windows.ClientWindow;
import rero.gui.windows.ClientWindowEvent;
import rero.gui.windows.ClientWindowListener;
import rero.gui.windows.SwitchBarOptions;
import rero.gui.windows.WindowStatusBar;
import rero.util.ClientUtils;
import text.WrappedDisplay;

public class StatusWindow
extends BackgroundPanel
implements IRCAwareComponent,
Comparable {
    public static final String STATUS_NAME = "%STATUS%";
    protected WrappedDisplay display;
    protected InputField input;
    protected WindowStatusBar statusbar;
    protected JToggleButton button;
    protected ImageIcon icon;
    protected ClientWindow frame;
    protected String query = "";
    protected Capabilities capabilities;
    protected Color defaultForegroundColor;
    protected MenuBridge menuManager;

    public void cleanup() {
        if (this.display != null) {
            this.display.clear();
        }
    }

    public void touch() {
        this.statusbar.rehash();
        this.statusbar.repaint();
    }

    protected void maybeShowPopup(MouseEvent ev, String desc) {
        JPopupMenu menu;
        if (ev.isPopupTrigger() && (menu = this.getPopupMenu(desc, ClientUtils.getEventHashMap(this.getName(), this.getName()))) != null) {
            menu.show((JComponent)ev.getComponent(), ev.getX(), ev.getY());
            ev.consume();
        }
    }

    public void installCapabilities(Capabilities c) {
        this.capabilities = c;
        this.statusbar.installCapabilities(c);
        this.menuManager = (MenuBridge)c.getDataStructure("menuBridge");
        this.input.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent ev) {
                StatusWindow.this.maybeShowPopup(ev, "input");
            }

            public void mouseReleased(MouseEvent ev) {
                StatusWindow.this.maybeShowPopup(ev, "input");
            }

            public void mouseClicked(MouseEvent ev) {
                StatusWindow.this.maybeShowPopup(ev, "input");
            }
        });
        MouseAdapter normal = new MouseAdapter(){

            public void mousePressed(MouseEvent ev) {
                StatusWindow.this.maybeShowPopup(ev, StatusWindow.this.getWindowType());
            }

            public void mouseReleased(MouseEvent ev) {
                StatusWindow.this.maybeShowPopup(ev, StatusWindow.this.getWindowType());
            }

            public void mouseClicked(MouseEvent ev) {
                StatusWindow.this.maybeShowPopup(ev, StatusWindow.this.getWindowType());
            }
        };
        this.display.addMouseListener(normal);
    }

    public JPopupMenu getPopupMenu(String name, HashMap event) {
        return this.menuManager.getPopupMenu(name, event);
    }

    public InputField getInput() {
        return this.input;
    }

    public WrappedDisplay getDisplay() {
        return this.display;
    }

    public WindowStatusBar getStatusBar() {
        return this.statusbar;
    }

    public void flag() {
        if (!this.getWindow().isSelected() && SwitchBarOptions.isHilightOn()) {
            this.getButton().setForeground(SwitchBarOptions.getHighlightColor());
        }
    }

    public void unflag() {
        if (SwitchBarOptions.isHilightOn()) {
            this.getButton().setForeground(this.defaultForegroundColor);
            this.getButton().repaint();
        }
    }

    public void init(ClientWindow _frame) {
        this.frame = _frame;
        this.frame.addWindowListener(new ClientWindowStuff());
        this.setLayout(new BorderLayout());
        this.display = new WrappedDisplay();
        this.input = new InputField();
        this.statusbar = new WindowStatusBar(this);
        this.add((Component)this.display, "Center");
        JPanel space = new JPanel();
        space.setLayout(new BorderLayout());
        space.add((Component)this.statusbar, "North");
        space.add((Component)this.input, "South");
        space.setOpaque(false);
        this.add((Component)space, "South");
        this.frame.setContentPane(this);
        this.setTitle(this.getName());
        this.frame.setIcon(this.getImageIcon());
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String q) {
        this.query = q;
        this.statusbar.stateChanged(null);
    }

    public void setTitle(String title) {
        if (title != null && title.equals(STATUS_NAME)) {
            title = "Status";
        }
        this.frame.setTitle(title);
    }

    public ClientWindow getWindow() {
        return this.frame;
    }

    public String getTitle() {
        return this.frame.getTitle();
    }

    public void setName(String name) {
        this.getButton().setText(this.getName());
        this.getButton().repaint();
        this.setTitle(this.getName());
        this.touch();
    }

    public String getName() {
        return STATUS_NAME;
    }

    public ImageIcon getImageIcon() {
        if (this.icon == null) {
            this.icon = new ImageIcon(ClientState.getClientState().getResource("status.gif"));
        }
        return this.icon;
    }

    public JToggleButton getButton() {
        if (this.button == null) {
            this.button = this.getName().equals(STATUS_NAME) ? new JToggleButton("Status", this.getImageIcon()) : new JToggleButton(this.getName(), this.getImageIcon());
            this.button.setHorizontalAlignment(2);
            this.button.setMargin(new Insets(0, 0, 0, 5));
            this.button.setFocusPainted(false);
            this.button.setPreferredSize(new Dimension(95, this.button.getPreferredSize().height));
            this.button.setSelected(false);
            this.defaultForegroundColor = this.button.getForeground();
            this.button.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent ev) {
                    int onmask = 1088;
                    if ((ev.getModifiersEx() & onmask) == onmask) {
                        String text = ((JToggleButton)ev.getSource()).getText();
                        IRCSession session = StatusWindow.this.capabilities.getGlobalCapabilities().getSessionManager().getActiveSession();
                        session.getWindow(text).getWindow().closeWindow();
                    } else {
                        StatusWindow.this.maybeShowPopup(ev, "switchbar");
                    }
                }

                public void mouseReleased(MouseEvent ev) {
                    StatusWindow.this.maybeShowPopup(ev, "switchbar");
                }

                public void mouseClicked(MouseEvent ev) {
                    StatusWindow.this.maybeShowPopup(ev, "switchbar");
                }
            });
        }
        return this.button;
    }

    public String getWindowType() {
        return "Status";
    }

    public int compareTo(Object o) {
        StatusWindow temp = (StatusWindow)o;
        if (this.compareWindowType() == temp.compareWindowType()) {
            return this.getName().toUpperCase().compareTo(((StatusWindow)o).getName().toUpperCase());
        }
        return this.compareWindowType() - temp.compareWindowType();
    }

    public int compareWindowType() {
        return 1;
    }

    public boolean isLegalWindow() {
        return true;
    }

    protected class ClientWindowStuff
    implements ClientWindowListener {
        protected ClientWindowStuff() {
        }

        public void onActive(ClientWindowEvent ev) {
            StatusWindow.this.unflag();
        }

        public void onOpen(ClientWindowEvent ev) {
        }

        public void onInactive(ClientWindowEvent ev) {
        }

        public void onMinimize(ClientWindowEvent ev) {
        }

        public void onClose(ClientWindowEvent ev) {
            StatusWindow.this.cleanup();
        }
    }
}

