/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.windows;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import rero.gui.toolkit.GeneralListModel;
import rero.gui.windows.GeneralListDialog;
import rero.script.ScriptCore;
import rero.util.ClientUtils;
import sleep.runtime.Scalar;
import text.AttributedString;
import text.TextSource;

public class ScriptedListDialog
extends GeneralListDialog {
    public ScriptedListDialog(String title, String hook, Object data, LinkedList cols) {
        super(title, hook, new ScriptedListModel(cols, data));
    }

    public void refreshData() {
        this.model.fireTableDataChanged();
    }

    public void init() {
        ((ScriptedListModel)this.model).install(this.popupHook, this.capabilities.getScriptCore());
    }

    private static class ScriptedListModel
    extends GeneralListModel {
        private Scalar data;
        private LinkedList cols;
        private ScriptCore script;
        private String popupHook;

        public void install(String popup, ScriptCore s) {
            this.script = s;
            this.popupHook = popup;
        }

        public ScriptedListModel(LinkedList headers, Object scalar) {
            this.cols = headers;
            this.data = (Scalar)scalar;
        }

        public void sortColumn(int col, boolean ascending) {
            this.data.getArray().sort(new ScriptedCompare(col, ascending));
            this.fireTableDataChanged();
        }

        public HashMap getEventHashMap(int row) {
            return ClientUtils.getEventHashMap(row + "", "");
        }

        public int getRowCount() {
            return this.data.getArray().size();
        }

        public int getColumnCount() {
            return this.cols.size();
        }

        public int getColumnWidth(int col) {
            return (int)((double)TextSource.fontMetrics.stringWidth(this.cols.get(col).toString()) * 1.5);
        }

        public String getColumnName(int col) {
            return this.cols.get(col).toString();
        }

        public Object getValueAt(int row, int col) {
            String temp;
            String[] blah;
            if (row < this.getRowCount() && col < this.getColumnCount() && col < (blah = (temp = this.data.getArray().getAt(row).toString()).split("\t")).length) {
                AttributedString tempa = AttributedString.CreateAttributedString(blah[col]);
                tempa.assignWidths();
                return tempa;
            }
            return null;
        }

        public boolean isSortable(int col) {
            return true;
        }
    }

    public static class ScriptedCompare
    implements Comparator {
        private int col;
        private boolean rev;

        public ScriptedCompare(int column, boolean reverse2) {
            this.rev = reverse2;
            this.col = column;
        }

        public int compare(Object a, Object b) {
            if (this.rev) {
                Object c = b;
                b = a;
                a = c;
            }
            String[] sa = a.toString().toLowerCase().split("\t");
            String[] sb = b.toString().toLowerCase().split("\t");
            try {
                int na = Integer.parseInt(sa[this.col]);
                int nb = Integer.parseInt(sb[this.col]);
                return na - nb;
            }
            catch (Exception ex) {
                return sa[this.col].compareTo(sb[this.col]);
            }
        }
    }
}

