/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.windows;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import rero.config.ClientState;
import rero.config.ClientStateListener;

public class ListBoxOptions
implements ClientStateListener {
    protected JComponent container;
    protected JComponent listbox;

    public ListBoxOptions(JComponent c, JComponent l) {
        this.container = c;
        this.listbox = l;
        ClientState.getClientState().addClientStateListener("listbox.position", this);
        ClientState.getClientState().addClientStateListener("listbox.enabled", this);
        this.rehash();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rehash() {
        JComponent jComponent = this.listbox;
        synchronized (jComponent) {
            this.container.remove(this.listbox);
            boolean enabled = ClientState.getClientState().isOption("listbox.enabled", true);
            int position = ClientState.getClientState().getInteger("listbox.position", 1);
            if (enabled) {
                if (position == 0) {
                    this.container.add((Component)this.listbox, "West");
                } else {
                    this.container.add((Component)this.listbox, "East");
                }
            }
        }
    }

    public void propertyChanged(String key, String value) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ListBoxOptions.this.rehash();
                ListBoxOptions.this.container.revalidate();
            }
        });
    }
}

